/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.editor.extension;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.common.configuration.CFGComparableProperty;
import org.eclipse.hyades.models.common.configuration.CFGConfigurableObject;
import org.eclipse.hyades.models.common.configuration.CFGPropertyGroup;
import org.eclipse.hyades.models.common.configuration.Common_ConfigurationFactory;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.editor.extension.BaseEditorExtension;
import org.eclipse.hyades.test.ui.editor.form.util.EditorForm;
import org.eclipse.hyades.test.ui.editor.form.util.WidgetFactory;
import org.eclipse.hyades.test.ui.internal.editor.extension.IExtensibleEditorExtension;
import org.eclipse.hyades.test.ui.internal.editor.form.ConfigurableObjectOverviewForm;
import org.eclipse.hyades.test.ui.internal.editor.form.IPropertyGroupForm;
import org.eclipse.hyades.test.ui.internal.editor.form.PropertyGroupForm;
import org.eclipse.hyades.ui.editor.IHyadesEditorPart;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;

public class ConfigurableObjectEditorExtension
extends BaseEditorExtension
implements IExtensibleEditorExtension {
    IConfigurationElement[] registeredExtensionElements;
    private Hashtable extensionPagesMap = new Hashtable();
    protected static final int PAGE_OVERVIEW = 0;
    private ConfigurableObjectOverviewForm overviewForm;
    private WidgetFactory widgetFactory;

    public ConfigurableObjectEditorExtension() {
        this.registeredExtensionElements = this.collectRegisteredExtensionElements();
    }

    protected IConfigurationElement[] collectRegisteredExtensionElements() {
        IExtensionPoint extPoint = Platform.getPluginRegistry().getExtensionPoint("org.eclipse.hyades.test.ui.configurableObjectExtension");
        if (extPoint != null) {
            return extPoint.getConfigurationElements();
        }
        return new IConfigurationElement[0];
    }

    public void dispose() {
        this.overviewForm.dispose();
        Enumeration elements = this.extensionPagesMap.elements();
        while (elements.hasMoreElements()) {
            ((EditorForm)elements.nextElement()).dispose();
        }
        this.extensionPagesMap.clear();
        if (this.widgetFactory != null) {
            this.widgetFactory.dispose();
        }
        super.dispose();
    }

    public EObject getEditorObject() {
        return (EObject)this.getHyadesEditorPart().getEditorObject();
    }

    public void createPages() {
        IHyadesEditorPart hyadesEditorPart = this.getHyadesEditorPart();
        this.widgetFactory = new WidgetFactory();
        this.overviewForm = this.createOverviewPage(this.widgetFactory);
        this.overviewForm.setRegisteredExtensions(this.registeredExtensionElements);
        this.getHyadesEditorPart().addPage(this.overviewForm.createControl());
        this.getHyadesEditorPart().setPageText(0, TestUIPlugin.getString("W_OVERVIEW"));
        this.overviewForm.updateTitle();
        this.createOtherStaticPages(this.widgetFactory);
        this.createPropertyGroupPages(this.widgetFactory);
    }

    protected ConfigurableObjectOverviewForm createOverviewPage(WidgetFactory widgetFactory) {
        return new ConfigurableObjectOverviewForm(this, widgetFactory);
    }

    protected void createOtherStaticPages(WidgetFactory widgetFactory) {
    }

    protected void createPropertyGroupPages(WidgetFactory widgetFacotory) {
        EObject editorObject = this.getEditorObject();
        EList propertyGroups = null;
        Object editorType = null;
        if (editorObject instanceof CFGConfigurableObject) {
            propertyGroups = ((CFGConfigurableObject)editorObject).getPropertyGroups();
        }
        if (propertyGroups == null || propertyGroups.isEmpty()) {
            return;
        }
        Iterator it = propertyGroups.iterator();
        CFGPropertyGroup propGroup = null;
        String propGroupID = null;
        boolean extensionFound = false;
        while (it.hasNext()) {
            propGroup = (CFGPropertyGroup)it.next();
            if (propGroup.getProperties().isEmpty()) continue;
            propGroupID = propGroup.getPropertyGroupID();
            int i = 0;
            while (i < this.registeredExtensionElements.length) {
                if (this.registeredExtensionElements[i].getAttribute("propertyGroupID").equals(propGroupID)) {
                    this.addExtensionPage(this.registeredExtensionElements[i]);
                    extensionFound = true;
                    break;
                }
                ++i;
            }
            if (extensionFound) continue;
            PropertyGroupForm defaultForm = new PropertyGroupForm();
            defaultForm.init(propGroup, this, this.widgetFactory);
            int index = this.getHyadesEditorPart().addPage(defaultForm.createControl());
            this.getHyadesEditorPart().setPageText(index, propGroup.getName());
            this.extensionPagesMap.put(new Integer(index), defaultForm);
            this.overviewForm.addSection(defaultForm, index);
        }
    }

    protected ConfigurableObjectOverviewForm getOverviewForm() {
        return this.overviewForm;
    }

    public void refreshContent(Object data) {
        this.overviewForm.load();
        this.overviewForm.updateTitle();
    }

    public IStructuredSelection getSelection() {
        int index = this.getHyadesEditorPart().getActivePage();
        if (index == 0) {
            return new StructuredSelection((Object)this.getEditorObject());
        }
        if (this.extensionPagesMap.containsKey(new Integer(index))) {
            return ((IPropertyGroupForm)this.extensionPagesMap.get(new Integer(index))).getSelection();
        }
        return StructuredSelection.EMPTY;
    }

    public boolean pageActivated(int index) {
        if (index == 0) {
            return this.overviewForm.activated();
        }
        if (this.extensionPagesMap.containsKey(new Integer(index))) {
            return ((EditorForm)this.extensionPagesMap.get(new Integer(index))).activated();
        }
        return false;
    }

    public void setSelection(IStructuredSelection structuredSelection) {
        Object object;
        if (structuredSelection.size() == 1 && (object = structuredSelection.getFirstElement()) != this.getEditorObject() && !(object instanceof IConfigurationElement) && object instanceof CFGComparableProperty) {
            EObject container = ((CFGComparableProperty)object).eContainer();
            Enumeration pages = this.extensionPagesMap.elements();
            IPropertyGroupForm page = null;
            while (pages.hasMoreElements()) {
                page = (IPropertyGroupForm)pages.nextElement();
                if (page.getPropertyGroup() != container) continue;
                page.selectReveal((ISelection)structuredSelection);
                break;
            }
        }
    }

    public int addExtensionPage(IConfigurationElement extensionElement) {
        String propertyGroupID = extensionElement.getAttribute("propertyGroupID");
        Enumeration keys = this.extensionPagesMap.keys();
        IPropertyGroupForm page = null;
        while (keys.hasMoreElements()) {
            Integer key = (Integer)keys.nextElement();
            page = (IPropertyGroupForm)this.extensionPagesMap.get(key);
            if (!page.getPropertyGroup().getPropertyGroupID().equals(propertyGroupID)) continue;
            return key;
        }
        IPropertyGroupForm formExt = null;
        try {
            formExt = (IPropertyGroupForm)extensionElement.createExecutableExtension("class");
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        if (formExt instanceof PropertyGroupForm) {
            ((PropertyGroupForm)formExt).init(this.getCFGPropertyGroup(extensionElement), this, this.widgetFactory);
        }
        formExt.setExtension(extensionElement);
        int index = this.getHyadesEditorPart().addPage(formExt.createControl());
        this.getHyadesEditorPart().setPageText(index, extensionElement.getAttribute("name"));
        this.extensionPagesMap.put(new Integer(index), formExt);
        this.overviewForm.addSection(formExt, index);
        return index;
    }

    private CFGPropertyGroup getCFGPropertyGroup(IConfigurationElement extensionElement) {
        EObject editorObject = this.getEditorObject();
        EList propertyGroups = null;
        if (editorObject instanceof CFGConfigurableObject) {
            propertyGroups = ((CFGConfigurableObject)editorObject).getPropertyGroups();
        }
        if (propertyGroups == null) {
            return null;
        }
        CFGPropertyGroup propertyGroup = null;
        String propertyGroupID = extensionElement.getAttribute("propertyGroupID");
        Iterator i = propertyGroups.iterator();
        while (i.hasNext()) {
            propertyGroup = (CFGPropertyGroup)i.next();
            if (propertyGroupID.equals(propertyGroup.getPropertyGroupID())) break;
            propertyGroup = null;
        }
        if (propertyGroup == null) {
            String name = extensionElement.getAttribute("name");
            String description = extensionElement.getAttribute("description");
            propertyGroup = Common_ConfigurationFactory.eINSTANCE.createCFGPropertyGroup();
            propertyGroup.setPropertyGroupID(propertyGroupID);
            propertyGroup.setName(name);
            propertyGroup.setDescription(description);
            ((CFGConfigurableObject)editorObject).getPropertyGroups().add((Object)propertyGroup);
        }
        return propertyGroup;
    }
}

