/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.editor.form;

import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionEvent;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionResult;
import org.eclipse.hyades.test.ui.IEventLabelProvider;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.internal.editor.form.DefaultLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Image;

public class EventLabelProvider
implements ILabelProvider {
    private HashMap providers = new HashMap();

    public EventLabelProvider() {
        IExtensionPoint extPoint = Platform.getPluginRegistry().getExtensionPoint(TestUIPlugin.getID() + ".executionHistoryExtension");
        if (extPoint != null) {
            IConfigurationElement[] members = extPoint.getConfigurationElements();
            int i = 0;
            while (i < members.length) {
                if (members[i].getName() != null) {
                    IConfigurationElement element = members[i];
                    String typeName = element.getAttribute("targetType");
                    this.providers.put(typeName, element);
                }
                ++i;
            }
        }
    }

    public IEventLabelProvider getProvider(String type) {
        IEventLabelProvider provider = null;
        if (this.providers.containsKey(type)) {
            Object value = this.providers.get(type);
            if (value instanceof IConfigurationElement) {
                IConfigurationElement element = (IConfigurationElement)value;
                try {
                    provider = (IEventLabelProvider)element.createExecutableExtension("provider");
                    this.providers.put(type, provider);
                }
                catch (CoreException e) {
                    TestUIPlugin.logInfo("Unable to retrieve provider");
                }
            } else if (value instanceof IEventLabelProvider) {
                return (IEventLabelProvider)value;
            }
        }
        return provider;
    }

    public Image getImage(Object element) {
        Image icon = null;
        DefaultLabelProvider defaultProv = new DefaultLabelProvider();
        if (element instanceof TPFExecutionResult) {
            TPFExecutionResult execResult = (TPFExecutionResult)element;
            IEventLabelProvider provider = this.getProvider(execResult.getType());
            icon = provider != null ? provider.getImage(element) : defaultProv.getImage(element);
        } else if (element instanceof TPFExecutionEvent) {
            TPFExecutionEvent execEvent = (TPFExecutionEvent)element;
            IEventLabelProvider provider = this.getProvider(execEvent.getEventType());
            icon = provider != null ? provider.getImage(element) : defaultProv.getImage(element);
        }
        return icon;
    }

    public String getText(Object element) {
        String label = "";
        DefaultLabelProvider defaultProv = new DefaultLabelProvider();
        if (element instanceof TPFExecutionResult) {
            TPFExecutionResult execResult = (TPFExecutionResult)element;
            IEventLabelProvider provider = this.getProvider(execResult.getType());
            label = provider != null ? provider.getText(element) : defaultProv.getText(element);
        } else if (element instanceof TPFExecutionEvent) {
            TPFExecutionEvent execEvent = (TPFExecutionEvent)element;
            IEventLabelProvider provider = this.getProvider(execEvent.getEventType());
            label = provider != null ? provider.getText(element) : defaultProv.getText(element);
        }
        return label;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

