/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.editor.form.base;

import java.io.InputStream;
import java.util.Hashtable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.internal.editor.form.base.AbstractSectionForm;
import org.eclipse.hyades.test.ui.internal.editor.form.base.FormEngineLayout;
import org.eclipse.hyades.test.ui.internal.editor.form.base.HyperlinkAction;
import org.eclipse.hyades.test.ui.internal.editor.form.base.HyperlinkSettings;
import org.eclipse.hyades.test.ui.internal.editor.form.base.IHyperlinkSegment;
import org.eclipse.hyades.test.ui.internal.editor.form.base.IParagraph;
import org.eclipse.hyades.test.ui.internal.editor.form.base.ITextSegment;
import org.eclipse.hyades.test.ui.internal.editor.form.base.Locator;
import org.eclipse.hyades.test.ui.internal.editor.form.base.TextModel;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class FormEngine
extends Canvas {
    public static final String URL_HANDLER_ID = "urlHandler";
    boolean hasFocus;
    boolean paragraphsSeparated = true;
    TextModel model;
    Hashtable objectTable = new Hashtable();
    public int marginWidth = 0;
    public int marginHeight = 1;
    IHyperlinkSegment entered;
    boolean mouseDown = false;
    Point dragOrigin;
    private Action openAction;
    private Action copyShortcutAction;

    public boolean getFocus() {
        return this.hasFocus;
    }

    public int getParagraphSpacing(int lineHeight) {
        return lineHeight / 2;
    }

    public void setParagraphsSeparated(boolean value) {
        this.paragraphsSeparated = value;
    }

    public FormEngine(Composite parent, int style) {
        super(parent, style);
        this.setLayout(new FormEngineLayout());
        this.model = new TextModel();
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                FormEngine.this.model.dispose();
            }
        });
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                FormEngine.this.paint(e);
            }
        });
        this.addListener(1, new Listener(){

            public void handleEvent(Event e) {
                if (e.character == '\r') {
                    FormEngine.this.activateSelectedLink();
                    return;
                }
            }
        });
        this.addListener(31, new Listener(){

            public void handleEvent(Event e) {
                switch (e.detail) {
                    case 32: 
                    case 64: 
                    case 256: 
                    case 512: {
                        e.doit = false;
                        return;
                    }
                }
                if (!FormEngine.this.model.hasFocusSegments()) {
                    e.doit = true;
                    return;
                }
                if (e.detail == 16) {
                    e.doit = FormEngine.this.advance(true);
                } else if (e.detail == 8) {
                    e.doit = FormEngine.this.advance(false);
                } else if (e.detail != 4) {
                    e.doit = true;
                }
            }
        });
        this.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                if (!FormEngine.this.hasFocus) {
                    FormEngine.this.hasFocus = true;
                    FormEngine.this.handleFocusChange();
                }
            }

            public void focusLost(FocusEvent e) {
                if (FormEngine.this.hasFocus) {
                    FormEngine.this.hasFocus = false;
                    FormEngine.this.handleFocusChange();
                }
            }
        });
        this.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                FormEngine.this.handleMouseClick(e, true);
            }

            public void mouseUp(MouseEvent e) {
                FormEngine.this.handleMouseClick(e, false);
            }
        });
        this.addMouseTrackListener(new MouseTrackListener(){

            public void mouseEnter(MouseEvent e) {
                FormEngine.this.handleMouseMove(e);
            }

            public void mouseExit(MouseEvent e) {
                if (FormEngine.this.entered != null) {
                    FormEngine.this.exitLink(FormEngine.this.entered);
                    FormEngine.this.paintLinkHover(FormEngine.this.entered, false);
                    FormEngine.this.entered = null;
                    FormEngine.this.setCursor(null);
                }
            }

            public void mouseHover(MouseEvent e) {
                FormEngine.this.handleMouseHover(e);
            }
        });
        this.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                FormEngine.this.handleMouseMove(e);
            }
        });
        this.initAccessible();
        this.makeActions();
    }

    private void makeActions() {
        this.openAction = new Action(){

            public void run() {
                FormEngine.this.activateSelectedLink();
            }
        };
        this.openAction.setText(TestUIPlugin.getString("FormEgine.linkPopup.open"));
        this.copyShortcutAction = new Action(){

            public void run() {
                FormEngine.this.copyShortcut(FormEngine.this.getSelectedLink());
            }
        };
        this.copyShortcutAction.setText(TestUIPlugin.getString("FormEgine.linkPopup.copyShortcut"));
    }

    protected String getAcessibleText() {
        return this.model.getAccessibleText();
    }

    private void initAccessible() {
        Accessible accessible = this.getAccessible();
        accessible.addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = FormEngine.this.getAcessibleText();
            }

            public void getHelp(AccessibleEvent e) {
                e.result = FormEngine.this.getToolTipText();
            }
        });
        accessible.addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

            public void getChildAtPoint(AccessibleControlEvent e) {
                Point pt = FormEngine.this.toControl(new Point(e.x, e.y));
                e.childID = FormEngine.this.getBounds().contains(pt) ? -1 : -2;
            }

            public void getLocation(AccessibleControlEvent e) {
                Rectangle location = FormEngine.this.getBounds();
                Point pt = FormEngine.this.toDisplay(new Point(location.x, location.y));
                e.x = pt.x;
                e.y = pt.y;
                e.width = location.width;
                e.height = location.height;
            }

            public void getChildCount(AccessibleControlEvent e) {
                e.detail = 0;
            }

            public void getRole(AccessibleControlEvent e) {
                e.detail = 42;
            }

            public void getState(AccessibleControlEvent e) {
                e.detail = 64;
            }
        });
    }

    protected void handleMouseClick(MouseEvent e, boolean down) {
        if (down) {
            IHyperlinkSegment segmentUnder = this.model.findHyperlinkAt(e.x, e.y);
            if (segmentUnder != null) {
                IHyperlinkSegment oldLink = this.model.getSelectedLink();
                this.model.selectLink(segmentUnder);
                this.enterLink(segmentUnder);
                this.paintFocusTransfer(oldLink, segmentUnder);
            }
            this.mouseDown = true;
            this.dragOrigin = new Point(e.x, e.y);
        } else {
            IHyperlinkSegment segmentUnder;
            if (e.button == 1 && (segmentUnder = this.model.findHyperlinkAt(e.x, e.y)) != null) {
                this.activateLink(segmentUnder);
            }
            this.mouseDown = false;
        }
    }

    protected void handleMouseHover(MouseEvent e) {
    }

    protected void handleMouseMove(MouseEvent e) {
        if (this.mouseDown) {
            this.handleDrag(e);
            return;
        }
        ITextSegment segmentUnder = this.model.findSegmentAt(e.x, e.y);
        if (segmentUnder == null) {
            if (this.entered != null) {
                this.exitLink(this.entered);
                this.paintLinkHover(this.entered, false);
                this.entered = null;
            }
            this.setCursor(null);
        } else if (segmentUnder instanceof IHyperlinkSegment) {
            IHyperlinkSegment linkUnder = (IHyperlinkSegment)segmentUnder;
            if (this.entered == null) {
                this.entered = linkUnder;
                this.enterLink(linkUnder);
                this.paintLinkHover(this.entered, true);
                this.setCursor(this.model.getHyperlinkSettings().getHyperlinkCursor());
            }
        } else {
            if (this.entered != null) {
                this.exitLink(this.entered);
                this.paintLinkHover(this.entered, false);
                this.entered = null;
            }
            this.setCursor(this.model.getHyperlinkSettings().getTextCursor());
        }
    }

    private void handleDrag(MouseEvent e) {
    }

    public HyperlinkSettings getHyperlinkSettings() {
        return this.model.getHyperlinkSettings();
    }

    public void setHyperlinkSettings(HyperlinkSettings settings) {
        this.model.setHyperlinkSettings(settings);
    }

    protected boolean advance(boolean next) {
        IHyperlinkSegment current = this.model.getSelectedLink();
        if (current != null) {
            this.exitLink(current);
        }
        boolean valid = this.model.traverseLinks(next);
        IHyperlinkSegment newLink = this.model.getSelectedLink();
        if (valid) {
            this.enterLink(newLink);
        }
        this.paintFocusTransfer(current, newLink);
        if (newLink != null) {
            this.ensureVisible(newLink);
        }
        return !valid;
    }

    public IHyperlinkSegment getSelectedLink() {
        return this.model.getSelectedLink();
    }

    protected void handleFocusChange() {
        if (this.hasFocus) {
            this.model.traverseLinks(true);
            this.enterLink(this.model.getSelectedLink());
            this.paintFocusTransfer(null, this.model.getSelectedLink());
        } else {
            this.paintFocusTransfer(this.model.getSelectedLink(), null);
            this.model.selectLink(null);
        }
    }

    private void enterLink(IHyperlinkSegment link) {
        if (link == null) {
            return;
        }
        HyperlinkAction action = link.getAction(this.objectTable);
        if (action != null) {
            action.linkEntered(link);
        }
    }

    protected void exitLink(IHyperlinkSegment link) {
        if (link == null) {
            return;
        }
        HyperlinkAction action = link.getAction(this.objectTable);
        if (action != null) {
            action.linkExited(link);
        }
    }

    protected void paintLinkHover(IHyperlinkSegment link, boolean hover) {
        GC gc = new GC((Drawable)this);
        HyperlinkSettings settings = this.getHyperlinkSettings();
        gc.setForeground(hover ? settings.getActiveForeground() : settings.getForeground());
        gc.setBackground(this.getBackground());
        gc.setFont(this.getFont());
        boolean selected = link == this.getSelectedLink();
        link.repaint(gc, hover);
        if (selected) {
            link.paintFocus(gc, this.getBackground(), this.getForeground(), false);
            link.paintFocus(gc, this.getBackground(), this.getForeground(), true);
        }
        gc.dispose();
    }

    protected void activateSelectedLink() {
        IHyperlinkSegment link = this.model.getSelectedLink();
        if (link != null) {
            this.activateLink(link);
        }
    }

    private void activateLink(IHyperlinkSegment link) {
        this.setCursor(this.model.getHyperlinkSettings().getBusyCursor());
        HyperlinkAction action = link.getAction(this.objectTable);
        if (action != null) {
            action.linkActivated(link);
        }
        if (!this.isDisposed()) {
            this.setCursor(this.model.getHyperlinkSettings().getHyperlinkCursor());
        }
    }

    protected void paint(PaintEvent e) {
        int width = this.getClientArea().width;
        IParagraph[] paragraphs = this.model.getParagraphs();
        GC gc = e.gc;
        gc.setFont(this.getFont());
        gc.setForeground(this.getForeground());
        gc.setBackground(this.getBackground());
        Locator loc = new Locator();
        loc.marginWidth = this.marginWidth;
        loc.marginHeight = this.marginHeight;
        loc.x = this.marginWidth;
        loc.y = this.marginHeight;
        FontMetrics fm = gc.getFontMetrics();
        int lineHeight = fm.getHeight();
        IHyperlinkSegment selectedLink = this.model.getSelectedLink();
        int i = 0;
        while (i < paragraphs.length) {
            IParagraph p = paragraphs[i];
            if (i > 0 && this.paragraphsSeparated && p.getAddVerticalSpace()) {
                loc.y += this.getParagraphSpacing(lineHeight);
            }
            loc.indent = p.getIndent();
            loc.resetCaret();
            loc.rowHeight = 0;
            p.paint(gc, width, loc, lineHeight, this.objectTable, selectedLink);
            ++i;
        }
    }

    public void registerTextObject(String key, Object value) {
        this.objectTable.put(key, value);
    }

    public void load(String text, boolean parseTags, boolean expandURLs) {
        block3: {
            try {
                if (parseTags) {
                    this.model.parseTaggedText(text, expandURLs);
                    break block3;
                }
                this.model.parseRegularText(text, expandURLs);
            }
            catch (CoreException e) {
                TestUIPlugin.logError(e);
            }
        }
    }

    public void load(InputStream is, boolean expandURLs) {
        try {
            this.model.parseInputStream(is, expandURLs);
        }
        catch (CoreException e) {
            TestUIPlugin.logError(e);
        }
    }

    public boolean setFocus() {
        return super.setFocus();
    }

    private void paintFocusTransfer(IHyperlinkSegment oldLink, IHyperlinkSegment newLink) {
        GC gc = new GC((Drawable)this);
        Color bg = this.getBackground();
        Color fg = this.getForeground();
        gc.setFont(this.getFont());
        if (oldLink != null) {
            gc.setBackground(bg);
            gc.setForeground(fg);
            oldLink.paintFocus(gc, bg, fg, false);
        }
        if (newLink != null) {
            gc.setBackground(bg);
            gc.setForeground(fg);
            newLink.paintFocus(gc, bg, fg, true);
        }
        gc.dispose();
    }

    public int getMarginWidth() {
        return this.marginWidth;
    }

    public void setMarginWidth(int marginWidth) {
        this.marginWidth = marginWidth;
    }

    public int getMarginHeight() {
        return this.marginHeight;
    }

    public void setMarginHeight(int marginHeight) {
        this.marginHeight = marginHeight;
    }

    public void contextMenuAboutToShow(IMenuManager manager) {
        IHyperlinkSegment link = this.getSelectedLink();
        if (link != null) {
            this.contributeLinkActions(manager, link);
        }
    }

    private void contributeLinkActions(IMenuManager manager, IHyperlinkSegment link) {
        manager.add((IAction)this.openAction);
        manager.add((IAction)this.copyShortcutAction);
        manager.add((IContributionItem)new Separator());
    }

    protected void copyShortcut(IHyperlinkSegment link) {
        String text = link.getText();
        Clipboard clipboard = new Clipboard(this.getDisplay());
        clipboard.setContents(new Object[]{text}, new Transfer[]{TextTransfer.getInstance()});
    }

    private void ensureVisible(IHyperlinkSegment segment) {
        Rectangle bounds = segment.getBounds();
        ScrolledComposite scomp = this.getScrolledComposite();
        if (scomp == null) {
            return;
        }
        Point origin = AbstractSectionForm.getControlLocation(scomp, (Control)this);
        origin.x += bounds.x;
        origin.y += bounds.y;
        AbstractSectionForm.ensureVisible(scomp, origin, new Point(bounds.width, bounds.height));
    }

    ScrolledComposite getScrolledComposite() {
        Composite parent = this.getParent();
        while (parent != null) {
            if (parent instanceof ScrolledComposite) {
                return (ScrolledComposite)parent;
            }
            parent = parent.getParent();
        }
        return null;
    }
}

