/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.navigator.proxy;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionEvent;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionHistory;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionResult;
import org.eclipse.hyades.models.common.testprofile.TPFInvocationEvent;
import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.internal.model.EMFUtil;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.TypedElementProxyNode;
import org.eclipse.hyades.test.ui.navigator.IExecutionResultProxyNode;
import org.eclipse.hyades.test.ui.navigator.IProxyNode;
import org.eclipse.swt.graphics.Image;

public class DefaultExecutionResultProxyNode
extends TypedElementProxyNode
implements IExecutionResultProxyNode {
    private IProxyNode[] children;
    private String name;

    private void getEventChildren(TPFExecutionEvent event, List c, TPFExecutionResult parent) {
        if (event instanceof TPFInvocationEvent) {
            TPFExecutionResult er = ((TPFInvocationEvent)event).getInvokedExecutionResult();
            c.add(new DefaultExecutionResultProxyNode(er, (Object)parent));
        } else {
            Iterator iterator = event.getChildren().iterator();
            while (iterator.hasNext()) {
                this.getEventChildren((TPFExecutionEvent)iterator.next(), c, parent);
            }
        }
    }

    public DefaultExecutionResultProxyNode(TPFExecutionResult er, Object parent) {
        super(er, parent);
        LinkedList c = new LinkedList();
        TPFExecutionHistory history = er.getExecutionHistory();
        if (history != null) {
            EList events = history.getExecutionEvents();
            Iterator it = events.iterator();
            while (it.hasNext()) {
                this.getEventChildren((TPFExecutionEvent)it.next(), c, er);
            }
        }
        this.children = c.toArray(new IProxyNode[c.size()]);
        this.name = er.getName() != null ? er.getName() : "unamed";
        if (er.getTest() != null && er.getTest().getName() != null) {
            this.name = this.name + " [" + er.getTest().getName() + "]";
        }
    }

    public Image getImage() {
        return TestUIImages.INSTANCE.getImage("execution_obj.gif");
    }

    public IProxyNode[] getChildren() {
        return this.children;
    }

    public String getText() {
        return this.name;
    }

    public TPFExecutionResult getExecutionResult() {
        EObject exec = EMFUtil.getResourceSet().getEObject(this.getOriginatorURI(), true);
        if (exec instanceof TPFExecutionResult) {
            return (TPFExecutionResult)exec;
        }
        return null;
    }
}

