/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.navigator.proxy;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.hyades.test.ui.TestUIPlugin;

public class FileFactoryManager {
    private static FileFactoryManager instance;
    private HashMap factories = new HashMap();

    public static FileFactoryManager getInstance() {
        if (instance == null) {
            instance = new FileFactoryManager();
        }
        return instance;
    }

    private FileFactoryManager() {
        IExtensionPoint extPoint = Platform.getExtensionRegistry().getExtensionPoint(TestUIPlugin.getID() + ".testNavigatorFileFactory");
        if (extPoint != null) {
            IConfigurationElement[] members = extPoint.getConfigurationElements();
            int i = 0;
            while (i < members.length) {
                IConfigurationElement element;
                String extension;
                if (members[i].getName() != null && (extension = (element = members[i]).getAttribute("extension")) != null && extension.length() != 0) {
                    this.addFactory(extension, element);
                }
                ++i;
            }
        }
    }

    private void addFactory(String extension, IConfigurationElement element) {
        if (!this.factories.containsKey(extension)) {
            ArrayList<IConfigurationElement> l = new ArrayList<IConfigurationElement>();
            l.add(element);
            this.factories.put(extension, l);
        } else {
            ArrayList fac = (ArrayList)this.factories.get(extension);
            if (!fac.contains(element)) {
                fac.add(element);
            }
        }
    }

    public ArrayList getFactories(String extension) {
        if (extension == null || extension.length() == 0) {
            return new ArrayList();
        }
        if (this.factories.containsKey(extension)) {
            ArrayList l = (ArrayList)this.factories.get(extension);
            int i = 0;
            while (i < l.size()) {
                Object value = l.get(i);
                if (value instanceof IConfigurationElement) {
                    IConfigurationElement element = (IConfigurationElement)value;
                    try {
                        l.set(i, element.createExecutableExtension("factory"));
                    }
                    catch (CoreException e) {
                        l.remove(i);
                    }
                }
                ++i;
            }
            return l;
        }
        return new ArrayList();
    }

    public boolean isRegistered(String fileExtension) {
        return this.factories.containsKey(fileExtension);
    }
}

