/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.navigator.proxy;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.FileFactoryManager;
import org.eclipse.hyades.test.ui.navigator.IFileProxyFactory;
import org.eclipse.hyades.test.ui.navigator.IProxyNode;

public class FileProxyManager {
    private static FileProxyManager instance;
    private HashMap proxies = new HashMap();

    public static FileProxyManager getInstance() {
        if (instance == null) {
            instance = new FileProxyManager();
        }
        return instance;
    }

    private FileProxyManager() {
    }

    public IProxyNode getProxy(IFile file) {
        if (this.isaKnownFile(file)) {
            return (IProxyNode)this.proxies.get(file);
        }
        return this.updateProxy(file);
    }

    public boolean isaKnownFile(IFile file) {
        return this.proxies.containsKey(file);
    }

    public IProxyNode updateProxy(IFile file) {
        IProxyNode proxy = null;
        ArrayList factories = FileFactoryManager.getInstance().getFactories(file.getFileExtension());
        Iterator it = factories.iterator();
        while (it.hasNext()) {
            IFileProxyFactory factory = (IFileProxyFactory)it.next();
            proxy = factory.create(file);
            if (proxy != null) break;
        }
        if (proxy != null) {
            this.proxies.put(file, proxy);
        }
        return proxy;
    }

    public IProxyNode findProxyByID(IProxyNode proxy, String uid) {
        if (proxy == null) {
            return proxy;
        }
        if (uid.length() > 0) {
            if (proxy.getIdentifier().equals(uid)) {
                return proxy;
            }
            IProxyNode[] children = proxy.getChildren();
            int i = 0;
            while (i < children.length) {
                proxy = this.findProxyByID(children[i], uid);
                if (proxy != null) {
                    return proxy;
                }
                ++i;
            }
            return null;
        }
        return proxy;
    }
}

