/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.navigator.proxy;

import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionResult;
import org.eclipse.hyades.models.common.testprofile.TPFTest;
import org.eclipse.hyades.models.common.testprofile.TPFTestComponent;
import org.eclipse.hyades.test.ui.TestUIExtension;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.navigator.DefaultHyadesProxyNodeFactory;
import org.eclipse.hyades.test.ui.navigator.IProxyNode;
import org.eclipse.hyades.test.ui.navigator.ITypedElementProxyFactory;
import org.eclipse.hyades.ui.extension.IAssociationDescriptor;
import org.eclipse.hyades.ui.internal.extension.AssociationMappingRegistry;

public class TypedElementFactoryManager {
    private static TypedElementFactoryManager instance;
    private HashMap factories = new HashMap();

    public static TypedElementFactoryManager getInstance() {
        if (instance == null) {
            instance = new TypedElementFactoryManager();
        }
        return instance;
    }

    private TypedElementFactoryManager() {
        IExtensionPoint extPoint = Platform.getExtensionRegistry().getExtensionPoint(TestUIPlugin.getID() + ".testNavigatorTypedElementFactory");
        if (extPoint != null) {
            IConfigurationElement[] members = extPoint.getConfigurationElements();
            int i = 0;
            while (i < members.length) {
                IConfigurationElement element;
                String typeName;
                if (members[i].getName() != null && (typeName = (element = members[i]).getAttribute("type")) != null && typeName.length() != 0) {
                    this.addFactory(typeName, element);
                }
                ++i;
            }
        }
    }

    private void addFactory(String typeName, IConfigurationElement element) {
        if (this.factories.containsKey(typeName)) {
            this.factories.put(typeName, element);
        }
    }

    public ITypedElementProxyFactory getFactory(String typeName) {
        if (this.factories.containsKey(typeName)) {
            Object value = this.factories.get(typeName);
            if (value instanceof IConfigurationElement) {
                IConfigurationElement element = (IConfigurationElement)value;
                try {
                    ITypedElementProxyFactory factory = (ITypedElementProxyFactory)element.createExecutableExtension("factory");
                    this.factories.put(typeName, factory);
                    return factory;
                }
                catch (CoreException e) {
                    TestUIPlugin.logError(e);
                    return new DefaultTypedElementFactory();
                }
            }
            if (value instanceof ITypedElementProxyFactory) {
                return (ITypedElementProxyFactory)value;
            }
            TestUIPlugin.logError("internal error");
            return null;
        }
        AssociationMappingRegistry registry = (AssociationMappingRegistry)TestUIExtension.getTestSuiteMappingRegistry();
        IAssociationDescriptor descriptor = registry.getAssociationMapping("typeDescriptions").getDefaultAssociationDescriptor(typeName);
        if (descriptor == null) {
            registry = (AssociationMappingRegistry)TestUIExtension.getTestCaseMappingRegistry();
            descriptor = registry.getAssociationMapping("typeDescriptions").getDefaultAssociationDescriptor(typeName);
        }
        if (descriptor != null) {
            return new DefaultTypedElementFactory();
        }
        return null;
    }

    class DefaultTypedElementFactory
    implements ITypedElementProxyFactory {
        DefaultTypedElementFactory() {
        }

        public IProxyNode create(TPFExecutionResult result, Object parent) {
            return DefaultHyadesProxyNodeFactory.getInstance().create((EObject)result, parent);
        }

        public IProxyNode create(TPFTest test, Object parent) {
            return DefaultHyadesProxyNodeFactory.getInstance().create((EObject)test, parent);
        }

        public IProxyNode create(TPFTestComponent component, Object parent) {
            return DefaultHyadesProxyNodeFactory.getInstance().create((EObject)component, parent);
        }
    }
}

