/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.models.common.common.CMNNamedElement;
import org.eclipse.hyades.models.common.configuration.CFGArtifact;
import org.eclipse.hyades.models.common.configuration.CFGArtifactLocationPair;
import org.eclipse.hyades.models.common.configuration.CFGClass;
import org.eclipse.hyades.models.common.configuration.CFGComparableProperty;
import org.eclipse.hyades.models.common.configuration.CFGLocation;
import org.eclipse.hyades.models.common.configuration.CFGPropertyGroup;
import org.eclipse.hyades.models.common.configuration.Common_ConfigurationFactory;
import org.eclipse.hyades.models.common.configuration.util.ConfigurationUtil;
import org.eclipse.hyades.models.common.interactions.BVRProperty;
import org.eclipse.hyades.models.common.testprofile.TPFDeployment;
import org.eclipse.hyades.models.common.testprofile.TPFTest;
import org.eclipse.hyades.models.common.testprofile.TPFTestCase;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.models.common.testprofile.impl.TPFBehaviorImpl;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

public class ArtifactUtil {
    public static final String PROPERTY_NAME_CLASSPATH = Common_ConfigurationFactory.eINSTANCE.createHyadesClasspathCategory().getName();
    private static final String[] EXCLUDED_LIBRARIES = new String[]{"commons-logging.jar", "common_model.jar", "common.runner.jar", "datapool_api.jar", "ecore.jar", "ecore.xmi.jar", "hcframe.jar", "hexcore.jar", "hexl.jar", "hexr.jar", "hexrecr.jar", "hgla.jar", "hglaconfig.jar", "hmodel.jar", "hparse.jar", "hl14.jar", "hlcommons.jar", "hlcore.jar", "hlevents.jar", "hlcbe101.jar", "http.hexrecr.jar", "http.runner.jar", "java.runner.jar", "jmxagent.jar", "junit.jar", "manual.runner.jar", "runtime.jar", "xercesImpl.jar", "xmlParserAPIs.jar"};

    public static void associateTestAsset(CFGClass testAsset, CFGArtifact artifact) {
        if (!ConfigurationUtil.containsById((List)artifact.getDeployableInstances(), (CMNNamedElement)testAsset)) {
            artifact.getDeployableInstances().add((Object)testAsset);
        }
        if (testAsset instanceof TPFTestSuite) {
            ArtifactUtil.calculateClasspath((TPFTestSuite)testAsset, artifact);
        }
    }

    public static void calculateClasspath(TPFTestSuite testSuite, CFGArtifact artifact) {
        CFGPropertyGroup propertyGroup = ConfigurationUtil.searchPropertyGroupById((List)artifact.getPropertyGroups(), (String)"org.eclipse.hyades.test.configuration.artifact.attributes");
        if (propertyGroup == null) {
            propertyGroup = Common_ConfigurationFactory.eINSTANCE.createCFGPropertyGroup();
            propertyGroup.setPropertyGroupID("org.eclipse.hyades.test.configuration.artifact.attributes");
            artifact.getPropertyGroups().add((Object)propertyGroup);
        }
        if (testSuite.getBehavior() == null || ((TPFBehaviorImpl)testSuite.getBehavior()).getProject() == null) {
            return;
        }
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(((TPFBehaviorImpl)testSuite.getBehavior()).getProject());
        if (project == null || !project.exists()) {
            return;
        }
        String[] classpathEntries = ArtifactUtil.getProjectClasspath(project, false);
        int i = 0;
        int maxi = classpathEntries.length;
        while (i < maxi) {
            if (ArtifactUtil.addClasspathEntry(classpathEntries[i])) {
                BVRProperty[] existingProps = ConfigurationUtil.searchPropertiesByName((List)propertyGroup.getProperties(), (String)PROPERTY_NAME_CLASSPATH, (boolean)false);
                boolean existed = false;
                int propIndex = 0;
                while (propIndex < existingProps.length) {
                    if (classpathEntries[i].equals(existingProps[propIndex].getValue())) {
                        existed = true;
                        break;
                    }
                    ++propIndex;
                }
                if (!existed) {
                    CFGComparableProperty property = Common_ConfigurationFactory.eINSTANCE.createCFGComparableProperty();
                    property.setName(PROPERTY_NAME_CLASSPATH);
                    property.setOperator("=");
                    property.setValue(classpathEntries[i]);
                    propertyGroup.getProperties().add((Object)property);
                }
            }
            ++i;
        }
    }

    protected static boolean addClasspathEntry(String classpathEntry) {
        if (classpathEntry.indexOf(".jar") > 0) {
            int i = 0;
            int j = EXCLUDED_LIBRARIES.length;
            while (i < j) {
                if (classpathEntry.indexOf(EXCLUDED_LIBRARIES[i]) > 0) {
                    return false;
                }
                ++i;
            }
            if (classpathEntry.indexOf("common.jar") > 0 && classpathEntry.indexOf("org.eclipse.emf.common") > 0) {
                return false;
            }
        }
        return true;
    }

    public static String[] getProjectClasspath(IProject project, boolean exportedOnly) {
        if (project == null) {
            return new String[0];
        }
        IJavaProject javaProject = JavaCore.create((IProject)project);
        if (javaProject == null) {
            return new String[0];
        }
        ArrayList<IClasspathEntry> cpEntries = null;
        try {
            cpEntries = new ArrayList<IClasspathEntry>(Arrays.asList(javaProject.getRawClasspath()));
        }
        catch (JavaModelException e) {
            // empty catch block
        }
        if (cpEntries == null || cpEntries.isEmpty()) {
            return new String[0];
        }
        HashSet<String> classpath = new HashSet<String>(cpEntries.size());
        try {
            IPath path = javaProject.getOutputLocation();
            if (path != null) {
                classpath.add(ArtifactUtil.getFullPath(path));
            }
        }
        catch (JavaModelException e) {
            // empty catch block
        }
        Iterator i = cpEntries.iterator();
        while (i.hasNext()) {
            IClasspathEntry entry = JavaCore.getResolvedClasspathEntry((IClasspathEntry)((IClasspathEntry)i.next()));
            if (exportedOnly && !entry.isExported()) continue;
            String strcp = null;
            switch (entry.getEntryKind()) {
                case 1: 
                case 4: {
                    strcp = ArtifactUtil.getFullPath(entry.getPath());
                    if (strcp == null) break;
                    classpath.add(strcp);
                    break;
                }
                case 2: {
                    IPath projectPath = entry.getPath().makeAbsolute();
                    IProject parentProject = ResourcesPlugin.getWorkspace().getRoot().getProject(projectPath.toString());
                    classpath.addAll(Arrays.asList(ArtifactUtil.getProjectClasspath(parentProject, true)));
                    break;
                }
                case 5: {
                    break;
                }
                case 3: {
                    strcp = ArtifactUtil.getFullPath(entry.getOutputLocation());
                    if (strcp == null) break;
                    classpath.add(strcp);
                }
            }
        }
        return classpath.toArray(new String[classpath.size()]);
    }

    private static String getFullPath(IPath path) {
        if (path == null) {
            return null;
        }
        IResource res = ResourcesPlugin.getWorkspace().getRoot().findMember(path.makeAbsolute());
        if (res != null) {
            path = res.getLocation().makeAbsolute();
        }
        return path.toString();
    }

    public static void adjustDefaultLocation(TPFDeployment depl, TPFTest test) {
        CFGLocation location = ConfigurationUtil.getDefaultLocation((TPFDeployment)depl);
        if (location != null) {
            TPFTestSuite testSuite = null;
            TPFTest subTest = null;
            if (test instanceof TPFTestCase) {
                subTest = test;
                testSuite = ((TPFTestCase)subTest).getTestSuite();
            } else if (test instanceof TPFTestSuite) {
                testSuite = (TPFTestSuite)test;
                subTest = test;
            }
            Resource resource = depl.eResource();
            CFGArtifact artifact = ConfigurationUtil.createArtifact(null, null);
            ArtifactUtil.associateTestAsset((CFGClass)testSuite, artifact);
            CFGArtifactLocationPair pair = ConfigurationUtil.createArtifactLocationPair((CFGArtifact)artifact, (CFGLocation)location);
            depl.getArtifactLocations().add((Object)pair);
            resource.setModified(true);
        }
    }
}

