/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.http.internal.reports;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.hyades.test.http.TestHttpPlugin;
import org.eclipse.hyades.test.http.internal.reports.IReportGraphDataProvider;
import org.eclipse.hyades.test.http.internal.reports.ReportGraphConfiguration;
import org.eclipse.hyades.ui.sample.svg.generator.GraphicDocumentProperties;
import org.eclipse.hyades.ui.sample.svg.generator.SVGBarChart;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ReportGraph {
    IFile outputFile = null;
    ArrayList list = null;
    ReportGraphConfiguration config = null;

    public ReportGraph(ArrayList arrayList, ReportGraphConfiguration reportGraphConfiguration) {
        this.list = arrayList;
        this.config = reportGraphConfiguration;
    }

    public InputStream generate(IPath iPath) throws Exception {
        ArrayList arrayList = new ArrayList();
        Document document = this.generateDataDocument(this.list, arrayList);
        if (document == null) {
            return null;
        }
        GraphicDocumentProperties graphicDocumentProperties = new GraphicDocumentProperties();
        graphicDocumentProperties.setDataDocument(document);
        graphicDocumentProperties.setGraphicWidth(new Integer(this.config.getMinWidth()).toString());
        graphicDocumentProperties.setGraphicHeight(new Integer(this.config.getHeight()).toString());
        graphicDocumentProperties.setLegendSuppressed("true");
        graphicDocumentProperties.setUserPreferencesSuppressed("true");
        String[] stringArray = new String[]{"red", "green", "blue", "yellow", "black", "cyan", "#996699", "#FF00CC", "#000099"};
        graphicDocumentProperties.addGraphicColorPalette(TestHttpPlugin.getString("ReportGraph.0"), stringArray);
        SVGBarChart sVGBarChart = new SVGBarChart();
        Document document2 = sVGBarChart.generateGraphicDocument(graphicDocumentProperties);
        IPath iPath2 = iPath.removeFileExtension().addFileExtension("svg");
        String string = this.createFile(iPath2, sVGBarChart.serializeGeneratedDocumentToString(document2)).getName();
        String string2 = TestHttpPlugin.getString("SVG_URL");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<html>\n").append("<head>\n").append("<title>").append(this.getUserText("chart.Title")).append(" </title>").append("</head>\n");
        stringBuffer.append("<body>\n").append("<embed type=\"image/svg+xml\" src=\"");
        stringBuffer.append(string).append("\" ").append("width=\"").append(this.config.getMinWidth()).append("\" ");
        stringBuffer.append("height=\"").append(this.config.getHeight()).append("\" ");
        stringBuffer.append("name=\"mySvgDocument\"");
        stringBuffer.append("/>\n");
        stringBuffer.append("<p><font face=\"arial\" font size = \"1\"> ").append(string2).append(" </font> <p>");
        stringBuffer.append(" </body>").append(" </html>");
        IPath iPath3 = iPath.removeFileExtension().addFileExtension("html");
        return new ByteArrayInputStream(stringBuffer.toString().getBytes("UTF-8"));
    }

    protected Document generateDataDocument(ArrayList arrayList, ArrayList arrayList2) throws Exception {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.newDocument();
        Element element = document.createElement("configuration");
        document.appendChild(element);
        element.setAttribute("title", this.config.getTitle());
        element.setAttribute("legendtitle", this.config.getLegendTitle());
        element.setAttribute("timestampPrefix", this.config.getTimeStampPrefix());
        Element element2 = document.createElement("dataUpdate");
        element.appendChild(element2);
        Date date = new Date();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        element2.setAttribute("timestamp", simpleDateFormat.format(date));
        int n = 0;
        if (this.addBarData(document, element2, n, this.getUserText("chart.expectedAttempt"), arrayList)) {
            arrayList2.add("#D3D3D3");
            ++n;
        }
        this.createXData(document, element2, arrayList);
        this.createYData(document, element2, arrayList);
        return document;
    }

    protected boolean addBarData(Document document, Element element, int n, String string, ArrayList arrayList) {
        Element element2 = document.createElement("dataSet");
        element.appendChild(element2);
        element2.setAttribute("label", string);
        element2.setAttribute("position", new Integer(n).toString());
        element2.setAttribute("dataRange1Ref", "day");
        element2.setAttribute("dataRange2Ref", "count");
        Element element3 = document.createElement("dataPoint");
        element2.appendChild(element3);
        element3.setAttribute("value1", "0");
        element3.setAttribute("value2", "0");
        Iterator iterator = arrayList.iterator();
        int n2 = 1;
        while (iterator.hasNext()) {
            IReportGraphDataProvider iReportGraphDataProvider = (IReportGraphDataProvider)iterator.next();
            element3 = document.createElement("dataPoint");
            element2.appendChild(element3);
            element3.setAttribute("value1", Integer.toString(n2++));
            element3.setAttribute("value2", iReportGraphDataProvider.getValue());
        }
        return true;
    }

    protected void createXData(Document document, Element element, ArrayList arrayList) {
        Element element2 = document.createElement("dataRange");
        element.appendChild(element2);
        StringBuffer stringBuffer = new StringBuffer();
        element2.setAttribute("id", "day");
        element2.setAttribute("location", "S");
        element2.setAttribute("type", "categorization");
        element2.setAttribute("label", stringBuffer.toString());
        Element element3 = document.createElement("segmentMarker");
        Iterator iterator = arrayList.iterator();
        int n = 1;
        while (iterator.hasNext()) {
            IReportGraphDataProvider iReportGraphDataProvider = (IReportGraphDataProvider)iterator.next();
            element3 = document.createElement("segmentMarker");
            element2.appendChild(element3);
            String string = iReportGraphDataProvider.getId();
            StringBuffer stringBuffer2 = new StringBuffer();
            if (string.indexOf(47) != -1) {
                int n2;
                StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
                while (stringTokenizer.hasMoreTokens()) {
                    stringBuffer2.append(stringTokenizer.nextToken() + "/ ");
                }
                String string2 = stringBuffer2.toString();
                if (string2.endsWith("/ ")) {
                    n2 = string2.lastIndexOf("/ ");
                    string2 = string2.substring(0, n2);
                }
                n2 = 0;
                if ((n2 = string2.indexOf(63, n2)) != -1) {
                    String string3 = string2.substring(0, n2);
                    System.out.println(string3);
                    element3.setAttribute("label", string3);
                } else {
                    element3.setAttribute("label", string2);
                }
            } else {
                element3.setAttribute("label", string);
            }
            element3.setAttribute("value", Integer.toString(n++));
            if (n <= 6) continue;
            int n3 = this.config.getMinWidth() + 80;
            this.config.setMinWidth(n3);
        }
    }

    protected void createYData(Document document, Element element, ArrayList arrayList) {
        String string;
        Object object;
        Element element2 = document.createElement("dataRange");
        element.appendChild(element2);
        element2.setAttribute("id", "count");
        element2.setAttribute("location", "W");
        element2.setAttribute("label", this.config.getYTitle());
        int n = arrayList.size();
        Iterator iterator = arrayList.iterator();
        double d = 1000000.0;
        double d2 = 0.0;
        while (iterator.hasNext()) {
            IReportGraphDataProvider iReportGraphDataProvider = (IReportGraphDataProvider)iterator.next();
            double d3 = -1.0;
            object = iReportGraphDataProvider.getValue();
            string = iReportGraphDataProvider.getId();
            try {
                d3 = Double.parseDouble((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                d3 = 0.0;
            }
            if (d3 < d) {
                d = d3;
            }
            if (!(d3 > d2)) continue;
            d2 = d3;
        }
        double d4 = 1.0;
        if (d2 < 0.1) {
            d4 = 0.01;
        } else if (d2 < 0.5) {
            d4 = 0.05;
        } else if (d2 < 1.0) {
            d4 = 0.1;
        } else if (d2 < 5.0) {
            d4 = 0.5;
        } else if (d2 < 10.0) {
            d4 = 1.0;
        } else if (d2 < 20.0) {
            d4 = 2.0;
        } else if (d2 > 20.0) {
            d4 = (int)(d2 / 9.0);
        }
        int n2 = 0;
        while (n2 < 11) {
            object = document.createElement("segmentMarker");
            element2.appendChild((Node)object);
            string = Double.toString((double)n2 * d4);
            int n3 = 1;
            if (d4 < 0.1) {
                n3 = 2;
            }
            if (string.indexOf(46) >= 1) {
                string = string + "00";
                string = string.substring(0, string.indexOf(46) + 1 + n3);
            }
            object.setAttribute("value", string);
            object.setAttribute("label", string);
            ++n2;
        }
    }

    protected String getUserText(String string) {
        if ("chart.Title".equals(string)) {
            return TestHttpPlugin.getString("ReportGraph.1");
        }
        if ("chart.Legend".equals(string)) {
            return TestHttpPlugin.getString("ReportGraph.2");
        }
        if ("chart.timestampPrefix".equals(string)) {
            return TestHttpPlugin.getString("ReportGraph.3");
        }
        if ("chart.Xtitle".equals(string)) {
            return TestHttpPlugin.getString("ReportGraph.4");
        }
        if ("chart.Ytitle".equals(string)) {
            return TestHttpPlugin.getString("ReportGraph.5");
        }
        if ("chart.attempt".equals(string)) {
            return TestHttpPlugin.getString("ReportGraph.6");
        }
        if ("chart.error".equals(string)) {
            return TestHttpPlugin.getString("ReportGraph.7");
        }
        if ("chart.pass".equals(string)) {
            return TestHttpPlugin.getString("ReportGraph.8");
        }
        if ("chart.fail".equals(string)) {
            return TestHttpPlugin.getString("ReportGraph.9");
        }
        if ("chart.inconclusive".equals(string)) {
            return TestHttpPlugin.getString("ReportGraph.10");
        }
        if ("chart.expectedAttempt".equals(string)) {
            return TestHttpPlugin.getString("ReportGraph.11");
        }
        if ("chart.expectedError".equals(string)) {
            return TestHttpPlugin.getString("ReportGraph.12");
        }
        if ("chart.expectedPass".equals(string)) {
            return TestHttpPlugin.getString("ReportGraph.13");
        }
        if ("chart.expectedFail".equals(string)) {
            return TestHttpPlugin.getString("ReportGraph.14");
        }
        if ("chart.expectedInconclusive".equals(string)) {
            return TestHttpPlugin.getString("ReportGraph.15");
        }
        return string;
    }

    protected IFile createFile(IPath iPath, String string) throws CoreException {
        IFile iFile;
        block7: {
            iFile = null;
            try {
                iFile = ResourcesPlugin.getWorkspace().getRoot().getFile(iPath);
                ByteArrayInputStream byteArrayInputStream = null;
                try {
                    byteArrayInputStream = new ByteArrayInputStream(string.getBytes("UTF-8"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
                }
                if (iFile.exists()) {
                    try {
                        iFile.setContents((InputStream)byteArrayInputStream, true, false, (IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (CoreException coreException) {
                        coreException.printStackTrace();
                    }
                    break block7;
                }
                iFile.create((InputStream)byteArrayInputStream, true, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return iFile;
    }
}

