/**********************************************************************
* Copyright (c) 2004 Hyades project.
* All rights reserved.   This program and the accompanying materials
* are made available under the terms of the Common Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/cpl-v10.html
*
* Contributors:
* IBM - Initial API and implementation
**********************************************************************/

#include <stdio.h>
#include <string.h>
#include <time.h>

#include "CommonBaseEvent.h"
#include "XmlUtility.h"
#include "Sample.h"


/* Default output file name for serializing test */
char *sOutFile = "serialized.xml";

/* Default input file name for deserializing test */
char *inputFile = "sample.xml";

/* Default output file name for deserializing test */
char *dOutFile = "deserialized.xml";

char* pgmName = "Sample";

int level = 2;  /* default level */

/* Record test result */
int results[TOTAL_ATTR_COUNT];
char* err;

int main(int argc, char* argv[]){

	parseArgs(argc, argv);

	init();

	CommonBaseEvent_TestSerializing(sOutFile);

	CommonBaseEvent_TestDeserializing(inputFile, dOutFile);

	return(EXIT_SUCCESS);

}


void init(){
	int i;

	for (i = 0; i < TOTAL_ATTR_COUNT; i++){
		results[i] = -1;
	}
}


char* loadXMLFileToCanonicalString(char* file){
	FILE *fin;
	char* xmlString;
	int bufferSize = 1024;
	int readIn = 0;
	char ch[2] = {' ', '\0'};
	char preCh;
	int c;

    if((fin = fopen(file, "r"))==NULL)
	{
		printf("Error: can't open file.\n");
		exit(EXIT_FAILURE);
	}

	xmlString = (char*)calloc(bufferSize, sizeof(char));

	while( ( c = fgetc(fin) ) != EOF) {

		readIn ++;

		if(readIn >= bufferSize){
			bufferSize += bufferSize;
			xmlString = (char*)realloc(xmlString, bufferSize * sizeof(char));
		}

		ch[0] = c;

		if((ch[0] == '\t') || ch[0] == '\n' || ch[0] == '\r' ||(preCh == '>' && ch[0] == ' ')){

		}else{
			strcat(xmlString, ch);
			preCh = ch[0];
		}
	}

	fclose(fin);

    return xmlString;
}


void summary(){
	int pass =0;
	int fail = 0;
	int notTested = 0;
	int i;

	for(i = 0; i < TOTAL_ATTR_COUNT; i++){
		if(results[i] == 1){
			pass++;
		}else if(results[i] == 0){
			fail++;
		}else{
			notTested++;
		}
	}

	printf("CommonBaseEvent Test Summary:\n");
	printf("\n Total testcases: Not Tested: %d   Pass: %d   Fail: %d\n", notTested, pass, fail);

    if(fail > 0){
        printf("\nFailed test cases:\n");

        for(i = 0; i < TOTAL_ATTR_COUNT; i++){
            if(results[i] == 0){
		        printf("    %s\n", msg[i]);    
            }
	    }    
    }

/* Future use when different levels of verbosity are implemented
    if(notTested > 0){
        printf("\nNot tested test cases:\n");

        for(i = 0; i < TOTAL_ATTR_COUNT; i++){
		     if(results[i] == -1){
		        printf("    %s\n", msg[i]);    
            }       
	    }    
    }
*/

}



/*
//------------------------------------------------------------------------------------
//  Testing to Build the CommonBaseEvent Component
//  Build the each sub-components and test the getters and setters
//  for each component respectively at the same time
//------------------------------------------------------------------------------------
*/
void CommonBaseEvent_TestSerializing(char* outputFile){

	char strCommonBaseEvent[5000];
    char err[1000];
    int ierr = 0;
	char* strArrInput[] = {"value1", "value2"};
	char** strArrOutput;
    char* anyArrInput[] = {"<a:a xmlns:a=\"http://bar\" />"};
	char* strOutput;

    FILE* fout = NULL;

	hcbe_MsgDataElement* msgDataElement, *outMsgDataElement;
    hcbe_ContextDataElement *contextDataElement, **contextDataElements, *contextDataElement2,
					   *outContextDataElement, **outContextDataElements;
	hcbe_ExtendedDataElement *extendedDataElement, *children, **childrens, **extendedDataElements,
						*outExtendedDataElement, *outChildren, **outChildrens, **outExtendedDataElements;
	hcbe_AssociatedEvent *associatedEvent, **associatedEvents, *associatedEvent2,
					*outAssociatedEvent, **outAssociatedEvents;
    hcbe_AssociationEngine *associationEngineInfo, *associationEngineInfoOut, *outAssociationEngineInfo;
	hcbe_Situation *situation, *outSituation;
	hcbe_SituationType *situationType, *outSituationType;
	hcbe_CommonBaseEvent* commonBaseEvent;
	hcbe_ComponentIdentification *reporterComponentId, *sourceComponentId,
		                    *outReporterComponentId, *outSourceComponentId;


	/**
        - Build CommonBaseEvent msgDataElement component
        - Populate the component with testing values
        - Testing the setters and getters
    */
    msgDataElement = hcbe_msgDataElementConstr();

    if(msgDataElement == NULL){
        printf("Failed to instantiate the MsgDataElement.\n");
        exit(EXIT_FAILURE);
    
    }

	msgDataElement->fpRoot->setMsgId(msgDataElement, "msgId");
	strOutput = msgDataElement->fpRoot->getMsgId(msgDataElement);
	results[MDE_MSG_ID] = !strcmp(strOutput, "msgId");

	msgDataElement->fpRoot->setMsgIdType(msgDataElement, "msgIdType");
	strOutput = msgDataElement->fpRoot->getMsgIdType(msgDataElement);
	results[MDE_MSG_ID_TYPE] = !strcmp(strOutput, "msgIdType");

	msgDataElement->fpRoot->setMsgCatalog(msgDataElement, "msgCatalog");
	strOutput = msgDataElement->fpRoot->getMsgCatalog(msgDataElement);
	results[MDE_MSG_CATALOG] = !strcmp(strOutput, "msgCatalog");

	msgDataElement->fpRoot->setMsgCatalogId(msgDataElement, "msgCatalogId");
	strOutput = msgDataElement->fpRoot->getMsgCatalogId(msgDataElement);
	results[MDE_MSG_CATALOG_ID] = !strcmp(strOutput, "msgCatalogId");

	msgDataElement->fpRoot->setMsgCatalogTokens(msgDataElement, strArrInput, 2);
 
	strArrOutput = msgDataElement->fpRoot->getMsgCatalogTokens(msgDataElement);
	results[MDE_MSG_CATALOG_TOKENS] =
		!strcmp(msgDataElement->fpRoot->getMsgCatalogTokens(msgDataElement)[0], "value1") &&
		!strcmp(msgDataElement->fpRoot->getMsgCatalogTokens(msgDataElement)[1], "value2");

	msgDataElement->fpRoot->setMsgCatalogType(msgDataElement, "msgCatalogType");
	strOutput = msgDataElement->fpRoot->getMsgCatalogType(msgDataElement);

	results[MDE_MSG_CATALOG_TYPE] = !strcmp(strOutput, "msgCatalogType");

	msgDataElement->fpRoot->setMsgLocale(msgDataElement, "en-us");
    strOutput = msgDataElement->fpRoot->getMsgLocale(msgDataElement);
	results[MDE_MSG_LOCALE] = !strcmp(strOutput, "en-us");


	/**
        - Build CommonBaseEvent associatedEvents component
        - Populate the component with testing values
        - Testing the setters and getters
    */
	associatedEvent = hcbe_associatedEventConstr();
	associatedEvent2 = hcbe_associatedEventConstr();

    if((associatedEvent == NULL) || (associatedEvent2 == NULL)){
        printf("Failed to instantiate the AssociatedEvent.\n");
        exit(EXIT_FAILURE);
    
    }

    associatedEvent->fpRoot->setResolvedEvents(associatedEvent, "NMTOKENS");
	strOutput =  associatedEvent->fpRoot->getResolvedEvents(associatedEvent);
	results[AEVT_RESOVLED_EVENTS] =	!strcmp(strOutput, "NMTOKENS");

	associatedEvent2->fpRoot->setAssociationEngine(associatedEvent2, "engine");
	strOutput = associatedEvent2->fpRoot->getAssociationEngine(associatedEvent2);
	results[AEVT_ASSOC_ENGINE] = !strcmp(strOutput, "engine");
	hcbe_associatedEventDestr(associatedEvent2);

    associationEngineInfo = hcbe_associationEngineConstr();

    if(associationEngineInfo == NULL){
        printf("Failed to instantiate the AssociationEngineInfo.\n");
        exit(EXIT_FAILURE);
    
    }
    
    associationEngineInfo->fpRoot->setId(associationEngineInfo, "NMTOKENaaaaaaaaaaaaaaaaaaaaaaabb");
	strOutput = associationEngineInfo->fpRoot->getId(associationEngineInfo);
	results[AE_ID] = !strcmp(strOutput, "NMTOKENaaaaaaaaaaaaaaaaaaaaaaabb");

    associationEngineInfo->fpRoot->setName(associationEngineInfo, "Name");
	strOutput = associationEngineInfo->fpRoot->getName(associationEngineInfo);
	results[AE_NAME] = !strcmp(strOutput, "Name");

    associationEngineInfo->fpRoot->setType(associationEngineInfo, "Type");
	strOutput = associationEngineInfo->fpRoot->getType(associationEngineInfo);
	results[AE_TYPE] = !strcmp(strOutput, "Type");

    associatedEvent->fpRoot->setAssociationEngineInfo(associatedEvent, associationEngineInfo);
	associationEngineInfoOut = associatedEvent->fpRoot->getAssociationEngineInfo(associatedEvent);
	results[AEVT_ASSOC_ENGINE_INFO] =
		!strcmp(associationEngineInfoOut->fpRoot->getId(associationEngineInfoOut), "NMTOKENaaaaaaaaaaaaaaaaaaaaaaabb") &&
		!strcmp(associationEngineInfoOut->fpRoot->getName(associationEngineInfoOut), "Name") &&
		!strcmp(associationEngineInfoOut->fpRoot->getType(associationEngineInfoOut), "Type");


    if((associatedEvents = (hcbe_AssociatedEvent**)malloc( sizeof(hcbe_AssociatedEvent*))) == NULL){
        printf("testCommonBaseEventToCanonicalXMLDocString: Fail to allocate memory");
        exit(EXIT_FAILURE);
    }

    associatedEvents[0] = associatedEvent;


    /**
        - Build CommonBaseEvent reporterComponentId/sourceComponentId components
        - Populate the component with testing values
        - Testing the setters and getters
    */
    reporterComponentId = hcbe_componentIdentificationConstr();

    if(reporterComponentId == NULL) {
        printf("Failed to instantiate the ComponentIdentification.\n");
        exit(EXIT_FAILURE);
    
    }

	reporterComponentId->fpRoot->setLocation(reporterComponentId, "location");
	strOutput = reporterComponentId->fpRoot->getLocation(reporterComponentId);
	results[CI_LOCATION] = !strcmp(strOutput, "location");

	reporterComponentId->fpRoot->setLocationType(reporterComponentId, "locationType");
	strOutput = reporterComponentId->fpRoot->getLocationType(reporterComponentId);
	results[CI_LOCATION_TYPE] = !strcmp(strOutput, "locationType");

	reporterComponentId->fpRoot->setApplication(reporterComponentId, "application");
	strOutput = reporterComponentId->fpRoot->getApplication(reporterComponentId);
	results[CI_APPLICATION] = !strcmp(strOutput, "application");

	reporterComponentId->fpRoot->setExecutionEnvironment(reporterComponentId, "environment");
	strOutput = reporterComponentId->fpRoot->getExecutionEnvironment(reporterComponentId);
	results[CI_EXECUTION_ENVIRONMENT] = !strcmp(strOutput, "environment");

	reporterComponentId->fpRoot->setComponent(reporterComponentId, "component");
	strOutput = reporterComponentId->fpRoot->getComponent(reporterComponentId);
	results[CI_COMPONENT] = !strcmp(strOutput, "component");

	reporterComponentId->fpRoot->setSubComponent(reporterComponentId, "subcomponent");
	strOutput = reporterComponentId->fpRoot->getSubComponent(reporterComponentId);
	results[CI_SUB_COMPONENT] = !strcmp(strOutput, "subcomponent");

	reporterComponentId->fpRoot->setComponentIdType(reporterComponentId, "idtype");
	strOutput = reporterComponentId->fpRoot->getComponentIdType(reporterComponentId);
	results[CI_COMPONENT_ID_TYPE] = !strcmp(strOutput, "idtype");

	reporterComponentId->fpRoot->setInstanceId(reporterComponentId, "instanceId");
	strOutput = reporterComponentId->fpRoot->getInstanceId(reporterComponentId);
	results[CI_INSTANCE_ID] = !strcmp(strOutput, "instanceId");

	reporterComponentId->fpRoot->setProcessId(reporterComponentId, "processId");
	strOutput = reporterComponentId->fpRoot->getProcessId(reporterComponentId);
	results[CI_PROCESS_ID] = !strcmp(strOutput, "processId");

	reporterComponentId->fpRoot->setThreadId(reporterComponentId, "threadId");
	strOutput = reporterComponentId->fpRoot->getThreadId(reporterComponentId);
	results[CI_THREAD_ID] = !strcmp(strOutput, "threadId");

	reporterComponentId->fpRoot->setComponentType(reporterComponentId, "componentType");
	strOutput = reporterComponentId->fpRoot->getComponentType(reporterComponentId);
	results[CI_COMPONENT_TYPE] = !strcmp(strOutput, "componentType");

	sourceComponentId = hcbe_componentIdentificationConstr();

    if(sourceComponentId == NULL) {
        printf("Failed to instantiate the ComponentIdentification.\n");
        exit(EXIT_FAILURE);
    
    }

	sourceComponentId->fpRoot->setLocation(sourceComponentId, "location");
	sourceComponentId->fpRoot->setLocationType(sourceComponentId, "locationType");
	sourceComponentId->fpRoot->setApplication(sourceComponentId, "application");
	sourceComponentId->fpRoot->setExecutionEnvironment(sourceComponentId, "environment");
	sourceComponentId->fpRoot->setComponent(sourceComponentId, "component");
	sourceComponentId->fpRoot->setSubComponent(sourceComponentId, "subcomponent");
	sourceComponentId->fpRoot->setComponentIdType(sourceComponentId, "idtype");
	sourceComponentId->fpRoot->setInstanceId(sourceComponentId, "instanceId");
	sourceComponentId->fpRoot->setProcessId(sourceComponentId, "processId");
	sourceComponentId->fpRoot->setThreadId(sourceComponentId, "threadId");
	sourceComponentId->fpRoot->setComponentType(sourceComponentId, "componentType");


    /**
        - Build the CommonBaseEvent contextDataElements component
        - Populate the component with testing values
        - Testing the setters and getters
    */
    contextDataElement = hcbe_contextDataElementConstr();
	contextDataElement2 = hcbe_contextDataElementConstr();

    if((contextDataElement == NULL) || (contextDataElement2 == NULL)) {
        printf("Failed to instantiate the ContextDataElement.\n");
        exit(EXIT_FAILURE);
    
    }

	contextDataElement2->fpRoot->setContextValue(contextDataElement2, "contextValue");
	strOutput = contextDataElement2->fpRoot->getContextValue(contextDataElement2);
	results[CDE_CONTEXT_VALUE] = !strcmp(strOutput, "contextValue");

	contextDataElement->fpRoot->setName(contextDataElement, "CDE_Name");
	strOutput = contextDataElement->fpRoot->getName(contextDataElement);
	results[CDE_NAME] = !strcmp(strOutput, "CDE_Name");

	contextDataElement->fpRoot->setType(contextDataElement, "CDE_Type");
	strOutput = contextDataElement->fpRoot->getType(contextDataElement);
	results[CDE_TYPE] = !strcmp(strOutput, "CDE_Type");

    contextDataElement->fpRoot->setContextId(contextDataElement, "ID000006aaaaaaaaaaaaaaaaaaaaaaaa");
	strOutput = contextDataElement->fpRoot->getContextId(contextDataElement);
	results[CDE_CONTEXT_ID] = !strcmp(strOutput, "ID000006aaaaaaaaaaaaaaaaaaaaaaaa");

    if((contextDataElements = (hcbe_ContextDataElement**)malloc(sizeof(hcbe_ContextDataElement*))) == NULL){
        printf("CommonBaseEvent_TestSerializing: Fail to allocate memory");
        exit(EXIT_FAILURE);
    }

    contextDataElements[0] = contextDataElement;


	/**
        - Build the CommonBaseEvent extendedDataElements component
        - Populate the components with testing values
        - Testing the setters and getters
    */

	extendedDataElement = hcbe_extendedDataElementConstr();

    if(extendedDataElement == NULL) {
        printf("Failed to instantiate the ExtendedDataElement.\n");
        exit(EXIT_FAILURE);
    
    }

	extendedDataElement->fpRoot->setName(extendedDataElement, "EDE_Name");
	strOutput = extendedDataElement->fpRoot->getName(extendedDataElement);
	results[EDE_NAME] = !strcmp(strOutput, "EDE_Name");

	extendedDataElement->fpRoot->setType(extendedDataElement, "noValue");
	strOutput = extendedDataElement->fpRoot->getType(extendedDataElement);
	results[EDE_TYPE] = !strcmp(strOutput, "noValue");

	extendedDataElement->fpRoot->setHexValue(extendedDataElement, "hexValue");
	strOutput = extendedDataElement->fpRoot->getHexValue(extendedDataElement);
	results[EDE_HEXVALUE] = !strcmp(strOutput, "hexValue");

	extendedDataElement->fpRoot->setValues(extendedDataElement, strArrInput, 2);
	strArrOutput = extendedDataElement->fpRoot->getValues(extendedDataElement);
	results[EDE_VALUES] = !strcmp(strArrOutput[0], "value1") && !strcmp(strArrOutput[1], "value2");

    children = hcbe_extendedDataElementConstr();

    if(children == NULL) {
        printf("Failed to instantiate the ExtendedDataElement.\n");
        exit(EXIT_FAILURE);
    
    }

	children->fpRoot->setName(children, "name");
	children->fpRoot->setType(children, "noValue");
	children->fpRoot->setValues(children, strArrInput, 2);

    results[EDE_CHILDREN] = !strcmp(children->fpRoot->getName(children), "name") &&
		                    !strcmp(children->fpRoot->getType(children), "noValue") &&
							!strcmp(children->fpRoot->getValues(children)[0], "value1") &&
							!strcmp(children->fpRoot->getValues(children)[1], "value2");

    if((childrens = (hcbe_ExtendedDataElement**)malloc(sizeof(hcbe_ExtendedDataElement*))) == NULL){
        printf("testCommonBaseEventToCanonicalXMLDocString: Fail to allocate memory");
        exit(EXIT_FAILURE);
    }

    childrens[0] = children;
    extendedDataElement->fpRoot->setChildren(extendedDataElement, childrens, 1);


    if((extendedDataElements = (hcbe_ExtendedDataElement**)malloc(sizeof(hcbe_ExtendedDataElement*))) == NULL){
        printf("CommonBaseEvent_TestSerializing: Fail to allocate memory");
        exit(EXIT_FAILURE);
    }

    extendedDataElements[0] = extendedDataElement;


	/**
        - Build CommonBaseEvent situation component
        - Populate the data with testing values
        - Testing the setters and getters
    */

	situation = hcbe_situationConstr();

    if(situation == NULL) {
        printf("Failed to instantiate the Situation.\n");
        exit(EXIT_FAILURE);
    
    }

	situation->fpRoot->setCategoryName(situation, "StartSituation");
	strOutput = situation->fpRoot->getCategoryName(situation);
	results[S_CATEGORY_NAME] = !strcmp(strOutput, "StartSituation");

    situationType = hcbe_situationTypeConstr(HCBE_START_SITUATION, &ierr);

    if(situationType == NULL) {
        printf("Failed to instantiate the SituationType.\n");
        exit(EXIT_FAILURE);
    
    }

	situationType->fpRoot->setReasoningScope(situationType, "reasoningScope");
	strOutput = situationType->fpRoot->getReasoningScope(situationType, err);
	results[ST_REASONING_SCOPE] = !strcmp(strOutput, "reasoningScope");

    situationType->fpRoot->setSituationQualifier(situationType, "situationQualifier");
	strOutput = situationType->fpRoot->getSituationQualifier(situationType, err);
	results[ST_SITUATION_QUALIFIER] = !strcmp(strOutput, "situationQualifier");

	situationType->fpRoot->setSuccessDisposition(situationType, "successDisposition");
	strOutput = situationType->fpRoot->getSuccessDisposition(situationType, err);
	results[ST_SUCCESS_DISPOSITION] = !strcmp(strOutput, "successDisposition");

    situation->fpRoot->setSituationType(situation, situationType);
	outSituationType = situation->fpRoot->getSituationType(situation);
    results[S_SITUATION_TYPE] =
		!strcmp(outSituationType->fpRoot->getReasoningScope(situationType, err), "reasoningScope") &&
		!strcmp(outSituationType->fpRoot->getSituationQualifier(situationType, err), "situationQualifier") &&
		!strcmp(outSituationType->fpRoot->getSuccessDisposition(situationType, err), "successDisposition");


    /**
        - Build the CommonBaseEvent component
        - Populate the component with testing values
        - Testing the setters and getters
    */
    commonBaseEvent = hcbe_commonBaseEventConstr();

    if(commonBaseEvent == NULL) {
        printf("Failed to instantiate the CommonBaseEvent.\n");
        exit(EXIT_FAILURE);
    
    }

	commonBaseEvent->fpRoot->setVersion(commonBaseEvent, "1.0.1");
	strOutput = commonBaseEvent->fpRoot->getVersion(commonBaseEvent);
	results[CBEVT_VERSION] = !strcmp(strOutput, "1.0.1");

	commonBaseEvent->fpRoot->setLocalInstanceId(commonBaseEvent, "ID000006aaaaaaaaaaaaaaaaaaaaaabb");
	strOutput = commonBaseEvent->fpRoot->getLocalInstanceId(commonBaseEvent);
	results[CBEVT_LOCAL_INSTANCE_ID] = !strcmp(strOutput, "ID000006aaaaaaaaaaaaaaaaaaaaaabb");

	commonBaseEvent->fpRoot->setGlobalInstanceId(commonBaseEvent, "ID000006aaaaaaaaaaaaaaaaaaaaaaaa");
	strOutput = commonBaseEvent->fpRoot->getGlobalInstanceId(commonBaseEvent);
	results[CBEVT_GLOBAL_INSTANCE_ID] = !strcmp(strOutput, "ID000006aaaaaaaaaaaaaaaaaaaaaaaa");

	commonBaseEvent->fpRoot->setCreationTime(commonBaseEvent, "2001-12-17T09:30:47-05:00");
	strOutput = commonBaseEvent->fpRoot->getCreationTime(commonBaseEvent);
	results[CBEVT_CREATION_TIME] = !strcmp(strOutput, "2001-12-17T09:30:47-05:00");

    commonBaseEvent->fpRoot->setSeverity(commonBaseEvent, 70);
	results[CBEVT_SEVERITY] = (commonBaseEvent->fpRoot->getSeverity(commonBaseEvent) == 70);

	commonBaseEvent->fpRoot->setPriority(commonBaseEvent, 100);
	results[CBEVT_PRIORITY] = (commonBaseEvent->fpRoot->getPriority(commonBaseEvent) == 100);

	commonBaseEvent->fpRoot->setReporterComponentIdentification(commonBaseEvent, reporterComponentId);
    outReporterComponentId = commonBaseEvent->fpRoot->getReporterComponentIdentification(commonBaseEvent);
	results[CBEVT_REPORTER_COMP_ID] =
		!strcmp(outReporterComponentId->fpRoot->getLocation(outReporterComponentId), "location") &&
		!strcmp(outReporterComponentId->fpRoot->getLocationType(outReporterComponentId), "locationType") &&
		!strcmp(outReporterComponentId->fpRoot->getApplication(outReporterComponentId), "application") &&
		!strcmp(outReporterComponentId->fpRoot->getExecutionEnvironment(outReporterComponentId), "environment") &&
		!strcmp(outReporterComponentId->fpRoot->getComponent(outReporterComponentId), "component") &&
		!strcmp(outReporterComponentId->fpRoot->getSubComponent(outReporterComponentId), "subcomponent") &&
		!strcmp(outReporterComponentId->fpRoot->getComponentIdType(outReporterComponentId), "idtype") &&
		!strcmp(outReporterComponentId->fpRoot->getInstanceId(outReporterComponentId), "instanceId") &&
		!strcmp(outReporterComponentId->fpRoot->getProcessId(outReporterComponentId), "processId") &&
		!strcmp(outReporterComponentId->fpRoot->getThreadId(outReporterComponentId), "threadId") &&
		!strcmp(outReporterComponentId->fpRoot->getComponentType(outReporterComponentId), "componentType");

	commonBaseEvent->fpRoot->setSourceComponentIdentification(commonBaseEvent, sourceComponentId);
    outSourceComponentId = commonBaseEvent->fpRoot->getSourceComponentIdentification(commonBaseEvent);
	results[CBEVT_SOURCE_COMP_ID] =
		!strcmp(outSourceComponentId->fpRoot->getLocation(outSourceComponentId), "location") &&
		!strcmp(outSourceComponentId->fpRoot->getLocationType(outSourceComponentId), "locationType") &&
		!strcmp(outSourceComponentId->fpRoot->getApplication(outSourceComponentId), "application") &&
		!strcmp(outSourceComponentId->fpRoot->getExecutionEnvironment(outSourceComponentId), "environment") &&
		!strcmp(outSourceComponentId->fpRoot->getComponent(outSourceComponentId), "component") &&
		!strcmp(outSourceComponentId->fpRoot->getSubComponent(outSourceComponentId), "subcomponent") &&
		!strcmp(outSourceComponentId->fpRoot->getComponentIdType(outSourceComponentId), "idtype") &&
		!strcmp(outSourceComponentId->fpRoot->getInstanceId(outSourceComponentId), "instanceId") &&
		!strcmp(outSourceComponentId->fpRoot->getProcessId(outSourceComponentId), "processId") &&
		!strcmp(outSourceComponentId->fpRoot->getThreadId(outSourceComponentId), "threadId") &&
		!strcmp(outSourceComponentId->fpRoot->getComponentType(outSourceComponentId), "componentType");


	commonBaseEvent->fpRoot->setSituation(commonBaseEvent, situation);
	outSituation = commonBaseEvent->fpRoot->getSituation(commonBaseEvent);
	results[CBEVT_SITUATION] = !strcmp(outSituation->fpRoot->getCategoryName(outSituation), "StartSituation");


	commonBaseEvent->fpRoot->setContextDataElements(commonBaseEvent, contextDataElements, 1);

    outContextDataElements = commonBaseEvent->fpRoot->getContextDataElements(commonBaseEvent);
	outContextDataElement = outContextDataElements[0];
	results[CBEVT_CONT_DATA_ELEMS] =
		!strcmp(outContextDataElement->fpRoot->getName(outContextDataElement), "CDE_Name") &&
		!strcmp(outContextDataElement->fpRoot->getType(outContextDataElement), "CDE_Type") &&
	    !strcmp(outContextDataElement->fpRoot->getContextId(outContextDataElement), "ID000006aaaaaaaaaaaaaaaaaaaaaaaa");


	commonBaseEvent->fpRoot->setMsgDataElement(commonBaseEvent, msgDataElement);
	outMsgDataElement = commonBaseEvent->fpRoot->getMsgDataElement(commonBaseEvent);
	results[CBEVT_MSG_DATA_ELEM] =
		!strcmp(outMsgDataElement->fpRoot->getMsgId(outMsgDataElement), "msgId") &&
		!strcmp(outMsgDataElement->fpRoot->getMsgIdType(outMsgDataElement), "msgIdType") &&
		!strcmp(outMsgDataElement->fpRoot->getMsgCatalog(outMsgDataElement), "msgCatalog") &&
		!strcmp(outMsgDataElement->fpRoot->getMsgCatalogId(outMsgDataElement), "msgCatalogId") &&
		(outMsgDataElement->fpRoot->getMsgCatalogTokensSize(outMsgDataElement) == 2) &&
		!strcmp(outMsgDataElement->fpRoot->getMsgCatalogTokens(outMsgDataElement)[0], "value1") &&
		!strcmp(outMsgDataElement->fpRoot->getMsgCatalogTokens(outMsgDataElement)[1], "value2") &&
	    !strcmp(outMsgDataElement->fpRoot->getMsgCatalogType(outMsgDataElement), "msgCatalogType") &&
		!strcmp(outMsgDataElement->fpRoot->getMsgLocale(outMsgDataElement), "en-us");


	commonBaseEvent->fpRoot->setMsg(commonBaseEvent, "msg");
	results[CBEVT_MSG] = !strcmp(commonBaseEvent->fpRoot->getMsg(commonBaseEvent), "msg");

	commonBaseEvent->fpRoot->setRepeatCount(commonBaseEvent, 9);
	results[CBEVT_REPEAT_COUNT] = (commonBaseEvent->fpRoot->getRepeatCount(commonBaseEvent) == 9);

	commonBaseEvent->fpRoot->setElapsedTime(commonBaseEvent, 0);
	results[CBEVT_ELAPSED_TIME] = (commonBaseEvent->fpRoot->getElapsedTime(commonBaseEvent) == 0);

	commonBaseEvent->fpRoot->setAssociatedEvents(commonBaseEvent, associatedEvents, 1);

	outAssociatedEvents = commonBaseEvent->fpRoot->getAssociatedEvents(commonBaseEvent);
	outAssociatedEvent = outAssociatedEvents[0];
    outAssociationEngineInfo = outAssociatedEvent->fpRoot->getAssociationEngineInfo(outAssociatedEvent);
	results[CBEVT_ASSOCIATED_EVENTS] =
		!strcmp(outAssociatedEvent->fpRoot->getResolvedEvents(outAssociatedEvent), "NMTOKENS") &&
		!strcmp(outAssociationEngineInfo->fpRoot->getId(outAssociationEngineInfo), "NMTOKENaaaaaaaaaaaaaaaaaaaaaaabb") &&
		!strcmp(outAssociationEngineInfo->fpRoot->getName(associationEngineInfo), "Name") &&
		!strcmp(outAssociationEngineInfo->fpRoot->getType(associationEngineInfo), "Type");


	commonBaseEvent->fpRoot->setExtensionName(commonBaseEvent, "extensionName");
	results[CBEVT_EXT_NAME] = !strcmp(commonBaseEvent->fpRoot->getExtensionName(commonBaseEvent), "extensionName");

	commonBaseEvent->fpRoot->setExtendedDataElements(commonBaseEvent, extendedDataElements, 1);

	outExtendedDataElements = commonBaseEvent->fpRoot->getExtendedDataElements(commonBaseEvent);
	outExtendedDataElement = outExtendedDataElements[0];
	outChildrens = outExtendedDataElement->fpRoot->getChildren(outExtendedDataElement);
	outChildren = outChildrens[0];
    strArrOutput = outExtendedDataElement->fpRoot->getValues(outExtendedDataElement);

	results[CBEVT_EXTD_DATA_ELEMS] =
		!strcmp(outExtendedDataElement->fpRoot->getName(outExtendedDataElement), "EDE_Name") &&
		!strcmp(outExtendedDataElement->fpRoot->getType(outExtendedDataElement), "noValue") &&
		!strcmp(outExtendedDataElement->fpRoot->getValues(outExtendedDataElement)[0], "value1") &&
		!strcmp(outExtendedDataElement->fpRoot->getValues(outExtendedDataElement)[1], "value2") &&
		((outExtendedDataElement->fpRoot->getValuesSize(outExtendedDataElement)) == 2) &&
		!strcmp(outChildren->fpRoot->getName(outChildren), "name") &&
		!strcmp(outChildren->fpRoot->getType(outChildren), "noValue") &&
		!strcmp(outChildren->fpRoot->getValues(outChildren)[0], "value1") &&
		!strcmp(outChildren->fpRoot->getValues(outChildren)[1], "value2") &&
		(outChildren->fpRoot->getValuesSize(outChildren) == 2);

	commonBaseEvent->fpRoot->setSequenceNumber(commonBaseEvent, 135792468);
	results[CBEVT_SEQUENCE_NUM] = (commonBaseEvent->fpRoot->getSequenceNumber(commonBaseEvent) == 135792468);


    commonBaseEvent->fpRoot->setAny(commonBaseEvent, anyArrInput, 1);

	results[CBEVT_ANY] = !strcmp(commonBaseEvent->fpRoot->getAny(commonBaseEvent)[0], "<a:a xmlns:a=\"http://bar\" />") &&
						 (commonBaseEvent->fpRoot->getAnySize(commonBaseEvent) == 1);


    /**
        Testing Serializing
    */
    hcbe_commonBaseEventToCanonicalXMLString(commonBaseEvent, strCommonBaseEvent, 5000, 1);
    hcbe_serialize(outputFile, strCommonBaseEvent);
	hcbe_commonBaseEventDestr(commonBaseEvent);

	summary();
}


/*
//------------------------------------------------------------------------------------
//  Testing the Build the CommonBaseEvent Component
//  Build the each sub-components and test the getters and setters
//  for each component respectively at the same time
//--------------------------------------------------------------------------------------
*/

void CommonBaseEvent_TestDeserializing(char* inputFile, char* outputFile){
    char* xmlString = NULL;
    char strCommonBaseEvent[5000];
    hcbe_CommonBaseEvent* commonBaseEvent = NULL;

    xmlString = loadXMLFileToCanonicalString(inputFile);
	commonBaseEvent = hcbe_commonBaseEventFromCanonicalXMLString(xmlString);

    hcbe_commonBaseEventToCanonicalXMLDocString(commonBaseEvent,strCommonBaseEvent, 5000, 1);

    hcbe_serialize(outputFile, strCommonBaseEvent);
    free(xmlString);

}


void usage(void)
{
	fprintf(stderr,"Usage: %s [options] [file-name]\n\n", pgmName);
    fprintf(stderr,"Options\n");
    fprintf(stderr,"  -h                Help\n");
    fprintf(stderr,"  -os <file name>   Set output filename for serializing test\n");
    fprintf(stderr,"  -i <file name>    Set input filename for deserializing test\n");
    fprintf(stderr,"  -od <file name>   Set output filename for deserializing test\n");

    /* for future use
	fprintf(stderr,"  -silent -SILENT   Run silent mode\n");
	fprintf(stderr,"  -quiet -QUIET     Run quiet mode\n");
	fprintf(stderr,"  -verbose -VERBOSE Run verbose mode\n");
	fprintf(stderr,"  -debug -DEBUG     Run debug mode\n\n");
    */
    exit(EXIT_SUCCESS);
}

void parseArgs(int argc, char* argv[]){

	int currArg = 1;
	int argcOld = argc;
	int levelSet = FALSE;

    while (argc > 1){

		if (!strcmp(argv[currArg], "-h")){
			usage();
			exit(EXIT_SUCCESS);
		}else if(!strcmp(argv[currArg], "-os")){
			if((argc >= 2) && argv[++currArg][0]!= '-'){
				sOutFile = argv[currArg];
				argc--;
			}
        }else if(!strcmp(argv[currArg], "-od")){
			if((argc >= 2) && argv[++currArg][0]!= '-'){
				dOutFile = argv[currArg];
				argc--;
			}
        }else if(!strcmp(argv[currArg], "-i")){
			if((argc >= 2) && argv[++currArg][0]!= '-'){
				inputFile = argv[currArg];
				argc--;
			}
		}else if(!strcmp(argv[currArg], "-silent") || !strcmp(argv[currArg], "-SILENT")){
			if(!levelSet){
				level = 0;
				levelSet = TRUE;
			}
		}else if(!strcmp(argv[currArg], "-quiet") || !strcmp(argv[currArg], "-QUIET")){
			if(!levelSet){
				level = 1;
				levelSet = TRUE;
			}
		}else if(!strcmp(argv[currArg], "-verbose") || !strcmp(argv[currArg], "-VERBOSE")){
			if(!levelSet){
				level = 2;
				levelSet = TRUE;
			}
		}else if(!strcmp(argv[currArg], "-debug") || !strcmp(argv[currArg], "-DEBUG")){
			if(!levelSet){
				level = 3;
				levelSet = TRUE;
			}
		}else {
		     fprintf(stderr,"Bad option\n");
             usage();
        }

		currArg++;
		argc--;
    }
}



