/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

#ifndef COMMONBASEEVENT_H
#define COMMONBASEEVENT_H

#include <stdlib.h>


#if ! defined MVS && ! defined __OS400__
#include <malloc.h>
#endif

#include <stdio.h>

#ifndef NULL
	#define NULL (void *)0
#endif


/* These typedefs are required by OS/400 to bypass a compiler defect. Do not remove. */
#ifdef __OS400__
typedef struct hcbe_AssociationEngine hcbe_AssociationEngine;
typedef struct hcbe_MsgDataElement hcbe_MsgDataElement;
typedef struct hcbe_AssociatedEvent hcbe_AssociatedEvent;
typedef struct hcbe_ComponentIdentification hcbe_ComponentIdentification;
typedef struct hcbe_ContextDataElement hcbe_ContextDataElement;
typedef struct hcbe_ExtendedDataElement hcbe_ExtendedDataElement;
typedef struct hcbe_SituationType hcbe_SituationType;
typedef struct hcbe_Situation hcbe_Situation;
typedef struct hcbe_CommonBaseEvent hcbe_CommonBaseEvent;
#endif


#ifdef __cplusplus
extern "C" {
#endif

/* 
	AssociationEngine Declarations
*/
typedef char* (*hcbe_AssociationEngineGetFP) (struct hcbe_AssociationEngine*);
typedef void (*hcbe_AssociationEngineSetFP) (struct hcbe_AssociationEngine*, char*);

typedef struct hcbe_AssociationEngineFPTable
{
    hcbe_AssociationEngineGetFP getId;
    hcbe_AssociationEngineGetFP getName;
    hcbe_AssociationEngineGetFP getType;
    hcbe_AssociationEngineSetFP setId;
    hcbe_AssociationEngineSetFP setName;
    hcbe_AssociationEngineSetFP setType;
}hcbe_AssociationEngineFPTable;

typedef struct hcbe_AssociationEngine
{
	char* id;
    char* name;
	char* type;
    int _deserialized;
	hcbe_AssociationEngineFPTable* fpRoot;

}hcbe_AssociationEngine;

hcbe_AssociationEngine* hcbe_associationEngineConstr();

char* hcbe_associationEngineDestr(hcbe_AssociationEngine* associationEngine);


/* 
	MsgDataElement Declarations
*/
typedef char* (*hcbe_MsgDataElementGetFP) (struct hcbe_MsgDataElement*);
typedef void (*hcbe_MsgDataElementSetFP) (struct hcbe_MsgDataElement*, char*);
typedef char** (*hcbe_MsgDataElementGetCatalogTokensFP) (struct hcbe_MsgDataElement*);
typedef void (*hcbe_MsgDataElementSetCatalogTokensFP) (struct hcbe_MsgDataElement*, char**, int);

typedef int (*hcbe_MsgDataElementArrGetCounterFP)(struct hcbe_MsgDataElement*);

typedef struct 
{
    hcbe_MsgDataElementGetFP  getMsgId,
		                 getMsgIdType,
		                 getMsgCatalog,
		                 getMsgCatalogId,
		                 getMsgCatalogType,
		                 getMsgLocale;   
    
	hcbe_MsgDataElementSetFP  setMsgId, 	
		                 setMsgIdType, 	
		                 setMsgCatalog, 	
		                 setMsgCatalogId,
				         setMsgCatalogType,    	
		                 setMsgLocale;   

	hcbe_MsgDataElementGetCatalogTokensFP getMsgCatalogTokens; 		
	hcbe_MsgDataElementSetCatalogTokensFP setMsgCatalogTokens;

	hcbe_MsgDataElementArrGetCounterFP getMsgCatalogTokensSize;

}hcbe_MsgDataElementFPTable;

typedef struct hcbe_MsgDataElement
{
	char* _msgId;
    char* _msgIdType;
	char* _msgCatalog;
	char* _msgCatalogId;
	char** _msgCatalogTokens;
	char* _msgCatalogType;
	char* _msgLocale;
	int _tokensSize;
    int _deserialized;

	hcbe_MsgDataElementFPTable* fpRoot;
}hcbe_MsgDataElement;

hcbe_MsgDataElement* hcbe_msgDataElementConstr();

char* hcbe_msgDataElementDestr(hcbe_MsgDataElement* msgDataElement);


/*
	AssociatedEvent Declarations
*/
typedef char* (*hcbe_AssociatedEventGetFP) (struct hcbe_AssociatedEvent*);
typedef void (*hcbe_AssociatedEventSetFP) (struct hcbe_AssociatedEvent*, char*);
typedef hcbe_AssociationEngine* (*hcbe_AssociatedEventGetEngineInfoFP) (struct hcbe_AssociatedEvent*);
typedef void (*hcbe_AssociatedEventSetEngineInfoFP) (struct hcbe_AssociatedEvent*, hcbe_AssociationEngine*);

typedef struct 
{
    hcbe_AssociatedEventGetFP getAssociationEngine,
                         getResolvedEvents;
     
    hcbe_AssociatedEventSetFP setAssociationEngine,
                        setResolvedEvents;

	hcbe_AssociatedEventGetEngineInfoFP getAssociationEngineInfo;
	hcbe_AssociatedEventSetEngineInfoFP setAssociationEngineInfo;
}hcbe_AssociatedEventFPTable;

typedef struct hcbe_AssociatedEvent 
{
	char* _associationEngine;
    hcbe_AssociationEngine* _associationEngineInfo;
	char* _resolvedEvents;
    int _deserialized;
	hcbe_AssociatedEventFPTable* fpRoot;
}hcbe_AssociatedEvent;

hcbe_AssociatedEvent* hcbe_associatedEventConstr();

char* hcbe_associatedEventDestr(hcbe_AssociatedEvent* associatedEven);


/*
	ComponentIdentification Declarations
*/
typedef char* (*hcbe_ComponentIdentificationGetFP) (struct hcbe_ComponentIdentification*);
typedef void (*hcbe_ComponentIdentificationSetFP) (struct hcbe_ComponentIdentification*, char*);

typedef struct hcbe_ComponentIdentificationFPTable
{
    hcbe_ComponentIdentificationGetFP getLocation;
	hcbe_ComponentIdentificationGetFP getLocationType;
    hcbe_ComponentIdentificationGetFP getApplication;
    hcbe_ComponentIdentificationGetFP getExecutionEnvironment;
    hcbe_ComponentIdentificationGetFP getComponent;
    hcbe_ComponentIdentificationGetFP getSubComponent;
    hcbe_ComponentIdentificationGetFP getComponentIdType;
    hcbe_ComponentIdentificationGetFP getInstanceId;
    hcbe_ComponentIdentificationGetFP getProcessId;
    hcbe_ComponentIdentificationGetFP getThreadId;
    hcbe_ComponentIdentificationGetFP getComponentType;

    hcbe_ComponentIdentificationSetFP setLocation;
	hcbe_ComponentIdentificationSetFP setLocationType;
	hcbe_ComponentIdentificationSetFP setApplication;
    hcbe_ComponentIdentificationSetFP setExecutionEnvironment;
    hcbe_ComponentIdentificationSetFP setComponent;
    hcbe_ComponentIdentificationSetFP setSubComponent;
    hcbe_ComponentIdentificationSetFP setComponentIdType;
    hcbe_ComponentIdentificationSetFP setInstanceId;
    hcbe_ComponentIdentificationSetFP setProcessId;
    hcbe_ComponentIdentificationSetFP setThreadId;
    hcbe_ComponentIdentificationSetFP setComponentType;

}hcbe_ComponentIdentificationFPTable;

typedef struct hcbe_ComponentIdentification
{
	char* location;
    char* locationType;
	char* application;
    char* executionEnvironment;
    char* component;
    char* subComponent;
    char* componentIdType;
    char* instanceId;
    char* processId;
    char* threadId;
    char* componentType;
    int _deserialized;
	hcbe_ComponentIdentificationFPTable* fpRoot;
}hcbe_ComponentIdentification;

hcbe_ComponentIdentification* hcbe_componentIdentificationConstr();

char* hcbe_componentIdentificationDestr(hcbe_ComponentIdentification* componentIdentification);


/*
	ContextDataElement Declarations
*/
typedef char* (*hcbe_ContextDataElementGetFP) (struct hcbe_ContextDataElement*);
typedef void (*hcbe_ContextDataElementSetFP) (struct hcbe_ContextDataElement*, char*);

typedef struct hcbe_ContextDataElementFPTable
{
    hcbe_ContextDataElementGetFP getContextId;
	hcbe_ContextDataElementGetFP getType;
	hcbe_ContextDataElementGetFP getName;
    hcbe_ContextDataElementGetFP getContextValue;

    hcbe_ContextDataElementSetFP setContextId;
    hcbe_ContextDataElementSetFP setType;
    hcbe_ContextDataElementSetFP setName;
    hcbe_ContextDataElementSetFP setContextValue;

}hcbe_ContextDataElementFPTable;

typedef struct hcbe_ContextDataElement
{
	char* contextId;
    char* type;
	char* name;
    char* contextValue;
    int _deserialized;
	hcbe_ContextDataElementFPTable* fpRoot;

}hcbe_ContextDataElement;

hcbe_ContextDataElement* hcbe_contextDataElementConstr();

char* hcbe_contextDataElementDestr(hcbe_ContextDataElement* contextDataElement);


/*
	ExtendedDataElement Declarations
*/

#define HCBE_TYPE_NO_VALUE_VALUE 0   
#define HCBE_TYPE_BYTE_VALUE 1   
#define HCBE_TYPE_SHORT_VALUE 2
#define HCBE_TYPE_INT_VALUE 3   
#define HCBE_TYPE_LONG_VALUE 4   
#define HCBE_TYPE_FLOAT_VALUE 5   
#define HCBE_TYPE_DOUBLE_VALUE 6    
#define HCBE_TYPE_STRING_VALUE 7   
#define HCBE_TYPE_DATE_TIME_VALUE 8   
#define HCBE_TYPE_BOOLEAN_VALUE 9    
#define HCBE_TYPE_BYTE_ARRAY_VALUE 10   
#define HCBE_TYPE_SHORT_ARRAY_VALUE 11   
#define HCBE_TYPE_INT_ARRAY_VALUE 12   
#define HCBE_TYPE_LONG_ARRAY_VALUE 13   
#define HCBE_TYPE_FLOAT_ARRAY_VALUE 14   
#define HCBE_TYPE_DOUBLE_ARRAY_VALUE 15   
#define HCBE_TYPE_STRING_ARRAY_VALUE 16   
#define HCBE_TYPE_DATE_TIME_ARRAY_VALUE 17   
#define HCBE_TYPE_BOOLEAN_ARRAY_VALUE 18   
#define HCBE_TYPE_HEX_BINARY_VALUE 19

#define HCBE_TYPE_NO_VALUE "noValue"
#define HCBE_TYPE_BYTE "byte"
#define HCBE_TYPE_SHORT "short"  
#define HCBE_TYPE_INT "int"
#define HCBE_TYPE_LONG "long"  
#define HCBE_TYPE_FLOAT "float"   
#define HCBE_TYPE_DOUBLE "double"  
#define HCBE_TYPE_STRING "string"   
#define HCBE_TYPE_DATE_TIME "dateTime"    
#define HCBE_TYPE_BOOLEAN "boolean"   
#define HCBE_TYPE_BYTE_ARRAY "byteArray"   
#define HCBE_TYPE_SHORT_ARRAY "shortArray"
#define HCBE_TYPE_INT_ARRAY "intArray"   
#define HCBE_TYPE_LONG_ARRAY "longArray"    
#define HCBE_TYPE_FLOAT_ARRAY "floatArray"
#define HCBE_TYPE_DOUBLE_ARRAY "doubleArray"    
#define HCBE_TYPE_STRING_ARRAY "stringArray"   
#define HCBE_TYPE_DATE_TIME_ARRAY "dateTimeArray"
#define HCBE_TYPE_BOOLEAN_ARRAY "booleanArray"   
#define HCBE_TYPE_HEX_BINARY "hexBinary"    

typedef	char* (*hcbe_ExtendedDataElementGetFP)(struct hcbe_ExtendedDataElement*);
typedef void (*hcbe_ExtendedDataElementSetFP)(struct hcbe_ExtendedDataElement*, char*);
typedef	char** (*hcbe_ExtendedDataElementGetValuesFP)(struct hcbe_ExtendedDataElement*);
typedef void (*hcbe_ExtendedDataElementSetValuesFP)(struct hcbe_ExtendedDataElement*, char**, int);
typedef struct hcbe_ExtendedDataElement** (*hcbe_ExtendedDataElementGetChildrenFP)(struct hcbe_ExtendedDataElement*);
typedef void (*hcbe_ExtendedDataElementSetChildrenFP)(struct hcbe_ExtendedDataElement*, struct hcbe_ExtendedDataElement**, int);
typedef int (*hcbe_ExtendedDataElementArrGetCounterFP)(struct hcbe_ExtendedDataElement*);
typedef int (*hcbe_ExtendedDataElementGetTypeAsIntFP)(struct hcbe_ExtendedDataElement*);

typedef struct {      	
    hcbe_ExtendedDataElementGetFP getName,
							 getType,
							 getHexValue;

    hcbe_ExtendedDataElementSetFP setName,
							 setType,
							 setHexValue;

	hcbe_ExtendedDataElementGetValuesFP getValues;
    hcbe_ExtendedDataElementSetValuesFP setValues;

	hcbe_ExtendedDataElementGetChildrenFP getChildren;
	hcbe_ExtendedDataElementSetChildrenFP setChildren;

	hcbe_ExtendedDataElementArrGetCounterFP getValuesSize,
									   getChildrenSize;

	hcbe_ExtendedDataElementGetTypeAsIntFP getTypeAsInt;

}hcbe_ExtendedDataElementFPTable;

typedef struct hcbe_ExtendedDataElement
{
	char* _name;
    char* _type;
	char** _values;    	
	char* _hexValue;
	struct hcbe_ExtendedDataElement** _children;

	int _valuesSize;
	int _childrenSize;
    int _deserialized;

	hcbe_ExtendedDataElementFPTable* fpRoot;
}hcbe_ExtendedDataElement;

hcbe_ExtendedDataElement* hcbe_extendedDataElementConstr();

char* hcbe_extendedDataElementDestr(hcbe_ExtendedDataElement* extendedDataElement);

/*
	SituationType Declarations
*/

#define HCBE_START_SITUATION 0
#define HCBE_STOP_SITUATION 1
#define HCBE_CONNECT_SITUATION 2
#define HCBE_REPORT_SITUATION 3
#define HCBE_FEATURE_SITUATION 4
#define HCBE_CONFIGURE_SITUATION 5
#define HCBE_DEPENDENCY_SITUATION 6
#define HCBE_CREATE_SITUATION 7
#define HCBE_DESTROY_SITUATION 8
#define HCBE_AVAILABLE_SITUATION 9
#define HCBE_REQUEST_SITUATION 10
#define HCBE_OTHER_SITUATION 11

#define HCBE_SITUATION_TYPE_BADTYPE_ERR 1
#define HCBE_SITUATION_TYPE_BADTYPE_ERR_MSG "Invalid type Specified"
#define HCBE_SITUATION_TYPE_NOMEMORY_ERR 2
#define HCBE_SITUATION_TYPE_NOMEMORY_ERR_MSG "Insufficient available memory"

typedef char* (*hcbe_SituationTypeGetFP) (struct hcbe_SituationType*, char*);
typedef char* (*hcbe_SituationTypeSetFP) (struct hcbe_SituationType*, char*);

typedef struct hcbe_SituationTypeFPTable
{
    hcbe_SituationTypeGetFP getReasoningScope;
    hcbe_SituationTypeGetFP getSuccessDisposition;
    hcbe_SituationTypeGetFP getSituationQualifier;
    hcbe_SituationTypeGetFP getSituationDisposition;
    hcbe_SituationTypeGetFP getReportCategory;
    hcbe_SituationTypeGetFP getFeatureDisposition;
    hcbe_SituationTypeGetFP getDependencyDisposition;
    hcbe_SituationTypeGetFP getOperationDisposition;
    hcbe_SituationTypeGetFP getProcessingDisposition;
    hcbe_SituationTypeGetFP getAvailabilityDisposition;
    hcbe_SituationTypeGetFP getAnyData;

    hcbe_SituationTypeSetFP setReasoningScope;
    hcbe_SituationTypeSetFP setSuccessDisposition;
    hcbe_SituationTypeSetFP setSituationQualifier;
    hcbe_SituationTypeSetFP setSituationDisposition;
    hcbe_SituationTypeSetFP setReportCategory;
    hcbe_SituationTypeSetFP setFeatureDisposition;
    hcbe_SituationTypeSetFP setDependencyDisposition;
    hcbe_SituationTypeSetFP setOperationDisposition;
    hcbe_SituationTypeSetFP setProcessingDisposition;
    hcbe_SituationTypeSetFP setAvailabilityDisposition;
    hcbe_SituationTypeSetFP setAnyData;
}hcbe_SituationTypeFPTable;

typedef struct hcbe_SituationType
{
    int type;
	char* reasoningScope;
    char* successDisposition;
	char* situationQualifier;
    char* situationDisposition;
    char* reportCategory;
    char* featureDisposition;
    char* dependencyDisposition;
    char* operationDisposition;
    char* processingDisposition;
    char* availabilityDisposition;
    char* anyData;
    int _deserialized;
	hcbe_SituationTypeFPTable* fpRoot;

}hcbe_SituationType;

hcbe_SituationType* hcbe_situationTypeConstr(int type, int* err);

char* hcbe_situationTypeDestr(hcbe_SituationType* situationType);


/*
	Situation Declarations
*/
typedef char* (*hcbe_SituationGetFP) (struct hcbe_Situation*);
typedef void (*hcbe_SituationSetFP) (struct hcbe_Situation*, char*);
typedef hcbe_SituationType* (*hcbe_SituationGetSituationTypeFP) (struct hcbe_Situation*);
typedef void (*hcbe_SituationSetSituationTypeFP) (struct hcbe_Situation*, hcbe_SituationType*);

typedef struct hcbe_SituationFPTable
{
    hcbe_SituationGetFP getCategoryName;
    hcbe_SituationGetSituationTypeFP getSituationType;
    hcbe_SituationSetFP setCategoryName;
    hcbe_SituationSetSituationTypeFP setSituationType;
}hcbe_SituationFPTable;

typedef struct hcbe_Situation
{
	char* categoryName;
    hcbe_SituationType* situationType;
    int _deserialized;
	hcbe_SituationFPTable* fpRoot;
}hcbe_Situation;

hcbe_Situation* hcbe_situationConstr();

char* hcbe_situationDestr(hcbe_Situation* situation);


/*
	CommonBaseEvent Declarations
*/
typedef char* (*hcbe_CommonBaseEventGetStringFP) (struct hcbe_CommonBaseEvent*);
typedef void (*hcbe_CommonBaseEventSetStringFP) (struct hcbe_CommonBaseEvent*, char*);
typedef short (*hcbe_CommonBaseEventGetShortFP) (struct hcbe_CommonBaseEvent*);
typedef void (*hcbe_CommonBaseEventSetShortFP) (struct hcbe_CommonBaseEvent*, short);
typedef long (*hcbe_CommonBaseEventGetLongFP) (struct hcbe_CommonBaseEvent*);
typedef void (*hcbe_CommonBaseEventSetLongFP) (struct hcbe_CommonBaseEvent*, long);

typedef hcbe_ComponentIdentification* (*hcbe_CommonBaseEventGetCompIdFP)(struct hcbe_CommonBaseEvent*);
typedef void (*hcbe_CommonBaseEventSetCompIdFP)(struct hcbe_CommonBaseEvent*, hcbe_ComponentIdentification*);
typedef hcbe_Situation* (*hcbe_CommonBaseEventGetSituationFP)(struct hcbe_CommonBaseEvent*);
typedef void (*hcbe_CommonBaseEventSetSituationFP)(struct hcbe_CommonBaseEvent*, hcbe_Situation*);
typedef hcbe_ContextDataElement** (*hcbe_CommonBaseEventGetContextDataElementsFP)(struct hcbe_CommonBaseEvent*);
typedef void (*hcbe_CommonBaseEventSetContextDataElementsFP)(struct hcbe_CommonBaseEvent*, hcbe_ContextDataElement**, int);  
typedef hcbe_MsgDataElement* (*hcbe_CommonBaseEventGetMsgDataElementFP)(struct hcbe_CommonBaseEvent*);
typedef void (*hcbe_CommonBaseEventSetMsgDataElementFP)(struct hcbe_CommonBaseEvent*, hcbe_MsgDataElement*);
typedef hcbe_AssociatedEvent** (*hcbe_CommonBaseEventGetAssociatedEventsFP)(struct hcbe_CommonBaseEvent*);
typedef void (*hcbe_CommonBaseEventSetAssociatedEventsFP)(struct hcbe_CommonBaseEvent*, hcbe_AssociatedEvent**, int);
typedef hcbe_ExtendedDataElement** (*hcbe_CommonBaseEventGetExtendedDataElementsFP)(struct hcbe_CommonBaseEvent*);
typedef void (*hcbe_CommonBaseEventSetExtendedDataElementsFP)(struct hcbe_CommonBaseEvent*, hcbe_ExtendedDataElement**, int);
typedef char** (*hcbe_CommonBaseEventGetAnyFP)(struct hcbe_CommonBaseEvent*);
typedef void (*hcbe_CommonBaseEventSetAnyFP)(struct hcbe_CommonBaseEvent*, char**, int);
typedef int (*hcbe_CommonBaseEventArrGetCounterFP)(struct hcbe_CommonBaseEvent*);
typedef int (*hcbe_CommonBaseEventAnyGetCounterFP)(struct hcbe_CommonBaseEvent*);

typedef struct
{
    hcbe_CommonBaseEventGetStringFP getVersion,
			       getLocalInstanceId,
			       getGlobalInstanceId,
			       getCreationTime,
			       getMsg,
			       getExtensionName;


    hcbe_CommonBaseEventSetStringFP setVersion,
                               setLocalInstanceId,
                               setGlobalInstanceId,
                               setCreationTime,
                               setMsg,
                               setExtensionName;

    hcbe_CommonBaseEventGetShortFP getSeverity,
			                  getPriority,
			                  getRepeatCount;

    hcbe_CommonBaseEventSetShortFP setSeverity,
                              setPriority,
                              setRepeatCount;

    hcbe_CommonBaseEventGetLongFP getElapsedTime,
                             getSequenceNumber;

    hcbe_CommonBaseEventSetLongFP setElapsedTime,
                             setSequenceNumber;

    hcbe_CommonBaseEventGetCompIdFP getReporterComponentIdentification,
                               getSourceComponentIdentification;

    hcbe_CommonBaseEventSetCompIdFP setReporterComponentIdentification,
                               setSourceComponentIdentification;

    hcbe_CommonBaseEventGetSituationFP getSituation;
    hcbe_CommonBaseEventSetSituationFP setSituation;

    hcbe_CommonBaseEventGetContextDataElementsFP getContextDataElements;
    hcbe_CommonBaseEventSetContextDataElementsFP setContextDataElements;

    hcbe_CommonBaseEventGetMsgDataElementFP getMsgDataElement;
    hcbe_CommonBaseEventSetMsgDataElementFP setMsgDataElement;

    hcbe_CommonBaseEventGetAssociatedEventsFP getAssociatedEvents;
    hcbe_CommonBaseEventSetAssociatedEventsFP setAssociatedEvents;

    hcbe_CommonBaseEventGetExtendedDataElementsFP getExtendedDataElements;
    hcbe_CommonBaseEventSetExtendedDataElementsFP setExtendedDataElements;

	hcbe_CommonBaseEventGetAnyFP getAny;
	hcbe_CommonBaseEventSetAnyFP setAny;

	hcbe_CommonBaseEventArrGetCounterFP getContextDataElementsSize,
								   getAssociatedEventsSize,
	                               getExtendedDataElementsSize,
	    						   getAnySize;

}hcbe_CommonBaseEventFPTable;

typedef struct hcbe_CommonBaseEvent
{
	char* _version;
    char* _localInstanceId;
    char* _globalInstanceId;
    char* _creationTime;
    short _severity;
    short _priority;
    hcbe_ComponentIdentification* _reporterComponentId;
    hcbe_ComponentIdentification* _sourceComponentId;
    hcbe_Situation* _situation;
    hcbe_ContextDataElement** _contextDataElements;
    hcbe_MsgDataElement* _msgDataElement;
    char* _msg;
    short _repeatCount;
    long _elapsedTime;
    hcbe_AssociatedEvent** _associatedEvents;
    char* _extensionName;
    hcbe_ExtendedDataElement** _extendedDataElements;
    long _sequenceNumber;
	char** _any;
	 
    int _isSetCreationTime;
    int _isSetElapsedTime;
    int _isSetPriority;
    int _isSetRepeatCount;
    int _isSetSequenceNumber;
    int _isSetSeverity;

	int _contextDataElementsSize;
	int _associatedEventsSize;
	int _extendedDataElementsSize;
	int _anySize;
    int _deserialized;

	hcbe_CommonBaseEventFPTable* fpRoot;

}hcbe_CommonBaseEvent;

hcbe_CommonBaseEvent* hcbe_commonBaseEventConstr();

char* hcbe_commonBaseEventDestr(hcbe_CommonBaseEvent*);

/* declaration for serializing and deserializing */

int hcbe_associationEngineToCanonicalXMLString(hcbe_AssociationEngine*, char*, int);

int hcbe_associationEngineToCanonicalXMLDocString(hcbe_AssociationEngine*, char*, int);

int hcbe_commonBaseEventToCanonicalXMLString(hcbe_CommonBaseEvent*, char*, int, int); 

int hcbe_commonBaseEventToCanonicalXMLDocString(hcbe_CommonBaseEvent*, char*, int, int);

hcbe_AssociationEngine* hcbe_associationEngineFromCanonicalXMLString(char* xmlString);

hcbe_AssociationEngine* hcbe_associationEngineFromCanonicalXMLDocString(char* aXMLDocString);

hcbe_CommonBaseEvent* hcbe_commonBaseEventFromCanonicalXMLString(char* xmlString);

hcbe_CommonBaseEvent* hcbe_commonBaseEventFromCanonicalXMLDocString(char* aXMLDocString);

int hcbe_xmlUtilityNormalize(char*, const char*, int);

int hcbe_xmlUtilityDenormalize(char*, const char*, int);

int hcbe_serialize(char* fileName, char*);

int hcbe_generateGUID(char* guid);

int hcbe_getCurrentTimeUTC(char* timestamp);

#ifdef __cplusplus
}
#endif

#endif