/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.internal.util;

import org.eclipse.hyades.logging.adapter.AdapterException;
import org.eclipse.hyades.logging.adapter.AdapterPlugin;
import org.eclipse.hyades.logging.adapter.IComponent;
import org.eclipse.hyades.logging.adapter.parsers.PreparationException;
import org.eclipse.hyades.logging.adapter.util.Messages;

public class ComponentLoaderUtil {
    public static Object instantiate(String className, String impls) throws PreparationException {
        Class<?> c;
        try {
            IComponent component = AdapterPlugin.getComponent(className);
            if (component != null) {
                return component;
            }
        }
        catch (AdapterException e) {
            throw new PreparationException(Messages.getString("HyadesGAInstantiation_ERROR_", className), e);
        }
        catch (Throwable e) {
            // empty catch block
        }
        try {
            c = Class.forName(impls);
        }
        catch (ClassNotFoundException eprime) {
            throw new PreparationException(Messages.getString("HyadesGAClassLoad_ERROR_", impls));
        }
        try {
            Class<?> o = Class.forName(className);
            Object res = null;
            try {
                res = o.newInstance();
            }
            catch (Throwable t) {
                res = o.getMethod("getInstance", null).invoke(null, null);
            }
            if (c.isInstance(res)) {
                return res;
            }
            throw new PreparationException(Messages.getString("HyadesGAInitialization_Invalid_Class_Failure_ERROR_", className, impls));
        }
        catch (ClassNotFoundException eprime) {
            throw new PreparationException(Messages.getString("HyadesGAClassLoad_ERROR_", className));
        }
        catch (IllegalAccessException eprime) {
            throw new PreparationException(Messages.getString("HyadesGAAccess_ERROR_", className));
        }
        catch (Throwable eprime) {
            throw new PreparationException(Messages.getString("HyadesGAInstantiation_ERROR_", className), eprime);
        }
    }
}

