/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IService.java,v 1.3 2005/02/16 22:20:27 qiyanli Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
import java.rmi.Remote;
import java.rmi.RemoteException;


/**
 * This interface defines two simple services: saying hello and adding two integers.
 * 
 * @author Richard Duggan, Qiayn Li
 */
public interface IService extends Remote {

    /**
     * Returns the message "Hello name!".  If the name is <code>null</code>, the message
     * "Hello there!" will be returned instead.
     * 
     * @param name  the name for the message
     * @return  the message "Hello name!" if the name is not <code>null</code>,
     *          otherwise the message "Hello there!" will be returned
     */
    public String hello(String name) throws RemoteException;

    /**
     * Adds two integers, and returns the result.
     * 
     * @param x the first integer 
     * @param y the first integer
     * @return  the sum of x and y 
     */
    public Long add(int x, int y) throws RemoteException;
}