/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.internal.execution.file;

import java.io.IOException;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import org.eclipse.hyades.internal.execution.core.file.SocketChannelFactory;
import org.eclipse.hyades.internal.execution.file.IConnectionHandler;
import org.eclipse.hyades.internal.execution.file.IFileServer;
import org.eclipse.hyades.internal.execution.file.IFileServerParameters;

class FileServerExtended
implements Runnable,
IFileServer {
    private static final int DEFAULT_SOCKET_TIMEOUT = 5000;
    private IFileServerParameters parameters;
    private ServerSocketChannel serverSocket;
    private int serverStatus = 0;
    private int errorType = 0;
    private int initStatus = 0;
    private boolean shutdown = false;
    private boolean isRunning = false;

    FileServerExtended() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void cleanup() {
        try {
            this.serverSocket.close();
            this.serverSocket = null;
            this.parameters = null;
            return;
        }
        catch (IOException e) {}
        finally {
            return;
        }
    }

    protected void finalize() {
        this.cleanup();
    }

    public int getErrorType() {
        return this.errorType;
    }

    public synchronized int getFileServerStatus() {
        block2: {
            long timeout = 5000L;
            if (this.initStatus == 1 || !this.isRunning) break block2;
            try {
                this.wait(5000L);
            }
            catch (InterruptedException e) {}
        }
        return this.serverStatus;
    }

    private int getPort() {
        return this.parameters.getPort();
    }

    public void init(IFileServerParameters parameters) {
        this.parameters = parameters;
    }

    public void quit() {
        this.shutdown = true;
        this.cleanup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        FileServerExtended fileServerExtended = this;
        synchronized (fileServerExtended) {
            if (this.isRunning) {
                return;
            }
            this.isRunning = true;
        }
        try {
            try {
                FileServerExtended fileServerExtended2 = this;
                synchronized (fileServerExtended2) {
                    this.serverSocket = ServerSocketChannel.open();
                    this.serverSocket.configureBlocking(true);
                    this.serverSocket.socket().setSoTimeout(5000);
                    this.serverSocket.socket().bind(new InetSocketAddress(this.getPort()));
                    this.initStatus = 1;
                    this.notifyAll();
                }
                while (true) {
                    if (this.shutdown) {
                    }
                    SocketChannel clientChannel = this.serverSocket.accept();
                    clientChannel.socket().setSoTimeout(5000);
                    clientChannel.socket().setTcpNoDelay(true);
                    IConnectionHandler handler = (IConnectionHandler)this.parameters.getConnectionHandler();
                    handler.connectionAccepted(SocketChannelFactory.getInstance().create(clientChannel));
                }
            }
            catch (BindException e) {
                this.serverStatus = -1;
                this.errorType = -10;
                this.initStatus = 1;
            }
            catch (IOException e) {
                this.serverStatus = -1;
                this.errorType = -9;
                this.initStatus = 1;
            }
            finally {
            }
        }
        catch (Throwable throwable) {
            Object var6_10 = null;
            this.cleanup();
            throw throwable;
        }
    }
}

