/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.internal.config.generator;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Hashtable;
import org.eclipse.hyades.internal.config.generator.AgentControllerConfig;
import org.eclipse.hyades.internal.config.generator.AgentControllerEnvironment;
import org.eclipse.hyades.internal.config.generator.Allow;
import org.eclipse.hyades.internal.config.generator.Application;
import org.eclipse.hyades.internal.config.generator.ConfigUtility;
import org.eclipse.hyades.internal.config.generator.HashUtility;
import org.eclipse.hyades.internal.config.generator.Hosts;
import org.eclipse.hyades.internal.config.generator.Logger;
import org.eclipse.hyades.internal.config.generator.PlatformObject;
import org.eclipse.hyades.internal.config.generator.Plugin;
import org.eclipse.hyades.internal.config.generator.SetConfigSkeleton;
import org.eclipse.hyades.internal.config.generator.TestJvm;
import org.eclipse.hyades.internal.config.generator.Variable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SetConfig
extends SetConfigSkeleton {
    private static boolean help = false;
    private static boolean examples = false;

    public static void main(String[] stringArray) {
        SetConfig setConfig = new SetConfig();
        if (TestJvm.isMinimumVersion(ConfigUtility.getString("Config.Java.Version"), System.getProperty("java.version"))) {
            int n = 100;
            Hashtable hashtable = new Hashtable(n);
            setConfig.populateHashtable(hashtable, stringArray);
            setConfig.processParameters(hashtable);
            if (help) {
                setConfig.printHelp();
                setConfig.printPluginHelp(hashtable);
                return;
            }
            if (examples) {
                setConfig.printExamples();
                setConfig.printPluginExamples(hashtable);
                return;
            }
            setConfig.setFileName(HashUtility.getValue(hashtable, "RASERVER_HOME") + SetConfigSkeleton.sr + "config" + SetConfigSkeleton.sr + "serviceconfig.xml");
            setConfig.run(hashtable, SetConfigSkeleton.silent, SetConfigSkeleton.overwrite);
            setConfig.generatePluginConfigurations(hashtable);
        } else {
            System.out.println(ConfigUtility.getString("Config.Prompt.JAVA_Version.Err") + ": " + ConfigUtility.getString("Config.Java.Version"));
            System.out.println(ConfigUtility.getString("Config.Prompt.JAVA_Version.Msg"));
        }
    }

    public void init(Hashtable hashtable) {
        String string = HashUtility.getValue(hashtable, "RASERVER_HOME");
        this.setFileName(string + SetConfigSkeleton.sr + "config" + SetConfigSkeleton.sr + "serviceconfig.xml");
    }

    private void processParameters(Hashtable hashtable) {
        if (HashUtility.getValue(hashtable, "RASERVER_HOME") == null) {
            File file = new File("..");
            try {
                HashUtility.setValue(hashtable, "RASERVER_HOME", file.getCanonicalPath());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (HashUtility.exist(hashtable, "-help") || HashUtility.exist(hashtable, "-h") || HashUtility.exist(hashtable, "-?")) {
            help = true;
        }
        if (HashUtility.exist(hashtable, "-example") || HashUtility.exist(hashtable, "-ex")) {
            examples = true;
        }
        if (HashUtility.exist(hashtable, "-debug")) {
            Logger.setDebug(true);
        }
        if (HashUtility.exist(hashtable, "-overwrite") || HashUtility.exist(hashtable, "-ovr")) {
            SetConfigSkeleton.overwrite = true;
        }
        if (HashUtility.exist(hashtable, "-silent") || HashUtility.exist(hashtable, "-s")) {
            SetConfigSkeleton.silent = true;
        }
        if (HashUtility.exist(hashtable, "-noverify") || HashUtility.exist(hashtable, "-nov")) {
            SetConfigSkeleton.verify = false;
        }
    }

    public void askUser() {
        Object var1_1 = null;
        if (!this.isValidRaserverHome(this.configFile.getValue("RASERVER_HOME"))) {
            if (SetConfigSkeleton.silent) {
                return;
            }
            String string = this.promptRaserverHome(this.configFile.getValue("RASERVER_HOME"));
            this.configFile.setValue("RASERVER_HOME", string);
            this.configFile.setFileName(string + SetConfigSkeleton.sr + "config" + SetConfigSkeleton.sr + "serviceconfig.xml");
        }
        if (PlatformObject.name.equals("OS/400")) {
            this.configFile.setValue("JAVA_PATH", "/QSYS.LIB/Q5BVAJVM.PGM");
        } else if (SetConfigSkeleton.silent) {
            if (this.configFile.getValue("JAVA_PATH") == null || this.configFile.getValue("JAVA_PATH").equals("")) {
                if (this.isValidJava(System.getProperty("java.home") + SetConfigSkeleton.sr + "bin" + SetConfigSkeleton.sr + "java" + PlatformObject.exeExt)) {
                    this.configFile.setValue("JAVA_PATH", System.getProperty("java.home") + SetConfigSkeleton.sr + "bin" + SetConfigSkeleton.sr + "java" + PlatformObject.exeExt);
                } else {
                    this.configFile.setValue("JAVA_PATH", "%JAVA_PATH%");
                }
            }
        } else if (this.configFile.getValue("JAVA_PATH") == null) {
            this.configFile.setValue("JAVA_PATH", this.promptJavaPath(System.getProperty("java.home") + SetConfigSkeleton.sr + "bin" + SetConfigSkeleton.sr + "java" + PlatformObject.exeExt));
        } else {
            this.configFile.setValue("JAVA_PATH", this.promptJavaPath(this.configFile.getValue("JAVA_PATH")));
        }
        String string = this.resolveJvmDll(this.configFile.getValue("JAVA_PATH"));
        this.configFile.setValue("jvm", string);
        if (SetConfigSkeleton.silent) {
            if (this.configFile.getValue("ALLOW") == null) {
                this.configFile.setValue("ALLOW", "LOCAL");
            }
        } else if (this.configFile.getValue("ALLOW") == null) {
            this.configFile.setValue("ALLOW", this.promptAllow("LOCAL"));
        } else {
            this.configFile.setValue("ALLOW", this.promptAllow(this.configFile.getValue("ALLOW")));
        }
        if (this.configFile.getValue("ALLOW").toUpperCase().equals("CUSTOM")) {
            if (SetConfigSkeleton.silent) {
                if (this.configFile.getValue("HOSTS") == null) {
                    this.configFile.setValue("HOSTS", "localhost");
                }
            } else if (this.configFile.getValue("HOSTS") == null) {
                this.configFile.setValue("HOSTS", this.promptHosts("localhost"));
            } else {
                this.configFile.setValue("HOSTS", this.promptHosts(this.configFile.getValue("HOSTS")));
            }
        }
    }

    private String promptRaserverHome(String string) {
        String string2 = null;
        System.out.println(ConfigUtility.getString("Config.Prompt.RASERVER_HOME.Tag"));
        System.out.print("  " + ConfigUtility.getString("Config.Prompt.Default") + "\"" + string + "\"");
        System.out.print(" (");
        System.out.print(ConfigUtility.getString("Config.Prompt.DefaultAccept"));
        System.out.println(")");
        do {
            System.out.print("  " + ConfigUtility.getString("Config.Prompt.NewValue"));
        } while (!this.isValidRaserverHome(string2 = ConfigUtility.askUser(string)));
        return string2;
    }

    private String promptJavaPath(String string) {
        String string2 = null;
        if (PlatformObject.name.startsWith("Windows")) {
            System.out.println(ConfigUtility.getString("Config.Prompt.JAVA_PATH.Tag.Windows"));
        } else {
            System.out.println(ConfigUtility.getString("Config.Prompt.JAVA_PATH.Tag.Unix"));
        }
        System.out.print("  " + ConfigUtility.getString("Config.Prompt.Default") + "\"" + string + "\"");
        System.out.print(" (");
        System.out.print(ConfigUtility.getString("Config.Prompt.DefaultAccept"));
        System.out.println(")");
        do {
            System.out.print("  " + ConfigUtility.getString("Config.Prompt.NewValue"));
        } while (!this.isValidJava(string2 = ConfigUtility.askUser(string)));
        return string2;
    }

    private String promptAllow(String string) {
        String string2 = null;
        System.out.println(ConfigUtility.getString("Config.Prompt.Allow.Tag"));
        System.out.print("  " + ConfigUtility.getString("Config.Prompt.Default") + "\"" + string + "\"");
        System.out.print(" (");
        System.out.print(ConfigUtility.getString("Config.Prompt.DefaultAccept"));
        System.out.println(")");
        do {
            System.out.print("  " + ConfigUtility.getString("Config.Prompt.NewValue"));
        } while (!this.isValidAllow(string2 = ConfigUtility.askUser(string)));
        return string2;
    }

    private String promptHosts(String string) {
        System.out.println(ConfigUtility.getString("Config.Prompt.Hosts.Tag"));
        System.out.print("  " + ConfigUtility.getString("Config.Prompt.Default") + "\"" + string + "\"");
        System.out.print(" (");
        System.out.print(ConfigUtility.getString("Config.Prompt.DefaultAccept"));
        System.out.println(")");
        System.out.print("  " + ConfigUtility.getString("Config.Prompt.NewValue"));
        return ConfigUtility.askUser(string);
    }

    private boolean isValidRaserverHome(String string) {
        if (!SetConfigSkeleton.verify) {
            return true;
        }
        boolean bl = false;
        if (string == null) {
            System.out.println(ConfigUtility.getString("Config.Prompt.InvalidValue"));
            return false;
        }
        File file = new File(string);
        if (file.exists() && file.isDirectory()) {
            if (PlatformObject.name.equals("OS/400")) {
                File file2 = new File(file.getAbsolutePath() + File.separator + "bin" + File.separator + "SetConfig.sh");
                if (file2.exists()) {
                    bl = true;
                }
            } else {
                File file3 = new File(file.getAbsolutePath() + File.separator + "bin" + File.separator + "RAServer" + PlatformObject.exeExt);
                if (file3.exists()) {
                    bl = true;
                }
            }
        }
        if (!bl) {
            System.out.println(ConfigUtility.getString("Config.Prompt.InvalidValue"));
        }
        return bl;
    }

    private boolean isValidJava(String string) {
        if (!SetConfigSkeleton.verify) {
            return true;
        }
        if (string == null) {
            System.out.println(ConfigUtility.getString("Config.Prompt.JAVA_PATH.Err"));
            return false;
        }
        File file = new File(string);
        if (file.exists() && file.isFile()) {
            boolean bl = TestJvm.isSupportedJava(string, ConfigUtility.getString("Config.Java.Version"));
            if (!bl) {
                System.out.println(ConfigUtility.getString("Config.Prompt.JAVA_Version.Err") + ": " + ConfigUtility.getString("Config.Java.Version"));
            }
            return bl;
        }
        System.out.println(ConfigUtility.getString("Config.Prompt.JAVA_PATH.Err"));
        return false;
    }

    private boolean isValidAllow(String string) {
        if (!SetConfigSkeleton.verify) {
            return true;
        }
        boolean bl = false;
        if (string == null) {
            System.out.println(ConfigUtility.getString("Config.Prompt.Allow.Err"));
            return false;
        }
        if (string.toLowerCase().equals("all") || string.toLowerCase().equals("local") || string.toLowerCase().equals("custom")) {
            bl = true;
        }
        if (!bl) {
            System.out.println(ConfigUtility.getString("Config.Prompt.Allow.Err"));
        }
        return bl;
    }

    private boolean isValidHosts(String string) {
        if (!SetConfigSkeleton.verify) {
            return true;
        }
        return string != null;
    }

    private boolean isWritable(String string) {
        File file = new File(string);
        if (file.exists()) {
            return file.canWrite();
        }
        return file.getParentFile().canWrite();
    }

    private void populateHashtable(Hashtable hashtable, String[] stringArray) {
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                int n2 = stringArray[n].indexOf(61);
                if (n2 == -1) {
                    HashUtility.setValue(hashtable, stringArray[n], "");
                } else {
                    String string = this.trim(stringArray[n].substring(0, n2));
                    String string2 = this.trim(stringArray[n].substring(n2 + 1));
                    if (string != null && string2 != null) {
                        HashUtility.setValue(hashtable, string, string2);
                    }
                }
                ++n;
            }
        }
    }

    public void printHelp() {
        if (PlatformObject.name.startsWith("Windows")) {
            System.out.println(ConfigUtility.getString("Config.Cmd.Usage.Windows"));
        } else {
            System.out.println(ConfigUtility.getString("Config.Cmd.Usage.Unix"));
        }
        System.out.println(ConfigUtility.getString("Config.Cmd.Flags"));
        System.out.println(ConfigUtility.getString("Config.Cmd.Help.Tag"));
        System.out.println("\t" + ConfigUtility.getString("Config.Cmd.Help.Msg"));
        System.out.println(ConfigUtility.getString("Config.Cmd.Silent.Tag"));
        System.out.println("\t" + ConfigUtility.getString("Config.Cmd.Silent.Msg"));
        System.out.println(ConfigUtility.getString("Config.Cmd.NoVerify.Tag"));
        System.out.println("\t" + ConfigUtility.getString("Config.Cmd.NoVerify.Msg"));
        System.out.println(ConfigUtility.getString("Config.Cmd.Examples.Tag"));
        System.out.println("\t" + ConfigUtility.getString("Config.Cmd.Examples.Msg"));
        System.out.println();
        System.out.println(ConfigUtility.getString("Config.Cmd.Params"));
        System.out.println(ConfigUtility.getString("Config.Cmd.RASERVER_HOME.Tag"));
        System.out.println("\t" + ConfigUtility.getString("Config.Cmd.RASERVER_HOME.Msg"));
        System.out.println(ConfigUtility.getString("Config.Cmd.JAVA_PATH.Tag"));
        System.out.println("\t" + ConfigUtility.getString("Config.Cmd.JAVA_PATH.Msg"));
        System.out.println(ConfigUtility.getString("Config.Cmd.ALLOW.Tag"));
        System.out.println("\t" + ConfigUtility.getString("Config.Cmd.ALLOW.Msg"));
        System.out.println(ConfigUtility.getString("Config.Cmd.HOSTS.Tag"));
        System.out.println("\t" + ConfigUtility.getString("Config.Cmd.HOSTS.Msg"));
    }

    public void printExamples() {
        System.out.println(ConfigUtility.getString("Config.Example.Tag"));
        System.out.println(ConfigUtility.getString("Config.Example.00.Tag"));
        if (PlatformObject.name.startsWith("Windows")) {
            System.out.println("\t" + ConfigUtility.getString("Config.Example.00.Msg.Windows"));
        } else {
            System.out.println("\t" + ConfigUtility.getString("Config.Example.00.Msg.Unix"));
        }
        System.out.println(ConfigUtility.getString("Config.Example.01.Tag"));
        if (PlatformObject.name.startsWith("Windows")) {
            System.out.println("\t" + ConfigUtility.getString("Config.Example.01.Msg.Windows"));
        } else {
            System.out.println("\t" + ConfigUtility.getString("Config.Example.01.Msg.Unix"));
        }
        System.out.println(ConfigUtility.getString("Config.Example.02.Tag"));
        if (PlatformObject.name.startsWith("Windows")) {
            System.out.println("\t" + ConfigUtility.getString("Config.Example.02.Msg.Windows"));
        } else {
            System.out.println("\t" + ConfigUtility.getString("Config.Example.02.Msg.Unix"));
        }
        System.out.println(ConfigUtility.getString("Config.Example.03.Tag"));
        if (PlatformObject.name.startsWith("Windows")) {
            System.out.println("\t" + ConfigUtility.getString("Config.Example.03.Msg.Windows"));
        } else {
            System.out.println("\t" + ConfigUtility.getString("Config.Example.03.Msg.Unix"));
        }
    }

    public void generateConfiguration() {
        String string = PlatformObject.sr;
        Document document = this.configFile.getDoc();
        if (document == null) {
            return;
        }
        Element element = document.createElement(AgentControllerConfig.TAG);
        Element element2 = this.configFile.getHolder();
        element2.appendChild(element);
        AgentControllerConfig.setActiveConfiguration(element, "default");
        AgentControllerConfig.setLoggingDetail(element, "LOW");
        AgentControllerConfig.setLoggingLevel(element, "INFORMATION");
        AgentControllerConfig.setPort(element, "10002");
        AgentControllerConfig.setSecuredPort(element, "10003");
        AgentControllerConfig.setVersion(element, ConfigUtility.getString("Config.AgentController.Version"));
        AgentControllerConfig.setFilePort(element, "10005");
        AgentControllerConfig.setProcessPolling(element, "true");
        AgentControllerConfig.setDataMultiplexed(element, "false");
        AgentControllerConfig.setVersion(element, ConfigUtility.getString("Config.AgentController.Version"));
        AgentControllerConfig.setJvm(element, this.configFile.getValue("jvm"));
        Element element3 = document.createElement(AgentControllerEnvironment.TAG);
        AgentControllerEnvironment.setConfiguration(element3, "default");
        element.appendChild(element3);
        Element element4 = document.createElement(Variable.TAG);
        Variable.setName(element4, "JAVA_PATH");
        Variable.setValue(element4, this.configFile.getValue("JAVA_PATH"));
        Variable.setPosition(element4, "replace");
        element3.appendChild(element4);
        element4 = document.createElement(Variable.TAG);
        Variable.setName(element4, "RASERVER_HOME");
        Variable.setValue(element4, this.configFile.getValue("RASERVER_HOME"));
        Variable.setPosition(element4, "replace");
        element3.appendChild(element4);
        element4 = document.createElement(Variable.TAG);
        Variable.setName(element4, PlatformObject.libEnv);
        Variable.setValue(element4, "%RASERVER_HOME%" + string + PlatformObject.libPath);
        Variable.setPosition(element4, "prepend");
        element3.appendChild(element4);
        element4 = document.createElement(Variable.TAG);
        Variable.setName(element4, "SYS_TEMP_DIR");
        Variable.setValue(element4, PlatformObject.tempDir);
        Variable.setPosition(element4, "replace");
        element3.appendChild(element4);
        element4 = document.createElement(Variable.TAG);
        Variable.setName(element4, "LOCAL_AGENT_TEMP_DIR");
        Variable.setValue(element4, "%SYS_TEMP_DIR%");
        Variable.setPosition(element4, "replace");
        element3.appendChild(element4);
        element4 = document.createElement(Variable.TAG);
        Variable.setName(element4, "CLASSPATH");
        Variable.setValue(element4, "%RASERVER_HOME%" + string + "lib" + string + "commons-logging.jar");
        Variable.setPosition(element4, "append");
        element3.appendChild(element4);
        element4 = document.createElement(Variable.TAG);
        Variable.setName(element4, "CLASSPATH");
        Variable.setValue(element4, "%RASERVER_HOME%" + string + "lib" + string + "hcframe.jar");
        Variable.setPosition(element4, "append");
        element3.appendChild(element4);
        element4 = document.createElement(Variable.TAG);
        Variable.setName(element4, "CLASSPATH");
        Variable.setValue(element4, "%RASERVER_HOME%" + string + "lib" + string + "hexcore.jar");
        Variable.setPosition(element4, "append");
        element3.appendChild(element4);
        element4 = document.createElement(Variable.TAG);
        Variable.setName(element4, "CLASSPATH");
        Variable.setValue(element4, "%RASERVER_HOME%" + string + "lib" + string + "hexl.jar");
        Variable.setPosition(element4, "append");
        element3.appendChild(element4);
        element4 = document.createElement(Variable.TAG);
        Variable.setName(element4, "CLASSPATH");
        Variable.setValue(element4, "%RASERVER_HOME%" + string + "lib" + string + "hexr.jar");
        Variable.setPosition(element4, "append");
        element3.appendChild(element4);
        element4 = document.createElement(Variable.TAG);
        Variable.setName(element4, "CLASSPATH");
        Variable.setValue(element4, "%RASERVER_HOME%" + string + "lib" + string + "hl14.jar");
        Variable.setPosition(element4, "append");
        element3.appendChild(element4);
        element4 = document.createElement(Variable.TAG);
        Variable.setName(element4, "CLASSPATH");
        Variable.setValue(element4, "%RASERVER_HOME%" + string + "lib" + string + "hlcommons.jar");
        Variable.setPosition(element4, "append");
        element3.appendChild(element4);
        element4 = document.createElement(Variable.TAG);
        Variable.setName(element4, "CLASSPATH");
        Variable.setValue(element4, "%RASERVER_HOME%" + string + "lib" + string + "hlcore.jar");
        Variable.setPosition(element4, "append");
        element3.appendChild(element4);
        element4 = document.createElement(Variable.TAG);
        Variable.setName(element4, "CLASSPATH");
        Variable.setValue(element4, "%RASERVER_HOME%" + string + "lib" + string + "hlevents.jar");
        Variable.setPosition(element4, "append");
        element3.appendChild(element4);
        element4 = document.createElement(Variable.TAG);
        Variable.setName(element4, "CLASSPATH");
        Variable.setValue(element4, "%RASERVER_HOME%" + string + "lib" + string + "hlcbe101.jar");
        Variable.setPosition(element4, "append");
        element3.appendChild(element4);
        element4 = document.createElement(Variable.TAG);
        Variable.setName(element4, "CLASSPATH");
        Variable.setValue(element4, "%RASERVER_HOME%" + string + "lib" + string + "ecore.jar");
        Variable.setPosition(element4, "append");
        element3.appendChild(element4);
        element4 = document.createElement(Variable.TAG);
        Variable.setName(element4, "CLASSPATH");
        Variable.setValue(element4, "%RASERVER_HOME%" + string + "lib" + string + "common.jar");
        Variable.setPosition(element4, "append");
        element3.appendChild(element4);
        element4 = document.createElement(Variable.TAG);
        Variable.setName(element4, "CLASSPATH");
        Variable.setValue(element4, "%RASERVER_HOME%" + string + "plugins" + string + "org.eclipse.hyades.test" + string + "lib" + string + "runtime.jar");
        Variable.setPosition(element4, "append");
        element3.appendChild(element4);
        Element element5 = document.createElement(Application.TAG);
        Application.setConfiguration(element5, "default");
        Application.setExecutable(element5, "java.exe");
        Application.setPath(element5, "%JAVA_PATH%");
        Application.setLocation(element5, "%SYS_TEMP_DIR%");
        element.appendChild(element5);
        Element element6 = document.createElement(Hosts.TAG);
        Hosts.setConfiguration(element6, "default");
        element.appendChild(element6);
        if (this.configFile.getValue("ALLOW") != null) {
            if (this.configFile.getValue("ALLOW").toLowerCase().equals("custom")) {
                String[] stringArray = ConfigUtility.stringToArray(this.configFile.getValue("HOSTS"));
                if (stringArray.length > 0) {
                    int n = 0;
                    while (n < stringArray.length) {
                        Element element7 = document.createElement(Allow.TAG);
                        element6.appendChild(element7);
                        if (stringArray[n].equalsIgnoreCase("all") || stringArray[n].equalsIgnoreCase("local")) {
                            Allow.setHost(element7, stringArray[n].toUpperCase());
                        } else {
                            Allow.setHost(element7, stringArray[n]);
                        }
                        ++n;
                    }
                } else {
                    Element element8 = document.createElement(Allow.TAG);
                    Allow.setHost(element8, "LOCAL");
                    element6.appendChild(element8);
                }
            } else {
                Element element9 = document.createElement(Allow.TAG);
                Allow.setHost(element9, this.configFile.getValue("ALLOW").toUpperCase());
                element6.appendChild(element9);
            }
        } else {
            Element element10 = document.createElement(Allow.TAG);
            Allow.setHost(element10, "LOCAL");
            element6.appendChild(element10);
        }
        Element element11 = document.createElement(Plugin.TAG);
        Plugin.setPath(element11, "%RASERVER_HOME%" + string + "plugins");
        element.appendChild(element11);
        this.configFile.saveToFile();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void generatePluginConfigurations(Hashtable hashtable) {
        String string = this.configFile.getValue("RASERVER_HOME");
        if (string != null) {
            String string2 = string + SetConfigSkeleton.sr + "plugins";
            File file = new File(string2);
            if (file.exists() && file.isDirectory()) {
                File[] fileArray = file.listFiles();
                int n = 0;
                while (n < fileArray.length) {
                    String string3 = fileArray[n].getName();
                    String string4 = string2.replace('\\', '/') + "/" + string3 + "/lib/config.jar";
                    String string5 = string3 + ".SetConfig";
                    Logger.out("Found plugin: " + string3);
                    try {
                        URL[] uRLArray = new URL[]{new URL("file", null, -1, string4)};
                        URLClassLoader uRLClassLoader = URLClassLoader.newInstance(uRLArray);
                        Class<?> clazz = uRLClassLoader.loadClass(string5);
                        Object obj = clazz.newInstance();
                        Method method = clazz.getMethod("init", hashtable.getClass());
                        Logger.out("About to call init()");
                        method.invoke(obj, hashtable);
                        Logger.out("Returned from init()");
                        Method method2 = clazz.getMethod("setLoader", Class.forName("java.lang.ClassLoader"));
                        Logger.out("About to call setLoader()");
                        method2.invoke(obj, uRLClassLoader);
                        Logger.out("Returned from setLoader()");
                        Method method3 = clazz.getMethod("run", hashtable.getClass(), Boolean.TYPE, Boolean.TYPE);
                        Logger.out("About to call run()");
                        method3.invoke(obj, hashtable, new Boolean(SetConfigSkeleton.silent), new Boolean(SetConfigSkeleton.overwrite));
                        Logger.out("Returned from run()");
                    }
                    catch (MalformedURLException malformedURLException) {
                        Logger.err(ConfigUtility.getString("Config.Extension.JarNotFound") + " " + string4);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        Logger.err(ConfigUtility.getString("Config.Extension.ClassNotFound") + " " + string5);
                        Logger.err(ConfigUtility.getString("Config.Extension.ClassNotFoundHint"));
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        Logger.err(ConfigUtility.getString("Config.Extension.MethodNotFound") + " run()");
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        Logger.err(ConfigUtility.getString("Config.Extension.MethodInvocationError") + " run()");
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        Logger.err(ConfigUtility.getString("Config.Extension.MethodInvocationError") + " run()");
                    }
                    catch (InstantiationException instantiationException) {
                        Logger.err(ConfigUtility.getString("Config.Extension.ObjectInstantiationError"));
                    }
                    ++n;
                }
                return;
            }
            Logger.out("Cannot access directory: " + string2);
            return;
        }
        Logger.out("RASERVER_HOME is not defined");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void printPluginHelp(Hashtable hashtable) {
        String string = HashUtility.getValue(hashtable, "RASERVER_HOME");
        if (string != null) {
            String string2 = string + SetConfigSkeleton.sr + "plugins";
            File file = new File(string2);
            if (file.exists() && file.isDirectory()) {
                File[] fileArray = file.listFiles();
                int n = 0;
                while (n < fileArray.length) {
                    String string3 = fileArray[n].getName();
                    String string4 = string2.replace('\\', '/') + "/" + string3 + "/lib/config.jar";
                    String string5 = string3 + ".SetConfig";
                    Logger.out("Found plugin: " + string3);
                    try {
                        URL[] uRLArray = new URL[]{new URL("file", null, -1, string4)};
                        URLClassLoader uRLClassLoader = new URLClassLoader(uRLArray, ClassLoader.getSystemClassLoader());
                        Class<?> clazz = uRLClassLoader.loadClass(string5);
                        Object obj = clazz.newInstance();
                        Method method = clazz.getMethod("init", hashtable.getClass());
                        Logger.out("About to call init()");
                        method.invoke(obj, hashtable);
                        Logger.out("Returned from init()");
                        Method method2 = clazz.getMethod("setLoader", Class.forName("java.lang.ClassLoader"));
                        Logger.out("About to call setLoader()");
                        method2.invoke(obj, uRLClassLoader);
                        Logger.out("Returned from setLoader()");
                        Method method3 = clazz.getMethod("printHelp", null);
                        Logger.out("About to call printHelp()");
                        method3.invoke(obj, null);
                        Logger.out("Returned from printHelp()");
                    }
                    catch (MalformedURLException malformedURLException) {
                        Logger.out(ConfigUtility.getString("Config.Extension.JarNotFound") + " " + string4);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        Logger.out(ConfigUtility.getString("Config.Extension.ClassNotFound") + " " + string5);
                        Logger.out(ConfigUtility.getString("Config.Extension.ClassNotFoundHint"));
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        Logger.out(ConfigUtility.getString("Config.Extension.MethodNotFound") + " run()");
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        Logger.out(ConfigUtility.getString("Config.Extension.MethodInvocationError") + " run()");
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        Logger.out(ConfigUtility.getString("Config.Extension.MethodInvocationError") + " run()");
                    }
                    catch (InstantiationException instantiationException) {
                        Logger.out(ConfigUtility.getString("Config.Extension.ObjectInstantiationError"));
                    }
                    ++n;
                }
                return;
            }
            Logger.out("Cannot access directory: " + string2);
            return;
        }
        Logger.out("RASERVER_HOME is not defined");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void printPluginExamples(Hashtable hashtable) {
        String string = HashUtility.getValue(hashtable, "RASERVER_HOME");
        if (string != null) {
            String string2 = string + SetConfigSkeleton.sr + "plugins";
            File file = new File(string2);
            if (file.exists() && file.isDirectory()) {
                File[] fileArray = file.listFiles();
                int n = 0;
                while (n < fileArray.length) {
                    String string3 = fileArray[n].getName();
                    String string4 = string2.replace('\\', '/') + "/" + string3 + "/lib/config.jar";
                    String string5 = string3 + ".SetConfig";
                    Logger.out("Found plugin: " + string3);
                    try {
                        URL[] uRLArray = new URL[]{new URL("file", null, -1, string4)};
                        URLClassLoader uRLClassLoader = new URLClassLoader(uRLArray, ClassLoader.getSystemClassLoader());
                        Class<?> clazz = uRLClassLoader.loadClass(string5);
                        Object obj = clazz.newInstance();
                        Method method = clazz.getMethod("init", hashtable.getClass());
                        Logger.out("About to call init()");
                        method.invoke(obj, hashtable);
                        Logger.out("Returned from init()");
                        Method method2 = clazz.getMethod("setLoader", Class.forName("java.lang.ClassLoader"));
                        Logger.out("About to call setLoader()");
                        method2.invoke(obj, uRLClassLoader);
                        Logger.out("Returned from setLoader()");
                        Method method3 = clazz.getMethod("printExamples", null);
                        Logger.out("About to call printExamples()");
                        method3.invoke(obj, null);
                        Logger.out("Returned from printExamples()");
                    }
                    catch (MalformedURLException malformedURLException) {
                        Logger.out(ConfigUtility.getString("Config.Extension.JarNotFound") + " " + string4);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        Logger.out(ConfigUtility.getString("Config.Extension.ClassNotFound") + " " + string5);
                        Logger.out(ConfigUtility.getString("Config.Extension.ClassNotFoundHint"));
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        Logger.out(ConfigUtility.getString("Config.Extension.MethodNotFound") + " run()");
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        Logger.out(ConfigUtility.getString("Config.Extension.MethodInvocationError") + " run()");
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        Logger.out(ConfigUtility.getString("Config.Extension.MethodInvocationError") + " run()");
                    }
                    catch (InstantiationException instantiationException) {
                        Logger.out(ConfigUtility.getString("Config.Extension.ObjectInstantiationError"));
                    }
                    ++n;
                }
                return;
            }
            Logger.out("Cannot access directory: " + string2);
            return;
        }
        Logger.out("RASERVER_HOME is not defined");
    }

    private String resolveJvmDll(String string) {
        if (PlatformObject.name.equals("OS/400")) {
            return new String("QSYS/QJVAJNI");
        }
        int n = string.lastIndexOf(SetConfigSkeleton.sr + "java" + PlatformObject.exeExt);
        if (n == -1 && (n = string.lastIndexOf(SetConfigSkeleton.sr + "javaw" + PlatformObject.exeExt)) == -1) {
            return new String("%JAVA_PATH%");
        }
        String string2 = string.substring(0, n);
        String string3 = null;
        try {
            string3 = ConfigUtility.getJvmLib(string2);
        }
        catch (Exception exception) {
            Logger.out(ConfigUtility.getString("Config.Jvm.Warning.CannotFindJvmLibrary") + ": " + PlatformObject.jvmLib);
        }
        if (string3 == null) {
            return new String("%JAVA_PATH%");
        }
        return string3;
    }
}

