/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.log4j;

import java.util.HashMap;
import java.util.Iterator;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Layout;
import org.apache.log4j.spi.LoggingEvent;
import org.eclipse.hyades.logging.core.LoggingAgent;
import org.eclipse.hyades.logging.log4j.XmlLayout;

public class LoggingAgentAppender
extends AppenderSkeleton {
    private static LoggingAgent defaultLoggingAgent = null;
    private static int instanceCount = 0;
    private static HashMap loggingAgents = new HashMap();
    private static final Object CURRENT_THREAD_LOCK = new Object();
    public static final String DEFAULT_LOGGER_NAME = "Default Logging IRemoteEntity";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LoggingAgentAppender() {
        super.setLayout((Layout)new XmlLayout());
        Object object = CURRENT_THREAD_LOCK;
        synchronized (object) {
            ++instanceCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void append(LoggingEvent loggingEvent) {
        if (!this.closed && loggingEvent != null) {
            String formattedLoggingEvent = null;
            try {
                formattedLoggingEvent = this.getLayout().format(loggingEvent);
            }
            catch (Exception e) {
                this.getErrorHandler().error(null, e, 1, loggingEvent);
                return;
            }
            LoggingAgent logger = null;
            String loggerName = loggingEvent.getLoggerName();
            if (loggerName != null && loggerName.trim().length() != 0) {
                Object object = CURRENT_THREAD_LOCK;
                synchronized (object) {
                    if (loggingAgents.containsKey(loggerName)) {
                        logger = (LoggingAgent)loggingAgents.get(loggerName);
                    } else {
                        logger = new LoggingAgent(loggerName);
                        loggingAgents.put(loggerName, logger);
                    }
                    logger.write(formattedLoggingEvent);
                }
            }
            Object object = CURRENT_THREAD_LOCK;
            synchronized (object) {
                if (defaultLoggingAgent == null) {
                    defaultLoggingAgent = new LoggingAgent(DEFAULT_LOGGER_NAME);
                }
                defaultLoggingAgent.write(formattedLoggingEvent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        if (!this.closed) {
            Object object = CURRENT_THREAD_LOCK;
            synchronized (object) {
                Iterator cachedLoggingAgents = loggingAgents.values().iterator();
                while (cachedLoggingAgents.hasNext()) {
                    ((LoggingAgent)cachedLoggingAgents.next()).flush();
                }
                if (defaultLoggingAgent != null) {
                    defaultLoggingAgent.flush();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (!this.closed) {
            this.flush();
            Object object = CURRENT_THREAD_LOCK;
            synchronized (object) {
                if (--instanceCount == 0) {
                    Iterator cachedLoggingAgentNames = loggingAgents.keySet().iterator();
                    while (cachedLoggingAgentNames.hasNext()) {
                        ((LoggingAgent)loggingAgents.remove(cachedLoggingAgentNames.next())).deregister();
                    }
                    if (defaultLoggingAgent != null) {
                        defaultLoggingAgent.deregister();
                    }
                }
            }
            this.closed = true;
        }
    }

    public boolean requiresLayout() {
        return false;
    }

    public void setLayout(Layout layout) {
    }
}

