/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.manual.runner;

import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import org.eclipse.hyades.internal.execution.local.common.CustomCommand;
import org.eclipse.hyades.internal.execution.remote.CustomCommandHandler;
import org.eclipse.hyades.internal.execution.remote.RemoteComponentSkeleton;
import org.eclipse.hyades.test.common.agent.ComptestAgent;
import org.eclipse.hyades.test.common.event.ExecutionEvent;
import org.eclipse.hyades.test.common.event.MessageEvent;
import org.eclipse.hyades.test.common.util.BaseString;
import org.eclipse.hyades.test.manual.runner.RemoteApp;
import org.eclipse.hyades.test.manual.runner.model.util.EventLogger;
import org.eclipse.hyades.test.manual.runner.model.util.ModelUtil;
import org.eclipse.hyades.test.manual.runner.ui.RemoteAppFrame;

public class HyadesManualRunner {
    private boolean isOKToStart = false;
    private ComptestAgent comptestAgent;
    private String testScript;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        Object object;
        final RemoteComponentSkeleton remoteComponentSkeleton = new RemoteComponentSkeleton("Executor$" + stringArray[stringArray.length - 1], "tester");
        final HyadesManualRunner hyadesManualRunner = new HyadesManualRunner(remoteComponentSkeleton);
        remoteComponentSkeleton.addCommandListener(new CustomCommandHandler(){

            public void handleCommand(CustomCommand customCommand) {
                if (customCommand.getData().equals("START")) {
                    hyadesManualRunner.setOKToStart(true);
                } else {
                    hyadesManualRunner.setTestScript(customCommand.getDataBinary());
                }
            }
        });
        try {
            remoteComponentSkeleton.initialize();
        }
        catch (Throwable throwable) {}
        while (!hyadesManualRunner.isOKToStart()) {
            object = hyadesManualRunner;
            synchronized (object) {
                try {
                    hyadesManualRunner.wait(180000L);
                    if (!hyadesManualRunner.isOKToStart()) {
                        remoteComponentSkeleton.sendMessageToAttachedClient("Test was not started after 3 minutes.  Exiting testcase.", 0L);
                        System.exit(-1);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        try {
            if (hyadesManualRunner.getTestScript() == null && stringArray.length > 1) {
                object = new StringBuffer();
                int n = 1;
                int n2 = stringArray.length;
                while (n < n2) {
                    ((StringBuffer)object).append(" ").append(stringArray[n]);
                    ++n;
                }
                hyadesManualRunner.setTestScript(((StringBuffer)object).toString().trim());
            }
            object = stringArray[0] + "(1)";
            System.setOut(new PrintStream(new AgentConsoleStream(remoteComponentSkeleton, 0, (String)object)));
            System.setErr(new PrintStream(new AgentConsoleStream(remoteComponentSkeleton, 1, (String)object)));
            hyadesManualRunner.initializeRemoteApp();
            RemoteAppFrame remoteAppFrame = new RemoteAppFrame(){

                public void doClose(boolean bl) {
                    super.doClose(bl);
                    remoteComponentSkeleton.sendMessageToAttachedClient("Testcase completed successfuly", 0L);
                    hyadesManualRunner.exit();
                    System.exit(0);
                }
            };
            remoteAppFrame.show();
        }
        catch (Throwable throwable) {
            MessageEvent messageEvent = new MessageEvent();
            messageEvent.setText(BaseString.getStackTrace((Throwable)throwable));
            messageEvent.setSeverity(1);
            messageEvent.setOwnerId(stringArray[0]);
            messageEvent.setId("ROOT");
            remoteComponentSkeleton.logMessageUTF8(messageEvent.toString());
        }
    }

    public HyadesManualRunner(RemoteComponentSkeleton remoteComponentSkeleton) {
        this.comptestAgent = new ComptestAgent(remoteComponentSkeleton);
        ModelUtil.setEventLogger(new EventLogger(){

            public void log(ExecutionEvent executionEvent) {
                HyadesManualRunner.this.logEvent(executionEvent);
            }
        });
    }

    public synchronized boolean isOKToStart() {
        return this.isOKToStart;
    }

    protected synchronized void setOKToStart(boolean bl) {
        this.isOKToStart = bl;
        this.notifyAll();
    }

    protected void start() {
        this.comptestAgent.write("<EXECUTION>");
    }

    protected void exit() {
        this.comptestAgent.write("</EXECUTION>");
    }

    protected void logEvent(ExecutionEvent executionEvent) {
        if (this.comptestAgent != null && executionEvent != null) {
            this.comptestAgent.write(executionEvent.toString());
        }
    }

    protected void initializeRemoteApp() throws Exception {
        this.start();
        new RemoteApp().initialize(this.getTestScript());
    }

    protected void setTestScript(byte[] byArray) {
        try {
            this.testScript = new String(byArray, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
    }

    protected void setTestScript(String string) {
        this.testScript = string;
    }

    protected String getTestScript() {
        return this.testScript;
    }

    private static class AgentConsoleStream
    extends OutputStream {
        public static final int OUT = 0;
        public static final int ERR = 1;
        private int mode;
        private RemoteComponentSkeleton agent;
        private String hierarchyId;
        private StringBuffer buffer = new StringBuffer();

        public AgentConsoleStream(RemoteComponentSkeleton remoteComponentSkeleton, int n, String string) {
            this.mode = n;
            this.agent = remoteComponentSkeleton;
            this.hierarchyId = string;
        }

        public void write(int n) {
            this.buffer.append((char)n);
            if (n == 10) {
                MessageEvent messageEvent = new MessageEvent();
                messageEvent.setText(this.buffer.toString());
                messageEvent.setSeverity(0);
                messageEvent.setOwnerId(this.hierarchyId);
                if (this.mode == 0) {
                    messageEvent.setText("System.out:\n" + this.buffer.toString());
                } else if (this.mode == 1) {
                    messageEvent.setText("System.err:\n" + this.buffer.toString());
                }
                this.agent.logMessageUTF8(messageEvent.toString());
                this.buffer = new StringBuffer();
            }
        }
    }
}

