/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.execution.recorder.http.remote;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import org.eclipse.hyades.execution.recorder.http.remote.ConnectionObj;
import org.eclipse.hyades.execution.recorder.http.remote.HttpRecResourceBundle;
import org.eclipse.hyades.execution.recorder.http.remote.PacketWriter;
import org.eclipse.hyades.execution.recorder.http.remote.PeekSocket;
import org.eclipse.hyades.execution.recorder.http.remote.ServerSideReader;

public abstract class ClientSideReader
extends Thread {
    public static final String ERROR_SSL_REQUEST_MADE = "-1";
    public static final String ERROR_NO_TESTKEYS = "-2";
    static final String STR_KEEP_ALIVE = "Proxy-Connection: Keep-Alive\r\n";
    static int iConn = 0;
    static final String ClientSideReaderException = HttpRecResourceBundle.getInstance().getString("RECORDER_CLIENTSIDE_READER_EXCEPTION");
    String defaultCipherSuite = "SSL_RSA_WITH_RC4_128_MD5";
    String defaultProtocol = "TLSv1";
    InputStream from_client;
    OutputStream to_client;
    InputStream from_server;
    OutputStream to_server;
    PeekSocket client = null;
    Socket httpServer = null;
    Socket httpSSLServer = null;
    ServerSideReader serverReader = null;
    boolean bSecure = false;
    boolean bNoPrintToServer = false;
    PacketWriter packetWriter = null;
    boolean secureConnectionOK = false;
    String destServer = null;
    String keyFile = null;
    int serverPort = 80;
    int iConnection = 0;
    ConnectionObj connectionNumber = new ConnectionObj();
    static int isSSLClassAvailable = -1;
    static boolean foundTestKeys = false;
    String sslCipherSuite = "";
    String sslProtocol = "";
    InetAddress newAddr = null;
    int destPort = 0;

    ClientSideReader(PeekSocket peekSocket, PacketWriter packetWriter) {
        this(peekSocket, packetWriter, "C:\\testkeys");
    }

    ClientSideReader(PeekSocket peekSocket, PacketWriter packetWriter, String string) {
        try {
            this.from_client = peekSocket.getInputStream();
            this.to_client = peekSocket.getOutputStream();
            this.client = peekSocket;
            this.iConnection = ClientSideReader.getNextConnection();
            this.connectionNumber.setConnectionNumber(this.iConnection);
            this.packetWriter = packetWriter;
            this.keyFile = string;
            packetWriter.writeRecorderMessage(1, "Client Connected, connection " + this.iConnection);
            packetWriter.writeConnectConnectionInfo(this.iConnection);
        }
        catch (Exception exception) {
            packetWriter.writeRecorderMessage(2, "exception in ClientSideReader: " + exception);
            packetWriter.getAgentController().reportException(ClientSideReaderException, (Throwable)exception);
        }
    }

    ClientSideReader() {
    }

    static synchronized int getNextConnection() {
        return ++iConn;
    }

    public abstract void run();

    private static String IP4ByteToString(byte[] byArray) {
        String string = "";
        int n = 0;
        while (n < 4) {
            string = byArray[n] >= 0 ? string + String.valueOf(byArray[n]) : string + String.valueOf(256 + byArray[n]);
            if (n < 3) {
                string = string + ".";
            }
            ++n;
        }
        return string;
    }

    public int findSSLClass() {
        int n = -1;
        try {
            Class<?> clazz = Class.forName("javax.net.ssl.SSLSocket");
            n = 1;
        }
        catch (ClassNotFoundException classNotFoundException) {
            n = 0;
        }
        return n;
    }

    public boolean checkForTestKeys() {
        if (this.keyFile == null || this.keyFile.length() == 0) {
            this.keyFile = "C:\\testkeys";
        }
        boolean bl = false;
        File file = new File(this.keyFile);
        bl = file.exists();
        return bl;
    }
}

