/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.internal.execution.local.common;

import java.net.InetAddress;
import org.eclipse.hyades.internal.execution.local.common.BinaryCustomCommand;
import org.eclipse.hyades.internal.execution.local.common.CommandElement;
import org.eclipse.hyades.internal.execution.local.common.Constants;
import org.eclipse.hyades.internal.execution.local.common.DataProcessor;
import org.eclipse.hyades.internal.execution.local.common.DataServerListener;
import org.eclipse.hyades.internal.execution.local.common.Message;
import org.eclipse.hyades.internal.execution.local.control.Agent;
import org.eclipse.hyades.internal.execution.local.control.AgentListener;
import org.eclipse.hyades.internal.execution.local.control.InactiveProcessException;

public class MultiplexedDataServer
implements AgentListener,
Constants {
    private DataProcessor _processor;
    private long magicNumber = -17973026L;
    private long terminationCode = -559038242L;
    private InetAddress inetaddr = null;
    private byte[] _messageHeader = new byte[10];
    private long _currentBufferSize = 8096L;
    private short _currentFlusherBuffer = 0;
    private int _currentHeaderOffset = 0;
    private int _bytesWritten = 0;
    public static final byte BINARY_DATA = 0;
    public static final byte UTF8_STRING_DATA = 1;
    public static final byte UNICODE_STRING_DATA = 2;

    public void startServer(DataProcessor processor) throws Exception {
        this._processor = processor;
    }

    public boolean isProcessing() {
        return true;
    }

    public void stopServer() {
    }

    public void resumeServer() {
    }

    public void resumeServer(DataProcessor processor) {
    }

    public void shutdownServer() {
        this._processor = null;
    }

    public void incommingData(byte[] b, InetAddress peer) {
        this._processor.incommingData(b, b.length, peer);
    }

    public void incommingData(char[] c, InetAddress peer) {
        this._processor.incommingData(c, c.length, peer);
    }

    public void agentActive(Agent agent) {
        try {
            this.inetaddr = agent.getProcess().getNode().getInetAddress();
        }
        catch (InactiveProcessException e) {}
    }

    public void agentInactive(Agent agent) {
    }

    public void error(Agent agent, String errorId, String errorMessage) {
    }

    public void handleCommand(Agent agent, CommandElement command) {
        switch ((int)command.getTag()) {
            case 29: {
                BinaryCustomCommand binaryCustomCommand = (BinaryCustomCommand)command;
                byte[] binaryData = binaryCustomCommand.getDataBinary();
                int binaryDataLength = binaryData.length;
                if (binaryDataLength < 4) break;
                long code = Message.readRALongFromBuffer(binaryData, 0);
                if (code == this.magicNumber) {
                    byte[] b = new byte[binaryDataLength - 4];
                    System.arraycopy(binaryData, 4, b, 0, binaryDataLength - 4);
                    this.processData(b, 0, b.length, this.inetaddr);
                    break;
                }
                if (code != this.terminationCode || !(this._processor instanceof DataServerListener)) break;
                ((DataServerListener)this._processor).dataServerExited();
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    protected int processData(byte[] data, int offset, int limit, InetAddress addr) {
        _binaryForwardBuffer = new byte[8096];
        _stringForwardBuffer = new char[8096];
        current = offset;
        if (offset >= limit) {
            return limit;
        }
        if (this._currentHeaderOffset < 10) {
            if ((current = this.loadMessageHeader(data, current, limit)) == limit) {
                return current;
            }
            if (this.getMessageLength() >= this._currentBufferSize) {
                type = this.getMessageType();
                if (type == 0 || type == 1) {
                    replacement = new byte[(int)this.getMessageLength()];
                    System.arraycopy(data, current, replacement, 0, limit - current);
                    this._bytesWritten = limit - current;
                    _binaryForwardBuffer = replacement;
                } else {
                    replacement = new char[(int)this.getMessageLength()];
                    i = 0;
                    while (i < limit - current + 1) {
                        replacement[i] = (char)data[i + current];
                        ++i;
                    }
                    this._bytesWritten = limit - current;
                    _stringForwardBuffer = replacement;
                }
                return limit;
            }
        }
        if (!this.checkMessageMagic()) {
            System.out.println("Corrupt data");
            this._currentHeaderOffset = 0;
            return this.processData(data, offset + 1, limit, addr);
        }
        messageLength = this.getMessageLength();
        type = this.getMessageType();
        while (current < limit) {
            if (type == 0 || type == 1) {
                while (current < limit && (long)this._bytesWritten < messageLength) {
                    _binaryForwardBuffer[this._bytesWritten++] = data[current++];
                }
                if ((long)this._bytesWritten != messageLength) continue;
                this._processor.incommingData(_binaryForwardBuffer, this._bytesWritten, addr);
                this._bytesWritten = 0;
                this._currentHeaderOffset = 0;
                current = this.processData(data, current, limit, addr);
                continue;
            }
            if (type != 2) ** GOTO lbl55
            while (offset < limit && (long)this._bytesWritten < messageLength) {
                _stringForwardBuffer[this._bytesWritten >> 1] = (char)((char)data[current++] | (char)(data[current++] << 8));
                this._bytesWritten += 2;
            }
            if ((long)this._bytesWritten != messageLength) continue;
            this._processor.incommingData(_stringForwardBuffer, this._bytesWritten, addr);
            this._bytesWritten = 0;
            this._currentHeaderOffset = 0;
            current = this.processData(data, current, limit, addr);
            continue;
lbl-1000:
            // 1 sources

            {
                _binaryForwardBuffer[this._bytesWritten++] = data[current++];
lbl55:
                // 2 sources

                ** while (offset < limit && (long)this._bytesWritten < messageLength)
            }
lbl56:
            // 1 sources

            if ((long)this._bytesWritten != messageLength) continue;
            this._processor.incommingData(_binaryForwardBuffer, this._bytesWritten, addr);
            this._bytesWritten = 0;
            this._currentHeaderOffset = 0;
            current = this.processData(data, current, limit, addr);
        }
        return current;
    }

    protected int loadMessageHeader(byte[] data, int offset, int limit) {
        while (offset < limit && this._currentHeaderOffset < 10) {
            this._messageHeader[this._currentHeaderOffset++] = data[offset++];
        }
        return offset;
    }

    protected long getMessageLength() {
        return Message.readRALongFromBuffer(this._messageHeader, 5);
    }

    protected byte getMessageType() {
        return this._messageHeader[9];
    }

    protected boolean checkMessageMagic() {
        long messageKey = (long)(this._messageHeader[0] << 24 & 0xFF000000) | (long)(this._messageHeader[1] << 16 & 0xFF0000) | (long)this._messageHeader[2] << 8 & 0xFF00L | (long)this._messageHeader[3];
        return true;
    }
}

