/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.models.hierarchy.util.internal;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.hyades.models.hierarchy.extensions.BinaryExpression;
import org.eclipse.hyades.models.hierarchy.extensions.ExtensionsFactory;
import org.eclipse.hyades.models.hierarchy.extensions.LogicalExpression;
import org.eclipse.hyades.models.hierarchy.extensions.LogicalOperators;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery;
import org.eclipse.hyades.models.hierarchy.extensions.WhereExpression;
import org.eclipse.hyades.models.hierarchy.util.internal.SimpleSearchQueryEngine;

public class ImportFilterEngine
extends SimpleSearchQueryEngine {
    protected Map includeIdsByFeatureIndex = new HashMap();
    protected Map excludeIdsByFeatureIndex = new HashMap();
    protected SimpleSearchQueryEngine.EvalResult evalResult;

    public ImportFilterEngine(SimpleSearchQuery query, ResourceSet targetResourceSet) {
        super(ImportFilterEngine.convertQuery(query), targetResourceSet);
    }

    private static SimpleSearchQuery convertQuery(SimpleSearchQuery query) {
        WhereExpression expression = query.getWhereExpression();
        if (expression instanceof LogicalExpression) {
            LogicalExpression orLogicalExpression = ExtensionsFactory.eINSTANCE.createLogicalExpression();
            orLogicalExpression.setOperator(LogicalOperators.OR_LITERAL);
            HashSet<EObject> be = new HashSet<EObject>();
            TreeIterator iter = ((LogicalExpression)expression).eAllContents();
            while (iter.hasNext()) {
                EObject element = (EObject)iter.next();
                if (!(element instanceof BinaryExpression)) continue;
                be.add(element);
            }
            Iterator iter2 = be.iterator();
            while (iter2.hasNext()) {
                BinaryExpression element = (BinaryExpression)iter2.next();
                orLogicalExpression.getArguments().add((Object)element);
            }
            query.setWhereExpression(orLogicalExpression);
        }
        return query;
    }

    public boolean isFiltered(EStructuralFeature sf, Object id, Object value) {
        if (this.query == null) {
            return false;
        }
        if (value != null) {
            return this.evaluateAndUpdateIndexes(sf, id, value);
        }
        return this.internalIsFiltered(sf, id);
    }

    protected boolean internalIsFiltered(EStructuralFeature sf, Object id) {
        Set ids = (Set)this.includeIdsByFeatureIndex.get(sf);
        return ids == null || !ids.contains(id);
    }

    protected boolean evaluateAndUpdateIndexes(EStructuralFeature sf, Object id, Object value) {
        if (this.evaluate(sf, id, value)) {
            HashSet<Object> ids = (HashSet<Object>)this.includeIdsByFeatureIndex.get(sf);
            if (ids == null) {
                ids = new HashSet<Object>();
                this.includeIdsByFeatureIndex.put(sf, ids);
            }
            ids.add(id);
            return false;
        }
        return true;
    }

    protected boolean evaluate(EStructuralFeature sf, Object id, Object value) {
        this.evalResult.evalOnly(sf, value);
        if (this.evalResult.isComplete() && this.evalResult.booleanValue.booleanValue()) {
            this.evalResult.resetOnly(sf);
            return true;
        }
        this.evalResult.resetOnly(sf);
        return false;
    }

    public boolean isFiltered(EStructuralFeature sf, Object id) {
        if (this.query == null) {
            return false;
        }
        return this.internalIsFiltered(sf, id);
    }

    public void init() {
        this.prepareResult();
        this.populateRootNodesAndClasses();
        this.buildRequiredTraversalPaths();
        this.indexWhereExpression();
        this.prepareEvalResult();
    }

    protected void prepareEvalResult() {
        SimpleSearchQueryEngine.SimpleSearchQueryEvaluator queryEvaluator = new SimpleSearchQueryEngine.SimpleSearchQueryEvaluator(this);
        this.evalResult = queryEvaluator.prepareEvalResult();
    }
}

