/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.internal.filters;

import org.eclipse.hyades.logging.adapter.internal.filters.IFilterAtom;
import org.eclipse.hyades.logging.adapter.internal.filters.IFilterType;

public class NumericalRangeFilterType
implements IFilterType {
    public static final String LAST = "last";
    public static final String FIRST = "first";
    private static final String[] operands = new String[]{"first", "last"};

    public String[] getOperators() {
        return operands;
    }

    public boolean processRule(IFilterAtom rule) {
        boolean result = rule.isNegated();
        if (rule.getOperator().equals(FIRST)) {
            result = this.first(rule.getLeftOperand(), rule.getRightOperand());
        } else if (rule.getOperator().equals(LAST)) {
            result = this.last(rule.getLeftOperand(), rule.getRightOperand());
        }
        if (rule.isNegated()) {
            return !result;
        }
        return result;
    }

    protected boolean last(String lhs, String rhs) {
        return true;
    }

    protected boolean first(String lhs, String rhs) {
        if (lhs == null || rhs == null) {
            return false;
        }
        try {
            int lnum = Integer.parseInt(lhs);
            int rnum = Integer.parseInt(rhs);
            return lnum <= rnum;
        }
        catch (NumberFormatException e) {
            try {
                float lnum = Float.parseFloat(lhs);
                float rnum = Float.parseFloat(rhs);
                return lnum <= rnum;
            }
            catch (NumberFormatException e2) {
                try {
                    double lnum = Double.parseDouble(lhs);
                    double rnum = Double.parseDouble(rhs);
                    return lnum <= rnum;
                }
                catch (NumberFormatException e3) {
                    return false;
                }
            }
        }
    }
}

