/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.internal.filters;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.hyades.logging.adapter.internal.filters.NumericalFilterType;

public class TimeFilterType
extends NumericalFilterType {
    private static SimpleDateFormat formatter1 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.S Z");
    private static SimpleDateFormat formatter2 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.S");
    private static SimpleDateFormat formatter3 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss Z");
    private static SimpleDateFormat formatter4 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    private static Pattern tzPattern = Pattern.compile("(.*)([-,+]\\d{2}:\\d{2})");

    protected boolean equals(String lhs, String rhs) {
        if (lhs == null && rhs == null) {
            return true;
        }
        if (lhs == null || rhs == null) {
            return false;
        }
        try {
            Date ldt = this.getDate(lhs);
            Date rdt = this.getDate(rhs);
            return ldt.equals(rdt);
        }
        catch (ParseException e) {
            return false;
        }
    }

    protected boolean greaterThan(String lhs, String rhs) {
        if (lhs == null || rhs == null) {
            return false;
        }
        try {
            Date ldt = this.getDate(lhs);
            Date rdt = this.getDate(rhs);
            return ldt.after(rdt);
        }
        catch (ParseException e) {
            return false;
        }
    }

    protected boolean lessThan(String lhs, String rhs) {
        if (lhs == null || rhs == null) {
            return false;
        }
        try {
            Date ldt = this.getDate(lhs);
            Date rdt = this.getDate(rhs);
            return ldt.before(rdt);
        }
        catch (ParseException e) {
            return false;
        }
    }

    private Date getDate(String timestr) throws ParseException {
        Date dt;
        if (timestr.endsWith("Z")) {
            timestr = timestr.substring(0, timestr.length() - 1) + " GMT";
        } else {
            Matcher matcher = tzPattern.matcher(timestr);
            if (matcher.find()) {
                timestr = matcher.replaceAll("$1 GMT$2");
            }
        }
        try {
            dt = formatter1.parse(timestr);
        }
        catch (ParseException e) {
            try {
                dt = formatter2.parse(timestr);
            }
            catch (ParseException e2) {
                try {
                    dt = formatter3.parse(timestr);
                }
                catch (ParseException e3) {
                    dt = formatter4.parse(timestr);
                }
            }
        }
        return dt;
    }
}

