/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.collection.framework.channel;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.InetAddress;
import org.eclipse.hyades.execution.core.DataChannelConnectionException;
import org.eclipse.hyades.execution.core.DataChannelCreationException;
import org.eclipse.hyades.execution.core.DataChannelNotInitializedException;
import org.eclipse.hyades.execution.core.IDataChannel;
import org.eclipse.hyades.execution.core.InvalidDataChannelAccessException;

public class DataChannelImpl
implements IDataChannel {
    private static boolean _nativesAvailable = false;
    protected boolean _isFlushing = false;
    protected boolean _isWriting = false;
    private boolean _isDCBufferCreated = false;
    private static String DC_BUFFER_NAME_ROOT = "hcbuffer";
    private static int _dc_buffer_num = 0;
    private static int DC_DEFAULT_BUFFER_SIZE = 0x100000;
    private static final int INPUT_BUFFER_SIZE = 8096;
    protected static final int FLUSH_TYPE_PIPED_OUTPUT_STREAM = 6;
    protected static final int FLUSH_TYPE_OUTPUT_STREAM = 5;
    protected static final int FLUSH_TYPE_BINARY_FILE = 4;
    protected static final int FLUSH_TYPE_ASCII_FILE = 3;
    protected static final int FLUSH_TYPE_RAC_FILE = 2;
    protected static final int FLUSH_TYPE_SOCKET = 1;
    protected static int DC_TYPE_FLUSHABLE = 1;
    protected static int DC_TYPE_FILLABLE = 2;
    private String _dc_buffer_name = null;
    private int _dc_buffer_handle = -1;
    private int _dc_type = 0;
    private int _dc_flushType = 0;
    protected OutputStream _dc_outputStream;
    private PipedOutputStream _dc_POutputStream;
    private InputStream _dc_inputStream;
    private PipedInputStream _dc_PInputStream;
    private int _dc_buffer_size = 0;
    private String _file_name;
    private InetAddress _client_address;
    private int _client_port;

    private synchronized int incrementDCBufferNum() {
        int n = _dc_buffer_num++;
        return n;
    }

    public void create() throws DataChannelCreationException {
        int n;
        if (this.getName() == null) {
            this.setName(DC_BUFFER_NAME_ROOT + String.valueOf(this.incrementDCBufferNum()));
        }
        if (this.getSize() == 0) {
            this.setSize(DC_DEFAULT_BUFFER_SIZE);
        }
        if ((n = this.hc_createDCBuffer(this.getName(), this.getSize())) < 0) {
            if (n == -518) {
                throw new DataChannelCreationException("Data Channel with name " + this.getName() + " already exists");
            }
            if (n == -99) {
                throw new DataChannelCreationException("Could not allocate memory");
            }
            if (n == -504) {
                throw new DataChannelCreationException("Data Channel size " + this.getSize() + " is invalid");
            }
            if (n == -505) {
                throw new DataChannelCreationException("Data Channel name " + this.getName() + " is invalid");
            }
            if (n < -500) {
                throw new DataChannelCreationException("Implementation failure code: " + n);
            }
            throw new DataChannelCreationException();
        }
        this.setHandle(n);
        this._isDCBufferCreated = true;
    }

    public void destroy() {
        if (this.isDCBufferCreated()) {
            this.hc_destroyDCBuffer(this.getHandle());
        }
    }

    public void connect() throws DataChannelConnectionException {
        if (this.getName() == null) {
            throw new DataChannelConnectionException("No name has been set");
        }
        int n = this.hc_attachToDCBuffer(this.getName());
        if (n < 0) {
            if (n == -3) {
                throw new DataChannelConnectionException("Data Channel with name " + this.getName() + " does not exist");
            }
            if (n == -99) {
                throw new DataChannelConnectionException("Could not allocate memory");
            }
            if (n == -505) {
                throw new DataChannelConnectionException("Data Channel name " + this.getName() + " is invalid");
            }
            if (n < -500) {
                throw new DataChannelConnectionException("Implementation failure code: " + n);
            }
            throw new DataChannelConnectionException();
        }
        this.setHandle(n);
        this._isDCBufferCreated = true;
    }

    public void disconnect() {
        this.stopFlushing();
        this.hc_detachFromDCBuffer(this.getHandle());
    }

    public void write(byte[] byArray) throws IOException, InvalidDataChannelAccessException {
        if (!this.isFillable()) {
            throw new InvalidDataChannelAccessException();
        }
        if (!this.isDCBufferCreated()) {
            throw new InvalidDataChannelAccessException();
        }
        int n = this.hc_writeToDCBuffer(this.getHandle(), byArray, byArray.length);
        if (n < 0) {
            throw new IOException();
        }
    }

    public void setOutputStream(OutputStream outputStream) throws InvalidDataChannelAccessException, DataChannelNotInitializedException {
        if (!this.isFlushable()) {
            throw new InvalidDataChannelAccessException();
        }
        if (!this.isDCBufferCreated()) {
            throw new DataChannelNotInitializedException();
        }
        this.startFlushingToStream(outputStream);
    }

    protected PipedOutputStream getPOutputStream() {
        return this._dc_POutputStream;
    }

    public OutputStream getOutputStream() throws InvalidDataChannelAccessException, DataChannelNotInitializedException {
        if (!this.isFillable()) {
            throw new InvalidDataChannelAccessException();
        }
        if (this.isDCBufferCreated()) {
            PipedInputStream pipedInputStream = new PipedInputStream();
            this.setPInputStream(pipedInputStream);
            try {
                this._dc_outputStream = new PipedOutputStream(pipedInputStream);
                WriterThread writerThread = new WriterThread();
                writerThread.start();
                while (!this._isWriting) {
                    Thread.sleep(500L);
                }
            }
            catch (InterruptedException interruptedException) {
                System.out.println("Thread was interrupted before writer thread stopped");
            }
            catch (IOException iOException) {
                System.out.println("IOException trying to create PipedOutputStream");
            }
        } else {
            throw new DataChannelNotInitializedException();
        }
        return this._dc_outputStream;
    }

    public void setInputStream(InputStream inputStream) throws InvalidDataChannelAccessException, DataChannelNotInitializedException {
        if (!this.isFillable()) {
            throw new InvalidDataChannelAccessException();
        }
        if (this.isDCBufferCreated()) {
            this._dc_inputStream = inputStream;
            WriterThread writerThread = new WriterThread();
            try {
                writerThread.start();
                writerThread.join();
            }
            catch (InterruptedException interruptedException) {
                System.out.println("Thread was interrupted before writer thread stopped");
            }
        } else {
            throw new DataChannelNotInitializedException();
        }
    }

    protected InputStream getPInputStream() {
        if (this._dc_PInputStream == null) {
            return this._dc_inputStream;
        }
        return this._dc_PInputStream;
    }

    public InputStream getInputStream() throws InvalidDataChannelAccessException, DataChannelNotInitializedException {
        if (!this.isFlushable()) {
            throw new InvalidDataChannelAccessException();
        }
        if (this.isDCBufferCreated()) {
            PipedOutputStream pipedOutputStream = new PipedOutputStream();
            this.setPOutputStream(pipedOutputStream);
            try {
                this._dc_inputStream = new PipedInputStream(pipedOutputStream);
                this.startFlushingToStream(pipedOutputStream);
            }
            catch (IOException iOException) {
                System.out.println("IOException trying to create PipedOutputStream");
            }
        } else {
            throw new DataChannelNotInitializedException();
        }
        return this._dc_inputStream;
    }

    public void startFlushingToFile(String string) {
        block2: {
            this.setFlushType(2);
            this.setFileName(string);
            if (!this.isDCBufferCreated() || this.isFlushing() || !this.isFlushable()) break block2;
            FlusherThread flusherThread = new FlusherThread();
            try {
                flusherThread.start();
                flusherThread.join();
            }
            catch (InterruptedException interruptedException) {
                System.out.println("Thread was interrupted before flusher thread stopped");
            }
        }
    }

    public void startFlushingToSocket(InetAddress inetAddress, int n) {
        block2: {
            this.setFlushType(1);
            this.setInetAddress(inetAddress);
            this.setPort(n);
            if (!this.isDCBufferCreated() || this.isFlushing() || !this.isFlushable()) break block2;
            FlusherThread flusherThread = new FlusherThread();
            try {
                flusherThread.start();
                flusherThread.join();
            }
            catch (InterruptedException interruptedException) {
                System.out.println("Thread was interrupted before flusher thread stopped");
            }
        }
    }

    public void startFlushingToStream(PipedOutputStream pipedOutputStream) {
        block3: {
            if (!this.isDCBufferCreated() || this.isFlushing() || !this.isFlushable()) break block3;
            this.setFlushType(6);
            this.setPOutputStream(pipedOutputStream);
            FlusherThread flusherThread = new FlusherThread();
            try {
                flusherThread.start();
                while (!this.isFlushing()) {
                    Thread.sleep(500L);
                }
            }
            catch (InterruptedException interruptedException) {
                System.out.println("Thread was interrupted before flusher thread stopped");
            }
        }
    }

    public void startFlushingToStream(OutputStream outputStream) {
        block2: {
            if (!this.isDCBufferCreated() || this.isFlushing() || !this.isFlushable()) break block2;
            this.setFlushType(5);
            this._dc_outputStream = outputStream;
            FlusherThread flusherThread = new FlusherThread();
            try {
                flusherThread.start();
                flusherThread.join();
            }
            catch (InterruptedException interruptedException) {
                System.out.println("Thread was interrupted before flusher thread stopped");
            }
        }
    }

    public void stopFlushing() {
        int n;
        if (!this.isDCBufferCreated() || (n = this.hc_stopFlushingDCBuffer(this.getHandle())) != 0) {
            // empty if block
        }
    }

    public void setFlushable() throws InvalidDataChannelAccessException {
        if (this.isFillable()) {
            throw new InvalidDataChannelAccessException();
        }
        this._dc_type = DC_TYPE_FLUSHABLE;
    }

    public boolean isFlushable() {
        return this._dc_type == DC_TYPE_FLUSHABLE;
    }

    public void setFillable() throws InvalidDataChannelAccessException {
        if (this.isFlushable()) {
            throw new InvalidDataChannelAccessException();
        }
        this._dc_type = DC_TYPE_FILLABLE;
    }

    public boolean isFillable() {
        return this._dc_type == DC_TYPE_FILLABLE;
    }

    protected native void hc_destroyDCBuffer(int var1);

    protected native void hc_detachFromDCBuffer(int var1);

    private native int hc_validateDCBufferSize(int var1);

    private native int hc_createDCBuffer(String var1, int var2);

    private native int hc_attachToDCBuffer(String var1);

    private native int hc_stopFlushingDCBuffer(int var1);

    protected native int hc_flushRACDCBufferToFile(int var1, String var2);

    protected native int hc_flushASCIIDCBufferToFile(int var1, String var2);

    protected native int hc_flushBinaryDCBufferToFile(int var1, String var2);

    protected native int hc_flushDCBufferToSocket(int var1, byte[] var2, int var3);

    protected native int hc_flushDCBufferToStream(int var1, OutputStream var2);

    protected native int hc_writeToDCBuffer(int var1, byte[] var2, int var3);

    public String getName() {
        return this._dc_buffer_name;
    }

    public int getFlushType() {
        return this._dc_flushType;
    }

    public int getSize() {
        return this._dc_buffer_size;
    }

    public int getHandle() {
        return this._dc_buffer_handle;
    }

    public String getFileName() {
        return this._file_name;
    }

    public InetAddress getInetAddress() {
        return this._client_address;
    }

    public int getPort() {
        return this._client_port;
    }

    public boolean isFlushing() {
        return this._isFlushing;
    }

    public boolean isDCBufferCreated() {
        return this._isDCBufferCreated;
    }

    public void setName(String string) {
        this._dc_buffer_name = new String(string);
    }

    private void setPInputStream(PipedInputStream pipedInputStream) {
        this._dc_PInputStream = pipedInputStream;
    }

    private void setPOutputStream(PipedOutputStream pipedOutputStream) {
        this._dc_POutputStream = pipedOutputStream;
    }

    private void setFlushType(int n) {
        this._dc_flushType = n;
    }

    public void setSize(int n) {
        this._dc_buffer_size = this.hc_validateDCBufferSize(n);
    }

    private void setHandle(int n) {
        this._dc_buffer_handle = n;
    }

    private void setFileName(String string) {
        this._file_name = new String(string);
    }

    private void setInetAddress(InetAddress inetAddress) {
        this._client_address = inetAddress;
    }

    private void setPort(int n) {
        this._client_port = n;
    }

    static {
        try {
            System.loadLibrary("hcclsm");
            _nativesAvailable = true;
        }
        catch (Throwable throwable) {
            System.out.println("Can't find hcclsm library.\n");
            _nativesAvailable = false;
        }
    }

    class FlusherThread
    extends Thread {
        FlusherThread() {
        }

        public void run() {
            int n = -1;
            if (DataChannelImpl.this.isDCBufferCreated() && !DataChannelImpl.this.isFlushing()) {
                DataChannelImpl.this._isFlushing = true;
                switch (DataChannelImpl.this.getFlushType()) {
                    case 2: {
                        n = DataChannelImpl.this.hc_flushRACDCBufferToFile(DataChannelImpl.this.getHandle(), DataChannelImpl.this.getFileName());
                        break;
                    }
                    case 3: {
                        n = DataChannelImpl.this.hc_flushASCIIDCBufferToFile(DataChannelImpl.this.getHandle(), DataChannelImpl.this.getFileName());
                        break;
                    }
                    case 4: {
                        n = DataChannelImpl.this.hc_flushBinaryDCBufferToFile(DataChannelImpl.this.getHandle(), DataChannelImpl.this.getFileName());
                        break;
                    }
                    case 1: {
                        n = DataChannelImpl.this.hc_flushDCBufferToSocket(DataChannelImpl.this.getHandle(), DataChannelImpl.this.getInetAddress().getAddress(), DataChannelImpl.this.getPort());
                        break;
                    }
                    case 5: {
                        n = DataChannelImpl.this.hc_flushDCBufferToStream(DataChannelImpl.this.getHandle(), DataChannelImpl.this._dc_outputStream);
                        break;
                    }
                    case 6: {
                        n = DataChannelImpl.this.hc_flushDCBufferToStream(DataChannelImpl.this.getHandle(), DataChannelImpl.this.getPOutputStream());
                        try {
                            DataChannelImpl.this.getPOutputStream().close();
                        }
                        catch (IOException iOException) {
                            System.out.println("Could not close piped output stream");
                        }
                        break;
                    }
                }
                DataChannelImpl.this._isFlushing = false;
                if (n != 0) {
                    return;
                }
                DataChannelImpl.this.hc_destroyDCBuffer(DataChannelImpl.this.getHandle());
            }
        }
    }

    class WriterThread
    extends Thread {
        WriterThread() {
        }

        public void run() {
            byte[] byArray = new byte[8096];
            int n = 0;
            DataChannelImpl.this._isWriting = true;
            try {
                while (true) {
                    if ((n = DataChannelImpl.this.getPInputStream().read(byArray)) > 0) {
                        int n2 = DataChannelImpl.this.hc_writeToDCBuffer(DataChannelImpl.this.getHandle(), byArray, n);
                        if (n2 == 0) continue;
                        System.out.println("Error " + n2 + " writing to DataChannel " + n + " bytes");
                        DataChannelImpl.this._isWriting = false;
                        return;
                    }
                    if (n < 0) break;
                }
                DataChannelImpl.this._isWriting = false;
                return;
            }
            catch (IOException iOException) {
                DataChannelImpl.this._isWriting = false;
                return;
            }
        }
    }
}

