@rem USAGE:  runregex_example.bat
@rem PURPOSE:  Illustrates the functional capabilities of the Generic Log Adapter (GLA)
@rem           run-time using an example adapter file and sample log file.
@rem ASSUMPTIONS:  This batch file assumes the GLA run-time and required files are 
@rem               stored in the following directory structure:
@rem      %GLA_HOME%\config - GLA adapter configuration files
@rem      %GLA_HOME%\lib    - GLA run-time and required jars
@rem      %GLA_HOME%\schema - GLA adapter configuration schema files
@rem INSTRUCTIONS:  
@rem     If the GLA run-time and required files are stored as indicated in the 
@rem         assumptions section above, change the value of the %GLA_HOME% 
@rem         environment variable to the absolute path where the GLA run-time 
@rem         and required files are stored.
@rem     If the GLA run-time files are stored in a plug-in (e.g. Eclipse) 
@rem         environment, perform the following instructions:
@rem        1) Create a temporary directory to store the GLA run-time and required files.  
@rem        2) Create the config, lib, and schema directories in the temporary 
@rem           directory creatd in step 1)
@rem        3) Change the value of the %GLA_HOME% environment variable to the 
@rem           absolute path of the temporary directory created in step 1)
@rem        4) Copy the Windows directory of the org.eclipse.hyades.logging.adapter.config 
@rem           plug-in and all of its contents to the %GLA_HOME%\config directory.  
@rem        5) Copy the contents of the schema directory of 
@rem           org.eclipse.hyades.logging.adapter plug-in to the %GLA_HOME%\schema directory.
@rem        6) Copy the following jar files to the %GLA_HOME%\lib directory
@rem                    Plug-in                 |     JAR
@rem        ---------------------------------------------------
@rem        org.eclipse.hyades.logging.adapter  |  hgla.jar
@rem        org.eclipse.hyades.logging.core     |  hlcbe101.jar
@rem        org.eclipse.hyades.logging.core     |  hlcore.jar
@rem        org.eclipse.hyades.execution.remote |  hexr.jar
@rem        org.eclipse.emf.ecore               |  ecore.jar
@rem        org.eclipse.emf.common              |  common.jar

SET GLA_HOME=d:\GenericLogAdapter
SET CONFIG_FILE=%GLA_HOME%\config\Windows\security\regex_example.adapter
PUSHD %GLA_HOME%\config\Windows\security
java -DGLA_HOME="%GLA_HOME%" -classpath "%GLA_HOME%\lib\hgla.jar;%GLA_HOME%\lib\hexr.jar;%GLA_HOME%\lib\hlcbe101.jar;%GLA_HOME%\lib\ecore.jar;%GLA_HOME%\lib\common.jar;%GLA_HOME%\lib\hlcore.jar" org.eclipse.hyades.logging.adapter.Adapter -ac "%CONFIG_FILE%" -cc "%CONFIG_FILE%"
POPD
