/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.models.hierarchy.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.URIConverterImpl;

public class HierarchyURIConverterImpl
extends URIConverterImpl {
    protected static IWorkspaceRoot workspaceRoot = EcorePlugin.getWorkspaceRoot();
    protected URIMap uriMap;

    public Map getURIMap() {
        return this.getInternalURIMap();
    }

    public InputStream createInputStream(URI uri) throws IOException {
        URI converted = this.normalize(uri);
        String scheme = converted.scheme();
        if ("file".equals(scheme)) {
            String filePath = converted.toFileString();
            return this.createFileInputStream(filePath);
        }
        if ("platform".equals(scheme) && converted.segmentCount() > 1 && "resource".equals(converted.segment(0))) {
            StringBuffer platformResourcePath = new StringBuffer();
            int i = 1;
            int size = converted.segmentCount();
            while (i < size) {
                platformResourcePath.append('/');
                platformResourcePath.append(converted.segment(i));
                ++i;
            }
            return this.createPlatformResourceInputStream(platformResourcePath.toString());
        }
        if (scheme == null) {
            String filePath = converted.toString();
            return this.createFileInputStream(filePath);
        }
        return this.createURLInputStream(converted);
    }

    public OutputStream createOutputStream(URI uri) throws IOException {
        URI converted = this.normalize(uri);
        String scheme = converted.scheme();
        if ("file".equals(scheme)) {
            String filePath = converted.toFileString();
            return this.createFileOutputStream(filePath);
        }
        if ("platform".equals(scheme) && converted.segmentCount() > 1 && "resource".equals(converted.segment(0))) {
            StringBuffer platformResourcePath = new StringBuffer();
            int i = 1;
            int size = converted.segmentCount();
            while (i < size) {
                platformResourcePath.append('/');
                platformResourcePath.append(converted.segment(i));
                ++i;
            }
            return this.createPlatformResourceOutputStream(platformResourcePath.toString());
        }
        if (scheme == null) {
            String filePath = converted.toString();
            return this.createFileOutputStream(filePath);
        }
        return this.createURLOutputStream(converted);
    }

    public String toString(URI uri) {
        URI converted = this.normalize(uri);
        String scheme = converted.scheme();
        if ("file".equals(scheme)) {
            return converted.toFileString();
        }
        if ("platform".equals(scheme) && converted.segmentCount() > 1 && "resource".equals(converted.segment(0))) {
            StringBuffer platformResourcePath = new StringBuffer();
            int i = 1;
            int size = converted.segmentCount();
            while (i < size) {
                platformResourcePath.append('/');
                platformResourcePath.append(converted.segment(i));
                ++i;
            }
            return platformResourcePath.toString();
        }
        return converted.toString();
    }

    public URI normalize(URI uri) {
        String fragment = uri.fragment();
        URI result = fragment == null ? this.getInternalURIMap().getURI(uri) : this.getInternalURIMap().getURI(uri.trimFragment()).appendFragment(fragment);
        String scheme = result.scheme();
        if (scheme == null) {
            if (workspaceRoot != null) {
                if (result.hasAbsolutePath()) {
                    result = URI.createPlatformResourceURI((String)result.toString());
                }
            } else {
                result = URI.createURI((String)("file:" + result));
            }
        }
        if (result.equals((Object)uri)) {
            return uri;
        }
        return this.normalize(result);
    }

    protected InputStream createFileInputStream(String filePath) throws IOException {
        File file = new File(filePath);
        FileInputStream inputStream = new FileInputStream(file);
        return inputStream;
    }

    protected OutputStream createFileOutputStream(String filePath) throws IOException {
        File file = new File(filePath);
        String parent = file.getParent();
        if (parent != null) {
            new File(parent).mkdirs();
        }
        FileOutputStream outputStream = new FileOutputStream(file);
        return outputStream;
    }

    protected InputStream createPlatformResourceInputStream(String platformResourcePath) throws IOException {
        if (workspaceRoot != null) {
            return WorkbenchHelper.createPlatformResourceInputStream(platformResourcePath);
        }
        URI resolvedLocation = EcorePlugin.resolvePlatformResourcePath((String)platformResourcePath);
        if (resolvedLocation != null) {
            return this.createInputStream(resolvedLocation);
        }
        throw new IOException("The path '" + platformResourcePath + "' is unmapped");
    }

    protected OutputStream createPlatformResourceOutputStream(String platformResourcePath) throws IOException {
        if (workspaceRoot != null) {
            return WorkbenchHelper.createPlatformResourceOutputStream(platformResourcePath);
        }
        URI resolvedLocation = EcorePlugin.resolvePlatformResourcePath((String)platformResourcePath);
        if (resolvedLocation != null) {
            return this.createOutputStream(resolvedLocation);
        }
        throw new IOException("The path '" + platformResourcePath + "' is unmapped");
    }

    protected InputStream createURLInputStream(URI uri) throws IOException {
        URL url = new URL(uri.toString());
        URLConnection urlConnection = url.openConnection();
        return urlConnection.getInputStream();
    }

    protected OutputStream createURLOutputStream(URI uri) throws IOException {
        URL url = new URL(uri.toString());
        URLConnection urlConnection = url.openConnection();
        urlConnection.setDoOutput(true);
        return urlConnection.getOutputStream();
    }

    public static class WorkbenchHelper {
        public static InputStream createPlatformResourceInputStream(String platformResourcePath) throws IOException {
            IFile file = workspaceRoot.getFile((IPath)new Path(platformResourcePath));
            try {
                if (!file.isLocal(1) || !file.isSynchronized(1)) {
                    file.refreshLocal(1, null);
                }
                return file.getContents();
            }
            catch (CoreException exception) {
                throw new Resource.IOWrappedException((Exception)((Object)exception));
            }
        }

        public static OutputStream createPlatformResourceOutputStream(String platformResourcePath) throws IOException {
            IFile file = workspaceRoot.getFile((IPath)new Path(platformResourcePath));
            return new HierarchyPlatformResourceOutputStream(file, false, false, null);
        }
    }

    public static class HierarchyPlatformResourceOutputStream
    extends OutputStream {
        protected HierarchyPipedInputStream pipedInputStream;
        protected IFile file;
        protected IProgressMonitor progressMonitor;
        protected boolean firstCall = true;
        protected boolean force;
        protected boolean keepHistory;
        protected int SAVE_TRESHOLD = 262144;
        protected byte[] outBuf = new byte[this.SAVE_TRESHOLD];
        protected int outPos;

        public HierarchyPlatformResourceOutputStream(IFile file, boolean force, boolean keepHistory, IProgressMonitor monitor) throws IOException {
            this.file = file;
            this.force = force;
            this.keepHistory = keepHistory;
            this.progressMonitor = monitor;
            this.createContainer(file.getParent());
            this.pipedInputStream = new HierarchyPipedInputStream(this.outBuf, 0);
        }

        public void close() throws IOException {
            this.flush();
        }

        public void flush() throws IOException {
            if (this.outPos > 0) {
                this.writeToWorkspaceResource();
                this.outPos = 0;
            }
        }

        public void write(byte[] data, int offset, int length) throws IOException {
            while (length > 0) {
                int writeBytes = this.min(this.SAVE_TRESHOLD - this.outPos, length);
                System.arraycopy(data, offset, this.outBuf, this.outPos, writeBytes);
                this.outPos += writeBytes;
                offset += writeBytes;
                length -= writeBytes;
                if (this.outPos != this.SAVE_TRESHOLD) continue;
                this.flush();
            }
        }

        public void write(byte[] arg0) throws IOException {
            this.write(arg0, 0, arg0.length);
        }

        public void write(int arg0) throws IOException {
            this.outBuf[this.outPos++] = (byte)arg0;
            if (this.outPos == this.SAVE_TRESHOLD) {
                this.flush();
            }
        }

        protected void createContainer(IContainer container) throws IOException {
            if (!container.exists() && container.getType() == 2) {
                this.createContainer(container.getParent());
                try {
                    ((IFolder)container).create(this.force, this.keepHistory, this.progressMonitor);
                }
                catch (CoreException exception) {
                    throw new Resource.IOWrappedException((Exception)((Object)exception));
                }
            }
        }

        protected int min(int a, int b) {
            if (a < b) {
                return a;
            }
            return b;
        }

        private void writeToWorkspaceResource() throws IOException {
            this.pipedInputStream.setInBuf(this.outBuf, this.outPos);
            try {
                if (!this.file.exists()) {
                    this.file.create((InputStream)this.pipedInputStream, this.force, this.progressMonitor);
                    this.firstCall = false;
                } else {
                    if (!this.file.isLocal(1) || !this.file.isSynchronized(1)) {
                        this.file.refreshLocal(1, this.progressMonitor);
                    }
                    if (this.firstCall) {
                        this.file.setContents((InputStream)this.pipedInputStream, this.force, this.keepHistory, this.progressMonitor);
                        this.firstCall = false;
                    } else {
                        this.file.appendContents((InputStream)this.pipedInputStream, this.force, this.keepHistory, this.progressMonitor);
                    }
                }
            }
            catch (CoreException exception) {
                throw new Resource.IOWrappedException((Exception)((Object)exception));
            }
        }
    }

    public static class HierarchyPipedInputStream
    extends InputStream {
        private byte[] inBuf;
        private int inCount;
        private int inPos;
        private long inTotalLength;

        public HierarchyPipedInputStream(byte[] buf, int length) {
            this.inBuf = buf;
            this.inCount = length;
            this.inTotalLength = length;
            this.inPos = 0;
        }

        public void setInBuf(byte[] buf, int length) {
            this.inBuf = buf;
            this.inCount = length;
            this.inTotalLength = length;
            this.inPos = 0;
        }

        public int available() throws IOException {
            return this.inCount;
        }

        public boolean markSupported() {
            return false;
        }

        public int read() throws IOException {
            if (this.available() == 0) {
                return -1;
            }
            --this.inCount;
            return this.inBuf[this.inPos++];
        }

        public int read(byte[] outBuf, int offset, int length) throws IOException {
            if (this.available() == 0) {
                return -1;
            }
            int readBytes = this.min(this.inCount, length);
            System.arraycopy(this.inBuf, this.inPos, outBuf, offset, readBytes);
            this.inPos += readBytes;
            this.inCount -= readBytes;
            return readBytes;
        }

        public int read(byte[] arg0) throws IOException {
            return this.read(arg0, 0, arg0.length);
        }

        public long skip(long arg0) throws IOException {
            if ((arg0 += (long)this.inPos) < this.inTotalLength) {
                this.inPos = (int)arg0;
                return arg0;
            }
            return -1L;
        }

        protected int min(int a, int b) {
            if (a < b) {
                return a;
            }
            return b;
        }
    }

    public static interface URIMap
    extends Map {
        public URI getURI(URI var1);
    }
}

