/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.execution.local.file;

import java.io.IOException;
import java.io.PrintStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.hyades.execution.core.file.IFileManagerExtended;
import org.eclipse.hyades.execution.core.timer.IPerformanceTimer;
import org.eclipse.hyades.execution.core.timer.PerformanceTimer;
import org.eclipse.hyades.execution.local.file.FileManagerExtendedImpl;
import org.eclipse.hyades.internal.execution.local.control.Connection;

class FileManagerExtendedTimedImpl
extends FileManagerExtendedImpl {
    private final IPerformanceTimer timer;
    private final int iterations;

    FileManagerExtendedTimedImpl(Connection connection) {
        super(connection);
        this.timer = PerformanceTimer.getInstance((String)this.toString());
        this.iterations = 1;
    }

    FileManagerExtendedTimedImpl(Connection connection, PrintStream stream) {
        super(connection);
        this.timer = PerformanceTimer.getInstance((String)this.toString(), (PrintStream)stream);
        this.iterations = 1;
    }

    FileManagerExtendedTimedImpl(Connection connection, int iterations) {
        super(connection);
        this.timer = PerformanceTimer.getInstance((String)this.toString());
        this.iterations = iterations;
    }

    FileManagerExtendedTimedImpl(Connection connection, PrintStream stream, int iterations) {
        super(connection);
        this.timer = PerformanceTimer.getInstance((String)this.toString(), (PrintStream)stream);
        this.iterations = iterations;
    }

    public void deleteFile(IFileManagerExtended.Cookie cookie, IProgressMonitor monitor) throws IOException {
        this.timer.start("deleteFile (using cookie to access server state)" + cookie);
        super.deleteFile(cookie, monitor);
        this.timer.stop();
        this.timer.elapsed();
    }

    public void deleteFile(IFileManagerExtended.FileIdentifierList remoteIdentifiers, IProgressMonitor monitor) throws IOException {
        boolean isServerAvailable = false;
        this.timer.start("deleteFile with " + remoteIdentifiers.size() + " files");
        int i = 1;
        while (i < this.iterations + 1) {
            this.timer.start("iteration " + i);
            super.deleteFile(remoteIdentifiers, monitor);
            this.timer.stop();
            this.timer.elapsed();
            ++i;
        }
        this.timer.stop();
        this.timer.elapsed();
    }

    public void getFile(IFileManagerExtended.FileIdentifierList localIdentifiers, IFileManagerExtended.FileIdentifierList remoteIdentifiers, IFileManagerExtended.Option[] options, IProgressMonitor monitor) throws IOException {
        int size = localIdentifiers.size();
        this.timer.start("getFile with " + size + " files named " + localIdentifiers.getArray()[0] + " ... " + localIdentifiers.getArray()[size - 1]);
        int i = 1;
        while (i < this.iterations + 1) {
            this.timer.start("iteration " + i);
            super.getFile(localIdentifiers, remoteIdentifiers, options, monitor);
            this.timer.stop();
            this.timer.elapsed();
            ++i;
        }
        this.timer.stop();
        this.timer.elapsed();
    }

    public boolean isServerAvailable() throws IOException {
        boolean isServerAvailable = false;
        this.timer.start("isServerAvailable");
        int i = 1;
        while (i < this.iterations + 1) {
            this.timer.start("iteration " + i);
            isServerAvailable = super.isServerAvailable() || isServerAvailable;
            this.timer.stop();
            this.timer.elapsed();
            ++i;
        }
        this.timer.stop();
        this.timer.elapsed();
        return isServerAvailable;
    }

    public void putFile(IFileManagerExtended.Cookie cookie, IFileManagerExtended.FileIdentifierList localIdentifiers, IFileManagerExtended.FileIdentifierList remoteIdentifiers, IFileManagerExtended.Option[] options, IProgressMonitor monitor) throws IOException {
        int size = localIdentifiers.size();
        if (size > 0) {
            this.timer.start("putFile with " + size + " files named " + localIdentifiers.getArray()[0] + " ... " + localIdentifiers.getArray()[size - 1]);
            int i = 1;
            while (i < this.iterations + 1) {
                this.timer.start("iteration " + i);
                super.putFile(cookie, localIdentifiers, remoteIdentifiers, options, monitor);
                this.timer.stop();
                this.timer.elapsed();
                ++i;
            }
            this.timer.stop();
            this.timer.elapsed();
        }
    }
}

