/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.execution.local.file;

import java.util.StringTokenizer;
import org.eclipse.hyades.execution.core.file.IFileManagerExtended;
import org.eclipse.hyades.execution.local.file.FileManagerExtendedImpl;
import org.eclipse.hyades.execution.local.file.FileManagerExtendedTimedImpl;
import org.eclipse.hyades.execution.local.file.FileManagerLegacy;
import org.eclipse.hyades.execution.local.file.IFileManagerFactory;
import org.eclipse.hyades.internal.execution.local.common.SetNVPairCommand;
import org.eclipse.hyades.internal.execution.local.control.Connection;
import org.eclipse.hyades.internal.execution.local.control.Node;
import org.eclipse.hyades.internal.execution.local.control.NotConnectedException;
import org.eclipse.hyades.internal.execution.local.control.SecureConnectionImpl;

public final class FileManagerFactory
implements IFileManagerFactory {
    private static final String MINIMUM_RAC_VERSION_FOR_NEW_SERVER = "3.3";
    private static final String VERSION = "version";
    private static final String ORG_ECLIPSE_HYADES_DATACOLLECTION = "org.eclipse.hyades.datacollection";
    private static final String ORG_ECLIPSE_TPTP_PLATFORM_COLLECTION_FRAMEWORK = "org.eclipse.tptp.platform.collection.framework";
    private static final IFileManagerFactory factory = new FileManagerFactory();
    private static final int QUERY_SERVER_AVAILABILITY_TIMEOUT_INCREMENT = 250;
    private static final int QUERY_SERVER_AVAILABILITY_TIMEOUT_START = 500;
    private static final int QUERY_SERVER_AVAILABILITY_TRIES = 5;

    public static IFileManagerFactory getInstance() {
        return factory;
    }

    private FileManagerFactory() {
    }

    public IFileManagerExtended create(Connection connection) {
        boolean useLegacyImpl = false;
        Object fileManager = null;
        int retries = 0;
        if (connection instanceof SecureConnectionImpl || this.isLegacyRACVersion(connection)) {
            useLegacyImpl = true;
        }
        while (retries < 5 && fileManager == null) {
            fileManager = useLegacyImpl ? new FileManagerExtendedImpl.Adapter(new FileManagerLegacy(connection)) : new FileManagerExtendedImpl(connection);
            if (fileManager != null) continue;
            try {
                Thread.sleep(750L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        return fileManager;
    }

    private boolean isLegacyRACVersion(Connection connection) {
        String version = this.getRACversion(connection.getNode());
        return version == null || !FileManagerFactory.versionIsAtLeast(MINIMUM_RAC_VERSION_FOR_NEW_SERVER, version);
    }

    private static boolean versionIsAtLeast(String required, String version) {
        StringTokenizer stReq = new StringTokenizer(required, ".");
        StringTokenizer stVer = new StringTokenizer(version, ".");
        int majReq = 0;
        int majVer = -1;
        if (!stReq.hasMoreTokens() || !stVer.hasMoreTokens()) {
            return false;
        }
        majReq = Integer.valueOf(stReq.nextToken());
        majVer = Integer.valueOf(stVer.nextToken());
        if (majVer < majReq) {
            return false;
        }
        if (majVer > majReq) {
            return true;
        }
        int min = Math.min(stReq.countTokens(), stVer.countTokens());
        int i = 0;
        while (i < min) {
            int minReq = 0;
            int minVer = -1;
            if (stReq.hasMoreTokens()) {
                minReq = Integer.valueOf(stReq.nextToken());
                if (stVer.hasMoreTokens()) {
                    minVer = Integer.valueOf(stVer.nextToken());
                    if (minVer < minReq) {
                        return false;
                    }
                    if (minVer > minReq) {
                        return true;
                    }
                    if (i == min - 1) {
                        if (!stReq.hasMoreTokens()) {
                            return minVer == minReq;
                        }
                        return false;
                    }
                }
            }
            ++i;
        }
        return false;
    }

    private String getRACversion(Node node) {
        String name_3_3 = ORG_ECLIPSE_HYADES_DATACOLLECTION;
        String name_4_0 = ORG_ECLIPSE_TPTP_PLATFORM_COLLECTION_FRAMEWORK;
        String type = VERSION;
        String value = this.getRACPropertyStringValue(node, name_3_3, type);
        if (value == null) {
            value = this.getRACPropertyStringValue(node, name_4_0, type);
        }
        return value;
    }

    private String getRACPropertyStringValue(Node node, String name, String type) {
        SetNVPairCommand[] values = null;
        try {
            values = node.getPropertyValues(name, type);
        }
        catch (NotConnectedException e) {
            // empty catch block
        }
        if (values != null && values.length > 0) {
            return values[0].getValue();
        }
        return null;
    }

    public IFileManagerExtended createTimed(Connection connection, int iterations) {
        boolean useLegacyImpl = false;
        Object fileManager = null;
        int retries = 0;
        if (connection instanceof SecureConnectionImpl || this.isLegacyRACVersion(connection)) {
            useLegacyImpl = true;
        }
        while (retries < 5 && fileManager == null) {
            fileManager = useLegacyImpl ? new FileManagerExtendedImpl.Adapter(new FileManagerLegacy(connection)) : new FileManagerExtendedTimedImpl(connection, iterations);
            if (fileManager != null) continue;
            try {
                Thread.sleep(750L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        return fileManager;
    }
}

