/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.internal.config.generator;

import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.hyades.internal.config.generator.Allow;
import org.eclipse.hyades.internal.config.generator.ConfigUtility;
import org.eclipse.hyades.internal.config.generator.Logger;
import org.eclipse.hyades.internal.config.generator.PlatformObject;
import org.eclipse.hyades.internal.config.generator.UserDefinition;
import org.eclipse.hyades.internal.config.generator.Variable;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class ConfigFile
extends DefaultHandler {
    protected static String TAG = ConfigUtility.getString("Config.AgentControllerConfig.Tag");
    private static String lineSeparator = System.getProperty("line.separator");
    protected DocumentBuilderFactory docBuildFactory = null;
    protected DocumentBuilder docBuild = null;
    protected Document doc = null;
    protected Element acConfig = null;
    protected Element holder = null;
    private int size = 100;
    private Hashtable hash = new Hashtable(this.size);
    private String sr = PlatformObject.sr;
    private String filename = null;

    public ConfigFile(String string) {
        this.docBuildFactory = DocumentBuilderFactory.newInstance();
        try {
            this.docBuild = this.docBuildFactory.newDocumentBuilder();
            this.createNewDocument();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            Logger.err("Cannot create document builder");
        }
        this.filename = string;
        File file = new File(this.filename);
        if (file.exists()) {
            this.loadExistingDocument(this.filename);
        }
    }

    public void saveToFile() {
        if (this.filename != null) {
            this.saveToFile(this.filename);
        }
    }

    public void saveToFile(String string) {
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter(new FileWriter(string));
        }
        catch (Exception exception) {
            Logger.err(ConfigUtility.getString("Config.Writer.Error.CannotWriteFile") + " " + string);
            Logger.err(exception.getMessage());
        }
        if (printWriter != null) {
            printWriter.print(this.toString());
            printWriter.flush();
            printWriter.close();
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = PlatformObject.encoding;
        String string2 = "1.0";
        stringBuffer.append("<?xml");
        stringBuffer.append(" version=\"" + string2 + "\"");
        stringBuffer.append(" encoding=\"" + string + "\"");
        stringBuffer.append("?>" + lineSeparator);
        NodeList nodeList = this.holder.getChildNodes();
        if (nodeList != null) {
            int n = 0;
            while (n < nodeList.getLength()) {
                stringBuffer.append(ConfigUtility.print(nodeList.item(n)));
                ++n;
            }
        }
        return stringBuffer.toString();
    }

    public void generateConfiguration() {
        this.generateHyadesConfiguration();
    }

    public void generateHyadesConfiguration() {
    }

    public void init(Hashtable hashtable) {
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = (String)hashtable.get(string);
            this.setValue(string, string2);
        }
    }

    public void createNewDocument() {
        DOMImplementation dOMImplementation = this.docBuild.getDOMImplementation();
        this.doc = dOMImplementation.createDocument(null, TAG, null);
        this.holder = this.doc.createElement("ElementHolder");
    }

    public void loadExistingDocument(String string) {
        block4: {
            SAXParser sAXParser = null;
            XMLReader xMLReader = null;
            try {
                sAXParser = SAXParserFactory.newInstance().newSAXParser();
                xMLReader = sAXParser.getXMLReader();
                xMLReader.setContentHandler(this);
                xMLReader.setErrorHandler(this);
            }
            catch (Exception exception) {
                Logger.err(ConfigUtility.getString("Config.Parser.Error.CreateParser") + " " + xMLReader);
                Logger.err(exception.getMessage());
            }
            if (xMLReader == null) break block4;
            try {
                xMLReader.parse(string);
            }
            catch (Exception exception) {
                Exception exception2;
                Logger.err(ConfigUtility.getString("Config.Parser.Error.ParseFile") + " " + string);
                Logger.err(exception.getMessage());
                if (!(exception instanceof SAXException) || (exception2 = ((SAXException)exception).getException()) == null) break block4;
                Logger.err(exception2.getMessage());
            }
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (string3.equals(UserDefinition.TAG)) {
            String string4 = null;
            String string5 = null;
            int n = 0;
            while (n < attributes.getLength()) {
                if (attributes.getQName(n).equals(ConfigUtility.getString("Config.UserDefinition.AuthenticationType.Tag"))) {
                    string4 = attributes.getValue(n);
                } else if (attributes.getQName(n).equals(ConfigUtility.getString("Config.UserDefinition.Name.Tag"))) {
                    string5 = attributes.getValue(n);
                } else {
                    Logger.out(ConfigUtility.getString("Config.Parser.Warning.UnrecognizedAttribute") + " " + attributes.getQName(n));
                }
                ++n;
            }
            if (string4 != null && string5 != null) {
                this.setValue("SECURITY", "true");
                if (this.getValue("USERS") == null) {
                    this.setValue("USERS", string5);
                } else {
                    this.setValue("USERS", this.getValue("USERS") + "," + string5);
                }
            }
        } else if (string3.equals(Variable.TAG)) {
            String string6 = null;
            String string7 = null;
            String string8 = null;
            int n = 0;
            while (n < attributes.getLength()) {
                if (attributes.getQName(n).equals(ConfigUtility.getString("Config.Variable.Name.Tag"))) {
                    string6 = attributes.getValue(n);
                } else if (attributes.getQName(n).equals(ConfigUtility.getString("Config.Variable.Value.Tag"))) {
                    string7 = attributes.getValue(n);
                } else if (attributes.getQName(n).equals(ConfigUtility.getString("Config.Variable.Position.Tag"))) {
                    string8 = attributes.getValue(n);
                } else {
                    Logger.out(ConfigUtility.getString("Config.Parser.Warning.UnrecognizedAttribute") + " " + attributes.getQName(n));
                }
                ++n;
            }
            if (string6 != null && string7 != null && string8 != null && !string6.equals("CLASSPATH") && !string6.equals("PATH")) {
                this.setValue(string6, string7);
            }
        } else if (string3.equals(Allow.TAG)) {
            String string9 = null;
            int n = 0;
            while (n < attributes.getLength()) {
                if (attributes.getQName(n).equals(ConfigUtility.getString("Config.Allow.Host.Tag"))) {
                    string9 = attributes.getValue(n);
                } else {
                    Logger.out(ConfigUtility.getString("Config.Parser.Warning.UnrecognizedAttribute") + " " + attributes.getQName(n));
                }
                ++n;
            }
            if (string9 != null) {
                if (string9.toLowerCase().equals("all") || string9.toLowerCase().equals("local")) {
                    this.setValue("ALLOW", string9.toUpperCase());
                    this.removeKey("HOSTS");
                } else {
                    this.setValue("ALLOW", "CUSTOM");
                    if (this.getValue("HOSTS") == null) {
                        this.setValue("HOSTS", string9);
                    } else {
                        this.setValue("HOSTS", this.getValue("HOSTS") + "," + string9);
                    }
                }
            }
        } else {
            Logger.out(ConfigUtility.getString("Config.Parser.Warning.UnrecognizedElement") + " " + string2);
        }
    }

    public Element getAcConfig() {
        return this.acConfig;
    }

    public String getValue(String string) {
        return (String)this.hash.get(string);
    }

    public void setValue(String string, String string2) {
        if (string != null && string2 != null) {
            this.hash.put(string, string2);
        }
    }

    public void removeKey(String string) {
        this.hash.remove(string);
    }

    public boolean isExist(String string) {
        return this.hash.containsKey(string);
    }

    public Element getHolder() {
        return this.holder;
    }

    public Document getDoc() {
        return this.doc;
    }

    public void setFileName(String string) {
        this.filename = string;
    }
}

