/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.jvm.threadanalysis;

import java.io.File;
import java.util.Vector;
import org.eclipse.hyades.collection.threadanalyzer.DumpData;
import org.eclipse.hyades.logging.events.cbe.CommonBaseEvent;
import org.eclipse.hyades.logging.events.cbe.util.EventFormatter;
import org.eclipse.hyades.logging.jvm.threadanalysis.ThreadDumpAgent;
import org.eclipse.hyades.logging.jvm.threadanalysis.ThreadDumpGeneratorImpl;
import org.eclipse.hyades.logging.jvm.threadanalysis.ThreadDumpProcessorImpl;

public class ThreadDumpAgentImpl
implements ThreadDumpAgent {
    private static boolean debug = false;
    private static final String dllname = "hcthread";
    private String name = "Thread Analyzer Agent";
    private String type = "Logging";

    public static void main(String[] stringArray) {
        ThreadDumpAgentImpl threadDumpAgentImpl = new ThreadDumpAgentImpl();
        threadDumpAgentImpl.init();
        while (true) {
            try {
                while (true) {
                    Thread.sleep(5000L);
                }
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
                threadDumpAgentImpl.dump();
                threadDumpAgentImpl.deregister();
                continue;
            }
            break;
        }
    }

    public void init() {
        String string = this.name + ":" + this.hashCode();
        this.init0(string, this.type);
        ThreadDumpAgentImpl.debugTrace("Initialized agent: " + string);
    }

    public void dump() {
        this.dumpThreads0();
        ThreadDumpAgentImpl.debugTrace("Dump completed");
    }

    public void deregister() {
        this.deregister0();
        ThreadDumpAgentImpl.debugTrace("Deregisterd agent");
    }

    private static File findJavaCore(String string, int n) {
        File file = null;
        long l = 0L;
        File file2 = new File(string);
        if (file2 != null) {
            ThreadDumpAgentImpl.debugTrace("Checking directory: " + string);
            File[] fileArray = file2.listFiles();
            if (fileArray != null) {
                int n2 = 0;
                while (n2 < fileArray.length) {
                    String string2 = fileArray[n2].getName();
                    ThreadDumpAgentImpl.debugTrace("Checking file: " + string2);
                    if (ThreadDumpAgentImpl.isJavaCore(string2, n) && fileArray[n2].lastModified() > l) {
                        ThreadDumpAgentImpl.debugTrace("Modified time: " + fileArray[n2].lastModified());
                        ThreadDumpAgentImpl.debugTrace("Base time: " + l);
                        file = fileArray[n2];
                        l = fileArray[n2].lastModified();
                    }
                    ++n2;
                }
            }
        }
        return file;
    }

    private static boolean isJavaCore(String string, int n) {
        if (string.startsWith("javacore" + n) && string.endsWith(".txt") || string.startsWith("Javadump") && string.endsWith(".txt") || string.equals("javacore.txt") || string.startsWith("javacore") && string.endsWith(n + ".txt")) {
            return true;
        }
        return System.getProperty("os.name").equals("Linux") && string.startsWith("javacore") && string.endsWith(".txt");
    }

    private static String processDumpData(String string) {
        String string2 = "";
        ThreadDumpGeneratorImpl threadDumpGeneratorImpl = new ThreadDumpGeneratorImpl();
        ThreadDumpProcessorImpl threadDumpProcessorImpl = new ThreadDumpProcessorImpl();
        File file = ThreadDumpAgentImpl.findJavaCore(string, ThreadDumpAgentImpl.getPid0());
        if (file != null) {
            String string3 = file.getAbsolutePath().replace('\\', '/');
            ThreadDumpAgentImpl.debugTrace("Javacore found: " + string3);
            DumpData dumpData = threadDumpGeneratorImpl.dump(string3);
            ThreadDumpAgentImpl.debugTrace("DumpData obtained");
            if (dumpData != null) {
                Vector vector = threadDumpProcessorImpl.generateCBEs(dumpData);
                if (vector != null) {
                    ThreadDumpAgentImpl.debugTrace("CBE generated");
                    int n = 0;
                    while (n < vector.size()) {
                        string2 = string2 + EventFormatter.toCanonicalXMLString((CommonBaseEvent)((CommonBaseEvent)vector.elementAt(n)), (boolean)false);
                        ++n;
                    }
                    return string2;
                }
                return new String("<CommonBaseEvent msg=\"No common base event\"/>");
            }
            return new String("<CommonBaseEvent msg=\"No dump data\"/>");
        }
        return new String("<CommonBaseEvent msg=\"No java core file\"/>");
    }

    private static void debugTrace(String string) {
        if (debug) {
            System.out.println("DEBUG(JAVA): " + string);
        }
    }

    private native void dumpThreads0();

    private native void init0(String var1, String var2);

    private native void deregister0();

    private static native int getPid0();

    static {
        if (System.getProperty("debug") != null) {
            debug = true;
            ThreadDumpAgentImpl.debugTrace("Debug is ON");
        }
        System.loadLibrary(dllname);
        ThreadDumpAgentImpl.debugTrace("Finished loading native library: hcthread");
    }
}

