/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.events.cbe.impl;

import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.hyades.logging.events.cbe.ContentHandler;
import org.eclipse.hyades.logging.events.cbe.EventFactory;
import org.eclipse.hyades.logging.events.cbe.EventFactoryHome;
import org.eclipse.hyades.logging.events.cbe.impl.EventFactoryImpl;

public abstract class AbstractEventFactoryHome
implements EventFactoryHome {
    private Hashtable eventFactories = new Hashtable();
    private EventFactory anonymousEventFactory = null;

    public abstract ContentHandler createContentHandler(String var1);

    public abstract ContentHandler resolveContentHandler();

    public void checkAccess() throws SecurityException {
    }

    public EventFactory getAnonymousEventFactory() {
        if (this.anonymousEventFactory == null) {
            this.anonymousEventFactory = new EventFactoryImpl();
            this.updateAnonymousEventFactory();
        }
        return this.anonymousEventFactory;
    }

    public EventFactory getEventFactory(String string) {
        if (string == null) {
            return this.getAnonymousEventFactory();
        }
        if (this.eventFactories.containsKey(string)) {
            return (EventFactory)this.eventFactories.get(string);
        }
        EventFactoryImpl eventFactoryImpl = new EventFactoryImpl();
        eventFactoryImpl.setContentHandler(this.createContentHandler(string));
        this.eventFactories.put(string, eventFactoryImpl);
        return eventFactoryImpl;
    }

    public void updateAnonymousEventFactory() {
        block2: {
            if (this.anonymousEventFactory == null) break block2;
            try {
                this.anonymousEventFactory.setContentHandler(this.createContentHandler(null));
            }
            catch (NullPointerException nullPointerException) {}
        }
    }

    public void updateEventFactory(String string) {
        if (string == null) {
            this.updateAnonymousEventFactory();
        } else if (string.trim().length() == 0 || string.trim().equals("*")) {
            Enumeration enumeration = this.eventFactories.keys();
            while (enumeration.hasMoreElements()) {
                this.updateEventFactory((String)enumeration.nextElement());
            }
        } else if (this.eventFactories.containsKey(string)) {
            ((EventFactory)this.eventFactories.get(string)).setContentHandler(this.createContentHandler(string));
        }
    }

    public void releaseEventFactory(String string) {
        if (string != null) {
            if (string.trim().length() == 0 || string.trim().equals("*")) {
                this.eventFactories.clear();
            } else if (this.eventFactories.containsKey(string)) {
                this.eventFactories.remove(string);
            }
        }
    }
}

