/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.internal.execution.core.file;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import org.eclipse.core.internal.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.hyades.execution.core.file.IFileManagerExtended;
import org.eclipse.hyades.internal.execution.core.file.AbstractFileTransferCommand;
import org.eclipse.hyades.internal.execution.core.file.IPutFileCommand;
import org.eclipse.hyades.internal.execution.core.file.ISocketChannel;

class PutFileCommand
extends AbstractFileTransferCommand
implements IPutFileCommand {
    static /* synthetic */ Class class$org$eclipse$hyades$internal$execution$core$file$PutFileCommand;

    public PutFileCommand(ISocketChannel channel) {
        super(class$org$eclipse$hyades$internal$execution$core$file$PutFileCommand == null ? (class$org$eclipse$hyades$internal$execution$core$file$PutFileCommand = PutFileCommand.class$("org.eclipse.hyades.internal.execution.core.file.PutFileCommand")) : class$org$eclipse$hyades$internal$execution$core$file$PutFileCommand);
        this.setState(new Server(channel));
    }

    PutFileCommand(ISocketChannel channel, IFileManagerExtended.Cookie cookie, IFileManagerExtended.FileIdentifierList localIdentifiers, IFileManagerExtended.FileIdentifierList remoteIdentifiers, IFileManagerExtended.Option[] options, IProgressMonitor monitor) {
        super(class$org$eclipse$hyades$internal$execution$core$file$PutFileCommand == null ? (class$org$eclipse$hyades$internal$execution$core$file$PutFileCommand = PutFileCommand.class$("org.eclipse.hyades.internal.execution.core.file.PutFileCommand")) : class$org$eclipse$hyades$internal$execution$core$file$PutFileCommand, cookie, localIdentifiers, remoteIdentifiers, options, monitor);
        this.setState(new Client(channel));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class Server
    extends AbstractFileTransferCommand.Server {
        Server(ISocketChannel channel) {
            super(channel);
        }

        public void execute() throws IOException {
            IFileManagerExtended.FileIdentifierList remoteIdentifiers;
            super.execute();
            int count = this.receiveInt();
            PutFileCommand.this.remoteIdentifiers = remoteIdentifiers = IFileManagerExtended.FileIdentifierList.create(this.receiveStrings());
            Iterator identifiers = remoteIdentifiers.iterator();
            while (identifiers.hasNext()) {
                String fileName = (String)identifiers.next();
                File remoteFile = new File(fileName);
                boolean readyToTransfer = true;
                if (!remoteFile.isAbsolute()) continue;
                File remoteDirectory = new File(remoteFile.getParent());
                if (!remoteDirectory.exists()) {
                    readyToTransfer = remoteDirectory.mkdirs();
                }
                if (!readyToTransfer) continue;
                remoteFile.createNewFile();
                this.receive(remoteFile);
            }
        }
    }

    private class Client
    extends AbstractFileTransferCommand.Client {
        Client(ISocketChannel channel) {
            super(channel);
        }

        public void execute() throws IOException {
            super.execute();
            IFileManagerExtended.FileIdentifierList localIdentifiers = PutFileCommand.this.localIdentifiers;
            IFileManagerExtended.FileIdentifierList remoteIdentifiers = PutFileCommand.this.remoteIdentifiers;
            Assert.isTrue((localIdentifiers.size() == remoteIdentifiers.size() ? 1 : 0) != 0);
            this.send(localIdentifiers.size());
            this.send(remoteIdentifiers.getArray());
            Iterator identifiers = localIdentifiers.iterator();
            while (identifiers.hasNext()) {
                String fileName = (String)identifiers.next();
                File localFile = new File(fileName);
                if (!localFile.isFile()) continue;
                this.send(localFile);
            }
        }
    }
}

