/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.internal.filters;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.hyades.logging.adapter.AdapterInvalidConfig;
import org.eclipse.hyades.logging.adapter.internal.filters.FilterElementImpl;
import org.eclipse.hyades.logging.adapter.internal.filters.IFilterAtom;
import org.eclipse.hyades.logging.adapter.internal.filters.IFilterType;
import org.eclipse.hyades.logging.adapter.internal.filters.NumericalRangeFilterType;
import org.eclipse.hyades.logging.adapter.util.Messages;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class FilterAtomImpl
extends FilterElementImpl
implements IFilterAtom {
    private String implementationClassname;
    private List attributePath;
    private String leftOperand;
    private String rightOperand;
    private IFilterType evaluator;

    public void prepareFilter(Element node) throws AdapterInvalidConfig {
        super.prepareFilter(node);
        this.implementationClassname = node.getAttribute(Messages.getString("HyadesGAImplementationClassAttributeName"));
        if (this.implementationClassname == null || this.implementationClassname.equals("")) {
            throw new AdapterInvalidConfig(Messages.getString("HyadesGAFilter_FilterRule_Invalid_No_Impl_Class_ERROR_"));
        }
        try {
            Class<?> filterClassObject = Class.forName(this.implementationClassname);
            this.evaluator = (IFilterType)filterClassObject.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new AdapterInvalidConfig(Messages.getString("HyadesGAFilter_FilterType_Class_Not_Found_ERROR_", this.implementationClassname));
        }
        catch (InstantiationException e) {
            throw new AdapterInvalidConfig(Messages.getString("HyadesGAFilter_FilterType_Class_Instantiation_ERROR_", this.implementationClassname, e.getMessage()));
        }
        catch (IllegalAccessException e) {
            throw new AdapterInvalidConfig(Messages.getString("HyadesGAFilter_FilterType_Class_Instantiation_ERROR_", this.implementationClassname, e.getMessage()));
        }
        this.rightOperand = node.getAttribute(Messages.getString("HyadesGAAttributeValueAttributeName"));
        if (this.rightOperand == null) {
            throw new AdapterInvalidConfig(Messages.getString("HyadesGAFilter_FilterRule_Invalid_No_Value_ERROR_"));
        }
        NodeList children = node.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            block27: {
                int j;
                Element child = null;
                try {
                    child = (Element)children.item(i);
                }
                catch (ClassCastException e) {
                    break block27;
                }
                if (child.getNodeName().endsWith(Messages.getString("HyadesGAttributeNamePathElementTagName"))) {
                    NodeList nodes = child.getChildNodes();
                    j = 0;
                    while (j < nodes.getLength()) {
                        block28: {
                            Element nodeValue = null;
                            try {
                                nodeValue = (Element)nodes.item(j);
                            }
                            catch (ClassCastException e) {
                                break block28;
                            }
                            if (nodeValue.getNodeName().endsWith(Messages.getString("HyadesGANodeElementTagName"))) {
                                NodeList values = nodeValue.getChildNodes();
                                int k = 0;
                                while (k < values.getLength()) {
                                    block29: {
                                        CharacterData value = null;
                                        try {
                                            value = (CharacterData)values.item(k);
                                        }
                                        catch (ClassCastException e) {
                                            break block29;
                                        }
                                        if (this.attributePath == null) {
                                            this.attributePath = new ArrayList();
                                            this.attributePath.add(value.getData());
                                        } else {
                                            this.attributePath.add(value.getData());
                                        }
                                    }
                                    ++k;
                                }
                            }
                        }
                        ++j;
                    }
                } else if (child.getNodeName().endsWith(Messages.getString("HyadesGAttributeNameElementTagName"))) {
                    NodeList values = child.getChildNodes();
                    j = 0;
                    while (j < values.getLength()) {
                        block30: {
                            CharacterData value = null;
                            try {
                                value = (CharacterData)values.item(j);
                            }
                            catch (ClassCastException e) {
                                break block30;
                            }
                            if (this.attributePath == null) {
                                this.attributePath = new ArrayList(1);
                                this.attributePath.add(value.getData());
                            }
                        }
                        ++j;
                    }
                }
            }
            ++i;
        }
        String[] ops = this.evaluator.getOperators();
        int in = 0;
        while (in < ops.length) {
            if (ops[in].equals(this.getOperator())) break;
            ++in;
        }
        if (in == ops.length) {
            throw new AdapterInvalidConfig(Messages.getString("HyadesGAFilter_FilterRule_Invalid_Operator_ERROR_", (String)this.attributePath.get(this.attributePath.size() - 1), this.getOperator()));
        }
    }

    public String getLeftOperand() {
        return this.leftOperand;
    }

    public String getRightOperand() {
        return this.rightOperand;
    }

    public void setLeftOperand(String operand) {
        this.leftOperand = operand;
    }

    public void setRightOperand(String operand) {
        this.rightOperand = operand;
    }

    public void setAttributePath(List attributePath) {
        this.attributePath = attributePath;
    }

    public List getAttributePath() {
        return this.attributePath;
    }

    public boolean evaluateFilter() {
        return this.evaluator.processRule(this);
    }

    public IFilterType getEvaluator() {
        return this.evaluator;
    }

    public int requiresCache() {
        if (this.evaluator != null && this.evaluator instanceof NumericalRangeFilterType && this.getOperator().equals("last")) {
            return Integer.parseInt(this.rightOperand);
        }
        return 0;
    }
}

