/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.perfmon.jmxagent.communication;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import org.eclipse.hyades.internal.execution.local.common.SetNVPairCommand;
import org.eclipse.hyades.internal.execution.remote.AgentConfiguration;
import org.eclipse.hyades.internal.execution.remote.AgentControllerListener;
import org.eclipse.hyades.internal.execution.remote.MonitorListener;
import org.eclipse.hyades.internal.execution.remote.QueueManager;
import org.eclipse.hyades.internal.execution.remote.RemoteComponentSkeleton;
import org.eclipse.hyades.perfmon.jmxagent.ascode.ServerCommunicationInterface;
import org.eclipse.hyades.perfmon.jmxagent.ascode.ServerStatInterface;
import org.eclipse.hyades.perfmon.jmxagent.communication.RCS;
import org.eclipse.hyades.perfmon.jmxagent.communication.SetNVCommandHandler;
import org.eclipse.hyades.perfmon.jmxagent.parser.Parser;
import org.eclipse.hyades.perfmon.jmxagent.resource.ResourceManager;

public class JmxAgent
implements SetNVCommandHandler,
AgentControllerListener,
MonitorListener {
    public static final String AGENT_TYPE = "Logging";
    private Parser agentConfig;
    private ResourceManager jbossagent = null;
    private ResultsThread resultThread;
    private RCS delegate;
    private QueueManager queue = new QueueManager();
    private ArrayList results = new ArrayList<E>();
    private Object currentThreadLock = new Object();
    private String port = null;
    private String host = null;
    private String type = null;
    private boolean controllerAvailable = false;
    private boolean isMonitored = false;
    private boolean stop = false;
    private int frequency = 1000;

    /*
     * Unable to fully structure code
     */
    public JmxAgent(Parser var1_1, ServerCommunicationInterface var2_2, ServerStatInterface var3_3) {
        super();
        this.agentConfig = var1_1;
        var4_4 = var1_1.getAgentName();
        this.delegate = new RCS(var4_4, "Logging");
        this.delegate.addSetNVCommandListener(this);
        this.delegate.addAgentControllerListener(this);
        this.delegate.addMonitorListener(this);
        try {
            this.delegate.initialize();
            this.controllerAvailable = true;
        }
        catch (Throwable var5_5) {
            System.out.println("Agent Controller Unavailable. Please ensure the Agent Controller is running and accepting connections.");
        }
        System.out.println("Agent Awaiting Monitor Connection...\n");
        while (!this.isMonitored || !this.controllerAvailable) {
            System.out.println("MONITORED: " + this.isMonitored + " Agent Controller: " + this.controllerAvailable);
            try {
                Thread.sleep(1000L);
            }
            catch (Exception var5_7) {
                // empty catch block
            }
        }
        try {
            var2_2.checkLibs();
            if (true) ** GOTO lbl48
        }
        catch (Exception var5_8) {
            var5_8.printStackTrace();
            this.sendCBEMessage(var4_4, "" + this.delegate.getAgentUUID(), "Error - JAR classpath is incomplete (" + var5_8.getMessage() + ")", "50");
            this.disconnect();
            return;
        }
        do {
            try {
                Thread.sleep(500L);
            }
            catch (Exception var5_9) {
                // empty catch block
            }
lbl48:
            // 3 sources

        } while (var4_4 == null || this.port == null);
        try {
            this.jbossagent = new ResourceManager(this.host, this.port, this.type, this, this.agentConfig, var2_2, var3_3);
        }
        catch (Exception var5_10) {
            this.sendCBEMessage(var4_4, "" + this.delegate.getAgentUUID(), "Error - Unable to connect to " + this.host + ":" + this.port, "50");
            this.sendCBEMessage(var4_4, "" + this.delegate.getAgentUUID(), var5_10.getMessage(), "50");
            this.flush();
            this.disconnect();
            return;
        }
        this.getChild("");
        this.sendCBEMessage("I JUST GOT THE CHILDREN", "30");
        this.resultThread = new ResultsThread();
        this.resultThread.start();
    }

    private void disconnect() {
        this.delegate.deregister();
        this.delegate.finalize();
        this.stop = true;
    }

    public void sendCBEMessage(String string, String string2) {
        this.sendCBEMessage(this.getAgentUUID(), this.agentConfig.getAgentName(), string, string2);
    }

    public void sendCBEMessage(String string, String string2, String string3, String string4) {
        long l = System.currentTimeMillis();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat("HH:mm:ss");
        Date date = new Date(l);
        String string5 = simpleDateFormat.format(date) + "T" + simpleDateFormat2.format(date);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<CommonBaseEvent").append(" creationTime=\"" + string5 + "\"").append(" severity=\"" + string4 + "\"");
        stringBuffer.append(" msg=\"").append(string3).append("\"").append(">");
        stringBuffer.append("<sourceComponentId").append(" component=\"" + string + "\"").append(" subComponent=\"" + string2 + "\"").append("/>");
        stringBuffer.append("</CommonBaseEvent>");
        System.out.println("Sending message " + stringBuffer.toString());
        this.sendMessage(stringBuffer.toString());
    }

    public AgentConfiguration getJBossAgentDefaultConfiguration() {
        return this.delegate.getDefaultConfiguration();
    }

    public void write(String string) {
        if (this.controllerAvailable && this.isMonitored) {
            this.delegate.logMessageUTF8(string);
        } else {
            this.enQueue(string);
        }
    }

    public void sendMessage(String string) {
        this.write(string);
    }

    public void getChild(String string) {
        this.jbossagent.getChildren(this.results, string);
        int n = 0;
        while (n < this.results.size()) {
            this.sendMessage((String)this.results.get(n));
            ++n;
        }
        this.results.clear();
    }

    public void enQueue(String string) {
        this.queue.insertInQueue(string);
    }

    public void flush() {
        if (this.queue.isFlushNeeded()) {
            this.queue.flushCurrentQueue((RemoteComponentSkeleton)this.delegate);
        }
    }

    public String getName() {
        return this.delegate.getName();
    }

    public void handleCommand(SetNVPairCommand setNVPairCommand) {
        if (setNVPairCommand.getType().equals("filter")) {
            if (setNVPairCommand.getValue().equals("false")) {
                this.resultThread.removeCounter(setNVPairCommand.getName());
            } else {
                this.resultThread.addCounter(setNVPairCommand.getName());
            }
        } else if (setNVPairCommand.getType().equals("updatetree")) {
            ArrayList arrayList = new ArrayList();
            if (this.jbossagent != null) {
                this.jbossagent.getChildren(arrayList, setNVPairCommand.getName());
                int n = 0;
                while (n < arrayList.size()) {
                    this.sendMessage((String)arrayList.get(n));
                    ++n;
                }
            }
        } else if (setNVPairCommand.getType().equals("var_int")) {
            if (setNVPairCommand.getName().equals("DC_WAITTIME")) {
                this.frequency = Integer.parseInt(setNVPairCommand.getValue());
            } else if (setNVPairCommand.getName().equals("DC_FINISHED")) {
                this.stop = true;
            }
        } else if (setNVPairCommand.getType().equals("var_boolean")) {
            System.out.println("var_boolean");
            System.out.println(setNVPairCommand.getType() + " " + setNVPairCommand.getName() + " " + setNVPairCommand.getValue());
        } else if (setNVPairCommand.getType().equals("var_string")) {
            if (setNVPairCommand.getName().toUpperCase().equals("HOST")) {
                this.host = setNVPairCommand.getValue();
            } else if (setNVPairCommand.getName().toUpperCase().equals("PORT")) {
                this.port = setNVPairCommand.getValue();
            } else if (setNVPairCommand.getName().toUpperCase().equals("TYPE")) {
                this.type = setNVPairCommand.getValue();
            }
        }
    }

    public void monitorActive() {
        this.isMonitored = true;
        this.flush();
    }

    public void monitorInactive() {
        this.isMonitored = false;
        if (this.jbossagent != null) {
            this.stop = true;
        }
        this.flush();
    }

    public void agentControllerActive() {
        this.controllerAvailable = true;
        this.flush();
        System.out.println("AC ACTIVE");
    }

    public void agentControllerInactive() {
        this.controllerAvailable = false;
        this.flush();
        System.out.println("AC INACTIVE");
    }

    public String getAgentUUID() {
        return this.delegate.getAgentUUID();
    }

    class ResultsThread
    extends Thread {
        ArrayList ids = new ArrayList();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addCounter(String string) {
            ArrayList arrayList = this.ids;
            synchronized (arrayList) {
                this.ids.add(string);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeCounter(String string) {
            ArrayList arrayList = this.ids;
            synchronized (arrayList) {
                this.ids.remove(string);
            }
        }

        public void run() {
            ArrayList arrayList = new ArrayList();
            while (!JmxAgent.this.stop) {
                try {
                    Thread.sleep(JmxAgent.this.frequency);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                arrayList = JmxAgent.this.jbossagent.getAllResults(this.ids);
                int n = 0;
                while (n < arrayList.size()) {
                    JmxAgent.this.sendMessage((String)arrayList.get(n));
                    ++n;
                }
            }
            JmxAgent.this.disconnect();
        }
    }
}

