/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.perfmon.jmxagent.resource;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.eclipse.hyades.perfmon.jmxagent.ascode.ServerCommunicationInterface;
import org.eclipse.hyades.perfmon.jmxagent.ascode.ServerStatInterface;
import org.eclipse.hyades.perfmon.jmxagent.communication.JmxAgent;
import org.eclipse.hyades.perfmon.jmxagent.filter.Filter;
import org.eclipse.hyades.perfmon.jmxagent.parser.Parser;
import org.eclipse.hyades.perfmon.jmxagent.parser.ParserException;
import org.eclipse.hyades.perfmon.jmxagent.resource.JmxElement;
import org.eclipse.hyades.perfmon.jmxagent.resource.ResourceException;
import org.eclipse.hyades.perfmon.jmxagent.resource.SetComparator;

public class ResourceManager {
    private final boolean VERBOSE = false;
    private final long TIMEOUT = 20000L;
    private String StatsAttName = "Stats";
    private int counter = 1;
    private int frequency = 1000;
    private HashMap idMap = new HashMap();
    private HashMap reverseIdMap = new HashMap();
    private HashMap descriptorIdMap = new HashMap();
    private ArrayList listeners = new ArrayList();
    private ServerCommunicationInterface asServer;
    private ServerStatInterface asStat;
    private Parser agentConfig;
    private Filter agentFilter;
    private JmxAgent comAgent;

    public ResourceManager(String string, String string2, String string3, JmxAgent jmxAgent, Parser parser, ServerCommunicationInterface serverCommunicationInterface, ServerStatInterface serverStatInterface) throws Exception {
        this.asServer = serverCommunicationInterface;
        this.asStat = serverStatInterface;
        this.comAgent = jmxAgent;
        this.agentConfig = parser;
        this.StatsAttName = parser.getStatsName();
        Properties properties = new Properties();
        properties.put("HOST", string);
        properties.put("PORT", string2);
        this.connectJMXAgent(properties);
        this.agentFilter = new Filter(parser, this);
    }

    public ObjectName createObjectName(String string) throws MalformedObjectNameException {
        ObjectName objectName = null;
        objectName = new ObjectName(string);
        return objectName;
    }

    public void populateRootElements(ArrayList arrayList) throws MalformedObjectNameException, ParserException {
        TreeSet<String> treeSet = new TreeSet<String>();
        String string = "*:*";
        Set set = this.asServer.executeQuery(string);
        ObjectName objectName = this.createObjectName(string);
        set = this.agentFilter.filter(set, objectName, "", string, null);
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            JmxElement jmxElement = (JmxElement)iterator.next();
            String string2 = jmxElement.getName();
            if (treeSet.contains(string2)) continue;
            treeSet.add(string2);
            if (this.containsObject(this.idMap, jmxElement)) continue;
            String string3 = jmxElement.getType() == 2 ? new String("M" + this.counter++) : new String("" + this.counter++);
            this.idMap.put(string3, jmxElement);
            this.reverseIdMap.put(jmxElement, string3);
            this.addResult(arrayList, string3, "", string2, jmxElement.getDescription());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectJMXAgent(Properties properties) throws Exception {
        Object object = new Object();
        ConnectThread connectThread = new ConnectThread(object, properties);
        Object object2 = object;
        synchronized (object2) {
            connectThread.start();
            try {
                object.wait(20000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (!connectThread.success) {
            if (connectThread.ex == null) {
                throw new ResourceException("Connection Timeout : Unable to establish connection to JBoss Server");
            }
            throw connectThread.ex;
        }
    }

    public void addObservation(ArrayList arrayList, String string, String string2) {
        if (string2.equals("true")) {
            string2 = "1";
        } else if (string2.equals("false")) {
            string2 = "0";
        }
        try {
            Double.parseDouble(string2);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("<ContiguousObservation memberDescriptor=\"");
            stringBuffer.append(string);
            stringBuffer.append("\" time=\"");
            stringBuffer.append(System.currentTimeMillis());
            stringBuffer.append("\" value=\"");
            stringBuffer.append(string2);
            stringBuffer.append("\" />\n");
            arrayList.add(stringBuffer.toString());
            return;
        }
        catch (NumberFormatException numberFormatException) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("<TextObservation memberDescriptor=\"");
            stringBuffer.append(string);
            stringBuffer.append("\" time=\"");
            stringBuffer.append(System.currentTimeMillis());
            stringBuffer.append("\" value=\"");
            stringBuffer.append(string2);
            stringBuffer.append("\" />\n");
            arrayList.add(stringBuffer.toString());
            return;
        }
    }

    public void addCounterResult(ArrayList arrayList, String string, String string2, String string3, String string4) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<CounterDescriptor ");
        if (string2 != "") {
            stringBuffer.append("parent=\"" + string2 + "\" ");
        }
        stringBuffer.append("id=\"" + string + "\" ");
        stringBuffer.append("name=\"" + string3 + "\" ");
        if (string4 != "") {
            stringBuffer.append(" >\n<description>" + string4 + "</description>\n</CounterDescriptor>\n");
        } else {
            stringBuffer.append(" />\n");
        }
        arrayList.add(stringBuffer.toString());
    }

    public void addResult(ArrayList arrayList, String string, String string2, String string3, String string4) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<Descriptor ");
        if (string2 != "") {
            stringBuffer.append("parent=\"" + string2 + "\" ");
        }
        stringBuffer.append("id=\"" + string + "\" ");
        stringBuffer.append("name=\"" + string3 + "\" ");
        if (string4 != "") {
            stringBuffer.append(" >\n<description>" + string4 + "</description>\n</Descriptor>\n");
        } else {
            stringBuffer.append(" />\n");
        }
        arrayList.add(stringBuffer.toString());
    }

    public String formatAttribute(MBeanAttributeInfo mBeanAttributeInfo) {
        return "A: " + mBeanAttributeInfo.getName() + " (" + mBeanAttributeInfo.getType() + ")";
    }

    public String formatOperation(MBeanOperationInfo mBeanOperationInfo) {
        return "O: " + mBeanOperationInfo.getName() + " (" + mBeanOperationInfo.getReturnType() + ")";
    }

    public void addOperations(ArrayList arrayList, String string, MBeanOperationInfo[] mBeanOperationInfoArray, ObjectName objectName) {
        Arrays.sort(mBeanOperationInfoArray, new SetComparator());
        int n = 0;
        while (n < mBeanOperationInfoArray.length) {
            JmxElement jmxElement = new JmxElement(7, mBeanOperationInfoArray[n], string, objectName, this.formatOperation(mBeanOperationInfoArray[n]), "", null);
            if (!this.containsObject(this.idMap, jmxElement)) {
                String string2 = new String("C" + this.counter++);
                this.idMap.put(string2, jmxElement);
                this.reverseIdMap.put(jmxElement, string2);
                this.addCounterResult(arrayList, string2, string, jmxElement.getName(), jmxElement.getDescription());
            }
            ++n;
        }
    }

    public void addAttributes(ArrayList arrayList, String string, MBeanAttributeInfo[] mBeanAttributeInfoArray, ObjectName objectName) {
        Arrays.sort(mBeanAttributeInfoArray, new SetComparator());
        int n = 0;
        while (n < mBeanAttributeInfoArray.length) {
            JmxElement jmxElement = new JmxElement(6, mBeanAttributeInfoArray[n], string, objectName, this.formatAttribute(mBeanAttributeInfoArray[n]), "", null);
            if (!this.containsObject(this.idMap, jmxElement)) {
                String string2 = mBeanAttributeInfoArray[n].getName().equals(this.StatsAttName) ? new String("" + this.counter++) : new String("C" + this.counter++);
                this.idMap.put(string2, jmxElement);
                this.reverseIdMap.put(jmxElement, string2);
                if (mBeanAttributeInfoArray[n].getName().equals(this.StatsAttName)) {
                    this.addResult(arrayList, string2, string, jmxElement.getName(), jmxElement.getDescription());
                } else {
                    this.addCounterResult(arrayList, string2, string, jmxElement.getName(), jmxElement.getDescription());
                }
            }
            ++n;
        }
    }

    public boolean containsObject(HashMap hashMap, JmxElement jmxElement) {
        Object[] objectArray = hashMap.values().toArray();
        int n = 0;
        while (n < objectArray.length) {
            JmxElement jmxElement2 = (JmxElement)objectArray[n];
            if (jmxElement2.getName().equals(jmxElement.getName()) && jmxElement2.getType() == jmxElement.getType() && jmxElement2.getObjectData().toString().equals(jmxElement.getObjectData().toString()) && jmxElement2.getParentID().equals(jmxElement.getParentID())) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public void getDomainChildren(ArrayList arrayList, String string, JmxElement jmxElement) throws MalformedObjectNameException, ParserException {
        TreeSet<String> treeSet = new TreeSet<String>();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("*:*");
        Set set = this.asServer.executeQuery(stringBuffer.toString());
        ObjectName objectName = this.createObjectName(stringBuffer.toString());
        set = this.agentFilter.filter(set, objectName, string, stringBuffer.toString(), jmxElement.getParentFilter());
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            JmxElement jmxElement2 = (JmxElement)iterator.next();
            String string2 = jmxElement2.getName();
            if (treeSet.contains(string2)) continue;
            treeSet.add(string2);
            if (this.containsObject(this.idMap, jmxElement2)) continue;
            String string3 = new String("" + this.counter++);
            this.idMap.put(string3, jmxElement2);
            this.reverseIdMap.put(jmxElement2, string3);
            this.addResult(arrayList, string3, string, string2, jmxElement2.getDescription());
        }
    }

    public void addMBeanChildren(ArrayList arrayList, String string, ObjectName objectName, JmxElement jmxElement) throws Exception {
        String string2 = objectName.getCanonicalName();
        MBeanInfo mBeanInfo = this.asServer.getMBeanInfo(objectName);
        MBeanOperationInfo[] mBeanOperationInfoArray = mBeanInfo.getOperations();
        MBeanAttributeInfo[] mBeanAttributeInfoArray = mBeanInfo.getAttributes();
        this.addAttributes(arrayList, string, mBeanAttributeInfoArray, objectName);
        this.addOperations(arrayList, string, mBeanOperationInfoArray, objectName);
    }

    public void getAttributeChildren(ArrayList arrayList, String string, JmxElement jmxElement) throws Exception {
        MBeanAttributeInfo mBeanAttributeInfo = (MBeanAttributeInfo)jmxElement.getObjectData();
        if (mBeanAttributeInfo == null) {
            return;
        }
        if (!mBeanAttributeInfo.getName().equals(this.StatsAttName)) {
            return;
        }
        ObjectName objectName = jmxElement.getMbeanObjectName();
        Object object = this.asStat.getConfigStats(objectName);
        Object[] objectArray = this.asStat.getStatistics(object);
        if (objectArray != null) {
            int n = 0;
            while (n < objectArray.length) {
                String string2;
                String string3 = this.asStat.getStatisticName(objectArray[n]);
                JmxElement jmxElement2 = new JmxElement(8, new Integer(n), string, objectName, string3, string2 = this.asStat.getStatisticDescription(objectArray[n]), null);
                if (!this.containsObject(this.idMap, jmxElement2)) {
                    String string4 = new String("C" + this.counter++);
                    this.idMap.put(string4, jmxElement2);
                    this.reverseIdMap.put(jmxElement2, string4);
                    this.addCounterResult(arrayList, string4, string, jmxElement2.getName(), string2);
                }
                ++n;
            }
        } else {
            System.out.println("Statistical Data Object contains no DataMembers");
        }
    }

    public void getPropertyChildren(ArrayList arrayList, String string, JmxElement jmxElement) throws MalformedObjectNameException, ParserException {
        ArrayList<String> arrayList2 = new ArrayList<String>();
        Set set = null;
        String string2 = (String)jmxElement.getObjectData();
        Set set2 = this.asServer.executeQuery(string2);
        set = this.agentFilter.filter(set2, this.createObjectName(string2), string, (String)jmxElement.getObjectData(), jmxElement.getParentFilter());
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            JmxElement jmxElement2 = (JmxElement)iterator.next();
            String string3 = jmxElement2.getName();
            if (arrayList2.contains(string3)) continue;
            arrayList2.add(string3);
            if (this.containsObject(this.idMap, jmxElement2)) continue;
            String string4 = jmxElement2.getType() == 2 ? new String("M" + this.counter++) : new String("" + this.counter++);
            this.idMap.put(string4, jmxElement2);
            this.reverseIdMap.put(jmxElement2, string4);
            this.addResult(arrayList, string4, string, string3, jmxElement2.getDescription());
        }
    }

    public String[] getAllChildren(String[] stringArray) {
        ArrayList arrayList = new ArrayList();
        int n = 0;
        while (n < stringArray.length) {
            this.getChildren(arrayList, stringArray[n]);
            ++n;
        }
        String[] stringArray2 = new String[arrayList.size()];
        int n2 = 0;
        while (n2 < arrayList.size()) {
            stringArray2[n2] = (String)arrayList.get(n2);
            ++n2;
        }
        return stringArray2;
    }

    public ArrayList getAllResults(ArrayList arrayList) {
        ArrayList arrayList2 = new ArrayList();
        String string = null;
        Object[] objectArray = null;
        ArrayList<String> arrayList3 = new ArrayList<String>();
        ArrayList<MBeanAttributeInfo> arrayList4 = new ArrayList<MBeanAttributeInfo>();
        int n = 0;
        while (n < arrayList.size()) {
            JmxElement jmxElement;
            string = (String)arrayList.get(n);
            JmxElement jmxElement2 = (JmxElement)this.idMap.get(string);
            if (jmxElement2 != null && (jmxElement = (JmxElement)this.idMap.get(jmxElement2.getParentID())) != null) {
                Serializable serializable;
                if (jmxElement2.getType() == 6) {
                    serializable = (MBeanAttributeInfo)jmxElement2.getObjectData();
                    this.invokeAttribute(arrayList2, (MBeanAttributeInfo)serializable, jmxElement2.getMbeanObjectName(), string);
                } else if (jmxElement2.getType() == 7) {
                    serializable = (MBeanOperationInfo)jmxElement2.getObjectData();
                    this.invokeOperation(arrayList2, (MBeanOperationInfo)serializable, jmxElement2.getMbeanObjectName(), string);
                    ++n;
                } else if (jmxElement2.getType() == 8 && !arrayList3.contains(string)) {
                    serializable = jmxElement.getMbeanObjectName();
                    arrayList3.add(string);
                    arrayList4.add((MBeanAttributeInfo)serializable);
                }
            }
            ++n;
        }
        int n2 = 0;
        int n3 = 0;
        if (arrayList3.size() != 0) {
            objectArray = arrayList4.toArray();
            if (arrayList3 != null) {
                ArrayList arrayList5 = this.asStat.getStatsArray(objectArray);
                n3 = arrayList3.size();
                while (n2 < n3) {
                    string = (String)arrayList3.get(n2);
                    JmxElement jmxElement = (JmxElement)this.idMap.get(string);
                    Integer n4 = (Integer)jmxElement.getObjectData();
                    int n5 = n4;
                    this.invokeStatCounter(arrayList2, string, arrayList5.get(n2), n5);
                    ++n2;
                }
            }
        }
        return arrayList2;
    }

    public void getChildren(ArrayList arrayList, String string) {
        try {
            if (string.equals("")) {
                this.populateRootElements(arrayList);
            } else {
                JmxElement jmxElement = (JmxElement)this.idMap.get(string);
                switch (jmxElement.getType()) {
                    case 6: {
                        this.getAttributeChildren(arrayList, string, jmxElement);
                        break;
                    }
                    case 3: {
                        this.getDomainChildren(arrayList, string, jmxElement);
                        break;
                    }
                    case 1: {
                        this.getPropertyChildren(arrayList, string, jmxElement);
                        break;
                    }
                    case 2: {
                        this.addMBeanChildren(arrayList, string, jmxElement.getMbeanObjectName(), jmxElement);
                    }
                }
            }
        }
        catch (Exception exception) {
            System.out.println("Exception while attemping to get counter children - " + exception.getMessage());
            exception.printStackTrace();
            this.comAgent.sendCBEMessage("Exception while attemping to get counter children - " + exception.getMessage(), "50");
            return;
        }
    }

    public void invokeAttribute(ArrayList arrayList, MBeanAttributeInfo mBeanAttributeInfo, ObjectName objectName, String string) {
        Object object;
        String string2 = mBeanAttributeInfo.getName();
        if (string2.equals(this.StatsAttName)) {
            return;
        }
        try {
            object = this.asServer.getAttribute(objectName, string2);
        }
        catch (Exception exception) {
            System.out.println("Exception Invoking Attribute " + exception.getMessage());
            this.comAgent.sendCBEMessage("Error Invoking Attribute - " + exception.getMessage(), "50");
            exception.printStackTrace();
            return;
        }
        String string3 = object instanceof String ? (String)object : "" + object;
        this.addObservation(arrayList, string, string3);
    }

    public void invokeStatCounter(ArrayList arrayList, String string, Object object, int n) {
        String string2 = this.asStat.invokeStatCounter(arrayList, string, object, n);
        this.addObservation(arrayList, string, string2);
    }

    public void invokeOperation(ArrayList arrayList, MBeanOperationInfo mBeanOperationInfo, ObjectName objectName, String string) {
        Object object;
        String string2 = mBeanOperationInfo.getName();
        Object[] objectArray = new Object[]{};
        String[] stringArray = new String[]{};
        try {
            object = this.asServer.invoke(objectName, string2, objectArray, stringArray);
        }
        catch (Exception exception) {
            System.out.println("Exception Invoking Operation " + exception.getMessage());
            this.comAgent.sendCBEMessage("Error Invoking Operation - " + exception.getMessage(), "50");
            exception.printStackTrace();
            return;
        }
        String string3 = object instanceof String ? (String)object : "" + object;
        this.addObservation(arrayList, string, string3);
    }

    class ConnectThread
    extends Thread {
        Object notify;
        Properties properties;
        Exception ex = null;
        boolean success;

        public ConnectThread(Object object, Properties properties) {
            this.notify = object;
            this.properties = properties;
            this.success = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                ResourceManager.this.asServer.connect(this.properties);
                this.success = true;
            }
            catch (Exception exception) {
                System.out.println("Error connection agent... - " + exception.getMessage());
                this.ex = exception;
                ResourceManager.this.asServer = null;
                this.success = false;
            }
            Object object = this.notify;
            synchronized (object) {
                this.notify.notifyAll();
            }
        }
    }
}

