/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.internal.collection.framework;

import java.io.IOException;
import java.net.Socket;
import org.eclipse.hyades.execution.security.IConnectionHandler;
import org.eclipse.hyades.internal.collection.framework.FileClientHandlerImplExtended;
import org.eclipse.hyades.internal.execution.core.file.ISocketChannel;
import org.eclipse.hyades.internal.execution.core.file.SocketChannelFactory;

class FileConnectionHandlerExtended
implements org.eclipse.hyades.internal.execution.file.IConnectionHandler {
    private ThreadGroup workerGroup = new ThreadGroup("File Server Worker Thread Group");

    FileConnectionHandlerExtended() {
    }

    public void connectionAccepted(ISocketChannel iSocketChannel) {
        Thread thread = new Thread(this.workerGroup, this.createFileClientHandler(iSocketChannel));
        thread.setDaemon(true);
        thread.setName(iSocketChannel.toString());
        thread.start();
    }

    private Runnable createFileClientHandler(ISocketChannel iSocketChannel) {
        return new FileClientHandlerImplExtended(iSocketChannel);
    }

    static class Adapter
    implements IConnectionHandler {
        private final FileConnectionHandlerExtended handler = new FileConnectionHandlerExtended();

        Adapter() {
        }

        public void connectionAccepted(Socket socket) {
            try {
                this.handler.connectionAccepted(SocketChannelFactory.getInstance().create(socket));
            }
            catch (IOException iOException) {}
        }
    }
}

