/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.manual.runner.model.util;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.hyades.test.common.event.ExecutionEvent;
import org.eclipse.hyades.test.common.event.TypedEvent;
import org.eclipse.hyades.test.manual.runner.model.Action;
import org.eclipse.hyades.test.manual.runner.model.IActionOwner;
import org.eclipse.hyades.test.manual.runner.model.IVerdictListener;
import org.eclipse.hyades.test.manual.runner.model.Loop;
import org.eclipse.hyades.test.manual.runner.model.NamedElement;
import org.eclipse.hyades.test.manual.runner.model.Test;
import org.eclipse.hyades.test.manual.runner.model.TestCase;
import org.eclipse.hyades.test.manual.runner.model.TestInvocation;
import org.eclipse.hyades.test.manual.runner.model.TestSuite;
import org.eclipse.hyades.test.manual.runner.model.util.ModelUtil;

public class ExecutionManager
implements IVerdictListener {
    private TestInvocation lastExecuted;
    private Set testInvocations;
    private Set executed;
    private Set startedLoopHierarchyIds;
    private int currentExecutionId;
    private TestSuite rootTestSuite;

    public void dispose() {
        ModelUtil.dispose(this.rootTestSuite);
        this.lastExecuted = null;
        this.rootTestSuite = null;
        if (this.testInvocations != null) {
            this.testInvocations.clear();
        }
        if (this.executed != null) {
            this.executed.clear();
        }
        if (this.startedLoopHierarchyIds != null) {
            this.startedLoopHierarchyIds.clear();
        }
    }

    public void handleVerdict(TestInvocation testInvocation) {
        this.lastExecuted = testInvocation;
        if (testInvocation.getVerdictEvent() == null) {
            if (this.executed != null) {
                this.executed.remove(testInvocation);
            }
        } else {
            if (this.executed == null) {
                this.executed = new HashSet();
            }
            this.executed.add(testInvocation);
        }
    }

    public TestInvocation getLast() {
        return this.lastExecuted;
    }

    public void setRoot(TestSuite testSuite) {
        this.rootTestSuite = testSuite;
    }

    public TestSuite getRoot() {
        return this.rootTestSuite;
    }

    public void registerTestInvocations(Collection collection) {
        if (collection != null) {
            this.testInvocations = new HashSet(collection);
        }
    }

    public int getTestInvocationCount() {
        if (this.testInvocations == null) {
            return 0;
        }
        return this.testInvocations.size();
    }

    public Collection getExecutedTestInvocations() {
        if (this.executed == null) {
            this.executed = new HashSet();
        }
        return this.executed;
    }

    public int getExecutionCount() {
        if (this.executed == null) {
            return 0;
        }
        return this.executed.size();
    }

    public void startLoop(Loop loop) {
        if (loop == null) {
            return;
        }
        String string = ModelUtil.getHierarchyId(loop);
        if (this.startedLoopHierarchyIds == null) {
            this.startedLoopHierarchyIds = new HashSet();
        } else if (this.startedLoopHierarchyIds.contains(string)) {
            return;
        }
        this.startedLoopHierarchyIds.add(string);
        ModelUtil.getEventLogger().logTyped(loop, 0, null);
    }

    public void closeStatedLoops() {
        if (this.startedLoopHierarchyIds != null) {
            Iterator iterator = this.startedLoopHierarchyIds.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                TypedEvent typedEvent = new TypedEvent();
                typedEvent.setOwnerId(string);
                typedEvent.setType(1);
                ModelUtil.getEventLogger().log((ExecutionEvent)typedEvent);
            }
        }
    }

    public NamedElement next() {
        TestInvocation testInvocation;
        if (this.hasNext() && (testInvocation = this.getNext(this.getRoot())) != null) {
            this.currentExecutionId = testInvocation.getExecutionId();
            return testInvocation;
        }
        this.currentExecutionId = Integer.MIN_VALUE;
        return this.getRoot();
    }

    private TestInvocation getNext(IActionOwner iActionOwner) {
        if (iActionOwner != null) {
            Iterator iterator = iActionOwner.getActions().iterator();
            while (iterator.hasNext()) {
                TestInvocation testInvocation;
                Action action = (Action)iterator.next();
                if (action instanceof Loop) {
                    testInvocation = this.getNext((Loop)action);
                    if (testInvocation == null) continue;
                    return testInvocation;
                }
                if (!(action instanceof TestInvocation) || (testInvocation = (TestInvocation)action).getTest() == null) continue;
                if (testInvocation.getTest() instanceof TestSuite) {
                    TestInvocation testInvocation2 = this.getNext((TestSuite)testInvocation.getTest());
                    if (testInvocation2 == null) continue;
                    return testInvocation2;
                }
                if (testInvocation.getVerdictEvent() != null) continue;
                return testInvocation;
            }
        }
        return null;
    }

    public boolean hasNext() {
        if (this.getTestInvocationCount() == this.getExecutionCount()) {
            this.currentExecutionId = Integer.MAX_VALUE;
            return false;
        }
        return true;
    }

    public int getCurrentExecutionId() {
        return this.currentExecutionId;
    }

    public boolean isExecutable(NamedElement namedElement) {
        Test test;
        return namedElement != null && namedElement instanceof TestInvocation && (test = ((TestInvocation)namedElement).getTest()) != null && test instanceof TestCase;
    }
}

