/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.internal.util;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.eclipse.hyades.logging.adapter.AdapterException;
import org.eclipse.hyades.logging.adapter.AdapterInvalidConfig;
import org.eclipse.hyades.logging.adapter.IOutputter;
import org.eclipse.hyades.logging.adapter.outputters.CBEFileOutputter;
import org.eclipse.hyades.logging.adapter.util.Messages;
import org.eclipse.hyades.logging.events.cbe.CommonBaseEvent;

public class AdapterLogFileOutputter
extends CBEFileOutputter
implements IOutputter {
    protected void prepareFile() throws AdapterInvalidConfig {
        String pathSeparator = System.getProperty("file.separator");
        this.rawLogFileName = this.getDirectory().endsWith(pathSeparator) ? this.getDirectory() + this.getFileName() : this.getDirectory() + pathSeparator + this.getFileName();
    }

    protected void setFileWriter() throws AdapterException {
        File hglaLogFile = new File(this.rawLogFileName);
        if (hglaLogFile.exists()) {
            String fileExt = new Double(Math.random()).toString();
            int loc = this.getFileName().indexOf(".log");
            this.setFileName(this.getFileName().substring(0, loc) + fileExt.substring(1) + this.getFileName().substring(loc));
            String pathSeparator = System.getProperty("file.separator");
            this.rawLogFileName = this.getDirectory().endsWith(pathSeparator) ? this.getDirectory() + this.getFileName() : this.getDirectory() + pathSeparator + this.getFileName();
        }
        try {
            this.fw = new FileWriter(this.rawLogFileName);
        }
        catch (IOException ioe) {
            CommonBaseEvent event = this.getEventFactory().createCommonBaseEvent();
            event.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_File_Outputter_Create_ERROR_");
            event.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID(), this.rawLogFileName, ioe.getMessage()});
            event.setSeverity((short)60);
            this.log(event);
            throw new AdapterException(Messages.getString("HyadesGA_CBE_File_Outputter_Create_ERROR_", this.getUniqueID(), this.rawLogFileName, ioe.getMessage()));
        }
    }
}

