/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.execution.local.file;

import java.io.IOException;
import java.util.Iterator;
import org.eclipse.core.internal.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.hyades.execution.core.file.IFileLocation;
import org.eclipse.hyades.execution.core.file.IFileManager;
import org.eclipse.hyades.execution.core.file.IFileManagerExtended;
import org.eclipse.hyades.execution.local.file.FileLocationImpl;
import org.eclipse.hyades.internal.execution.core.file.FileServerCommandFactory;
import org.eclipse.hyades.internal.execution.core.file.IDeleteFileCommand;
import org.eclipse.hyades.internal.execution.core.file.IFileServerCommandFactory;
import org.eclipse.hyades.internal.execution.core.file.IGetFileCommand;
import org.eclipse.hyades.internal.execution.core.file.IPutFileCommand;
import org.eclipse.hyades.internal.execution.core.file.IQueryServerStatusCommand;
import org.eclipse.hyades.internal.execution.local.common.CommandElement;
import org.eclipse.hyades.internal.execution.local.common.ControlMessage;
import org.eclipse.hyades.internal.execution.local.common.ManageFileCommand;
import org.eclipse.hyades.internal.execution.local.common.ResourceLocation;
import org.eclipse.hyades.internal.execution.local.control.CommandHandler;
import org.eclipse.hyades.internal.execution.local.control.Connection;
import org.eclipse.hyades.internal.execution.local.control.Node;

class FileManagerExtendedImpl
implements IFileManagerExtended {
    private static final int DEFAULT_TIMEOUT = 60000;
    private static final NullProgressMonitor NULL_PROGRESS_MONITOR = new NullProgressMonitor();
    private final IFileServerCommandFactory factory;

    FileManagerExtendedImpl(Connection connection) {
        this.factory = FileServerCommandFactory.getInstance((IFileLocation)this.queryFileServerLocation(connection));
    }

    public void deleteFile(IFileManagerExtended.Cookie cookie) throws IOException {
        this.deleteFile(cookie, (IProgressMonitor)NULL_PROGRESS_MONITOR);
    }

    public void deleteFile(IFileManagerExtended.Cookie cookie, IProgressMonitor monitor) throws IOException {
        Assert.isNotNull((Object)cookie);
        Assert.isNotNull((Object)monitor);
        throw new UnsupportedOperationException();
    }

    public void deleteFile(IFileManagerExtended.FileIdentifierList remoteIdentifiers) throws IOException {
        this.deleteFile(remoteIdentifiers, (IProgressMonitor)NULL_PROGRESS_MONITOR);
    }

    public void deleteFile(IFileManagerExtended.FileIdentifierList remoteIdentifiers, IProgressMonitor monitor) throws IOException {
        Assert.isNotNull((Object)remoteIdentifiers);
        Assert.isNotNull((Object)monitor);
        IDeleteFileCommand command = this.factory.createDeleteFileCommand(remoteIdentifiers, monitor);
        command.execute();
        command.dispose();
    }

    public void deleteFile(String remoteName) throws IOException {
        this.deleteFile(IFileManagerExtended.FileIdentifierList.create((String)remoteName));
    }

    public void getFile(IFileManagerExtended.FileIdentifierList localIdentifiers, IFileManagerExtended.FileIdentifierList remoteIdentifiers) throws IOException {
        this.getFile(localIdentifiers, remoteIdentifiers, (IProgressMonitor)NULL_PROGRESS_MONITOR);
    }

    public void getFile(IFileManagerExtended.FileIdentifierList localIdentifiers, IFileManagerExtended.FileIdentifierList remoteIdentifiers, IProgressMonitor monitor) throws IOException {
        this.getFile(localIdentifiers, remoteIdentifiers, IFileManagerExtended.Option.NONE, monitor);
    }

    public void getFile(IFileManagerExtended.FileIdentifierList localIdentifiers, IFileManagerExtended.FileIdentifierList remoteIdentifiers, IFileManagerExtended.Option[] options) throws IOException {
        this.getFile(localIdentifiers, remoteIdentifiers, options, (IProgressMonitor)NULL_PROGRESS_MONITOR);
    }

    public void getFile(IFileManagerExtended.FileIdentifierList localIdentifiers, IFileManagerExtended.FileIdentifierList remoteIdentifiers, IFileManagerExtended.Option[] options, IProgressMonitor monitor) throws IOException {
        Assert.isNotNull((Object)localIdentifiers);
        Assert.isNotNull((Object)remoteIdentifiers);
        Assert.isNotNull((Object)options);
        Assert.isNotNull((Object)monitor);
        Assert.isTrue((localIdentifiers.size() == remoteIdentifiers.size() ? 1 : 0) != 0);
        IGetFileCommand command = this.factory.createGetFileCommand(localIdentifiers, remoteIdentifiers, options, monitor);
        command.execute();
        command.dispose();
    }

    public void getFile(String localName, String remoteName) throws IOException {
        this.getFile(IFileManagerExtended.FileIdentifierList.create((String)localName), IFileManagerExtended.FileIdentifierList.create((String)remoteName));
    }

    public boolean isServerAvailable() throws IOException {
        IQueryServerStatusCommand command = this.factory.createQueryServerStatusCommand();
        command.execute();
        command.dispose();
        return command.isServerAvailable();
    }

    public IFileManagerExtended.FileIdentifierList listContent(IFileManagerExtended.FileIdentifierList remoteIdentifiers) throws IOException {
        return this.listContent(remoteIdentifiers, (IProgressMonitor)NULL_PROGRESS_MONITOR);
    }

    public IFileManagerExtended.FileIdentifierList listContent(IFileManagerExtended.FileIdentifierList remoteIdentifiers, IProgressMonitor monitor) throws IOException {
        Assert.isNotNull((Object)remoteIdentifiers);
        Assert.isNotNull((Object)monitor);
        throw new UnsupportedOperationException();
    }

    public void modifyPermission(IFileManagerExtended.FileIdentifierList remoteIdentifiers, String permissionDirective) throws IOException {
        this.modifyPermission(remoteIdentifiers, permissionDirective, (IProgressMonitor)NULL_PROGRESS_MONITOR);
    }

    public void modifyPermission(IFileManagerExtended.FileIdentifierList remoteIdentifiers, String permissionDirective, IProgressMonitor monitor) throws IOException {
        Assert.isNotNull((Object)remoteIdentifiers);
        Assert.isNotNull((Object)permissionDirective);
        Assert.isNotNull((Object)monitor);
        Assert.isTrue((permissionDirective.trim().length() > 0 ? 1 : 0) != 0);
        throw new UnsupportedOperationException();
    }

    public void putFile(IFileManagerExtended.Cookie cookie, IFileManagerExtended.FileIdentifierList localIdentifiers, IFileManagerExtended.FileIdentifierList remoteIdentifiers) throws IOException {
        this.putFile(cookie, localIdentifiers, remoteIdentifiers, IFileManagerExtended.Option.NONE);
    }

    public void putFile(IFileManagerExtended.Cookie cookie, IFileManagerExtended.FileIdentifierList localIdentifiers, IFileManagerExtended.FileIdentifierList remoteIdentifiers, IProgressMonitor monitor) throws IOException {
        this.putFile(cookie, localIdentifiers, remoteIdentifiers, IFileManagerExtended.Option.NONE, monitor);
    }

    public void putFile(IFileManagerExtended.Cookie cookie, IFileManagerExtended.FileIdentifierList localIdentifiers, IFileManagerExtended.FileIdentifierList remoteIdentifiers, IFileManagerExtended.Option[] options) throws IOException {
        this.putFile(cookie, localIdentifiers, remoteIdentifiers, options, (IProgressMonitor)NULL_PROGRESS_MONITOR);
    }

    public void putFile(IFileManagerExtended.Cookie cookie, IFileManagerExtended.FileIdentifierList localIdentifiers, IFileManagerExtended.FileIdentifierList remoteIdentifiers, IFileManagerExtended.Option[] options, IProgressMonitor monitor) throws IOException {
        Assert.isNotNull((Object)cookie);
        Assert.isNotNull((Object)localIdentifiers);
        Assert.isNotNull((Object)remoteIdentifiers);
        Assert.isNotNull((Object)options);
        Assert.isNotNull((Object)monitor);
        Assert.isTrue((localIdentifiers.size() == remoteIdentifiers.size() ? 1 : 0) != 0);
        IPutFileCommand command = this.factory.createPutFileCommand(cookie, localIdentifiers, remoteIdentifiers, options, monitor);
        command.execute();
        command.dispose();
    }

    public void putFile(IFileManagerExtended.FileIdentifierList localIdentifiers, IFileManagerExtended.FileIdentifierList remoteIdentifiers) throws IOException {
        this.putFile(localIdentifiers, remoteIdentifiers, (IProgressMonitor)NULL_PROGRESS_MONITOR);
    }

    public void putFile(IFileManagerExtended.FileIdentifierList localIdentifiers, IFileManagerExtended.FileIdentifierList remoteIdentifiers, IProgressMonitor monitor) throws IOException {
        this.putFile(localIdentifiers, remoteIdentifiers, IFileManagerExtended.Option.NONE, monitor);
    }

    public void putFile(IFileManagerExtended.FileIdentifierList localIdentifiers, IFileManagerExtended.FileIdentifierList remoteIdentifiers, IFileManagerExtended.Option[] options) throws IOException {
        this.putFile(localIdentifiers, remoteIdentifiers, options, (IProgressMonitor)NULL_PROGRESS_MONITOR);
    }

    public void putFile(IFileManagerExtended.FileIdentifierList localIdentifiers, IFileManagerExtended.FileIdentifierList remoteIdentifiers, IFileManagerExtended.Option[] options, IProgressMonitor monitor) throws IOException {
        this.putFile(IFileManagerExtended.Cookie.NONE, localIdentifiers, remoteIdentifiers, options, monitor);
    }

    public void putFile(String localName, String remoteName) throws IOException {
        this.putFile(IFileManagerExtended.FileIdentifierList.create((String)localName), IFileManagerExtended.FileIdentifierList.create((String)remoteName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IFileLocation queryFileServerLocation(Connection connection) {
        ManageFileCommand command = new ManageFileCommand();
        command.setOperation(2L);
        command.setFilename("");
        ControlMessage message = new ControlMessage();
        message.appendCommand(command);
        final FileLocationImpl result = new FileLocationImpl();
        final Object lock = new Object();
        try {
            Object object = lock;
            synchronized (object) {
                connection.sendMessage(message, new CommandHandler(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void incommingCommand(Node node, CommandElement command) {
                        if (command.getTag() == 112L) {
                            ResourceLocation location = (ResourceLocation)command;
                            result.setInetAddress(node.getInetAddress());
                            result.setPort(location.getPort());
                            result.setJobKey(location.getJobKey());
                            Object object = lock;
                            synchronized (object) {
                                lock.notify();
                            }
                        }
                    }
                });
                lock.wait(60000L);
            }
        }
        catch (IOException e) {
            return null;
        }
        catch (InterruptedException e) {
            return null;
        }
        return result;
    }

    static class Adapter
    implements IFileManagerExtended {
        private final IFileManager fileManager;

        Adapter(IFileManager fileManager) {
            this.fileManager = fileManager;
        }

        public void deleteFile(IFileManagerExtended.Cookie cookie, IProgressMonitor monitor) throws IOException {
            throw new UnsupportedOperationException();
        }

        public void deleteFile(IFileManagerExtended.FileIdentifierList remoteIdentifiers) throws IOException {
            Iterator identifiers = remoteIdentifiers.iterator();
            while (identifiers.hasNext()) {
                String remoteFileName = (String)identifiers.next();
                this.deleteFile(remoteFileName);
            }
        }

        public void deleteFile(IFileManagerExtended.FileIdentifierList remoteIdentifiers, IProgressMonitor monitor) throws IOException {
            throw new UnsupportedOperationException();
        }

        public void deleteFile(IFileManagerExtended.Cookie cookie) throws IOException {
            throw new UnsupportedOperationException();
        }

        public void getFile(IFileManagerExtended.FileIdentifierList localIdentifiers, IFileManagerExtended.FileIdentifierList remoteIdentifiers) throws IOException {
            Iterator localIdentifier = localIdentifiers.iterator();
            Iterator remoteIdentifier = remoteIdentifiers.iterator();
            while (localIdentifier.hasNext()) {
                String localFileName = (String)localIdentifier.next();
                String remoteFileName = (String)remoteIdentifier.next();
                this.getFile(localFileName, remoteFileName);
            }
        }

        public void getFile(IFileManagerExtended.FileIdentifierList localIdentifiers, IFileManagerExtended.FileIdentifierList remoteIdentifiers, IFileManagerExtended.Option[] options) throws IOException {
            throw new UnsupportedOperationException();
        }

        public void getFile(IFileManagerExtended.FileIdentifierList localIdentifiers, IFileManagerExtended.FileIdentifierList remoteIdentifiers, IFileManagerExtended.Option[] options, IProgressMonitor monitor) throws IOException {
            throw new UnsupportedOperationException();
        }

        public void getFile(IFileManagerExtended.FileIdentifierList localIdentifiers, IFileManagerExtended.FileIdentifierList remoteIdentifiers, IProgressMonitor monitor) throws IOException {
            throw new UnsupportedOperationException();
        }

        public boolean isServerAvailable() throws IOException {
            return true;
        }

        public IFileManagerExtended.FileIdentifierList listContent(IFileManagerExtended.FileIdentifierList remoteIdentifiers) throws IOException {
            throw new UnsupportedOperationException();
        }

        public IFileManagerExtended.FileIdentifierList listContent(IFileManagerExtended.FileIdentifierList remoteIdentifiers, IProgressMonitor monitor) throws IOException {
            throw new UnsupportedOperationException();
        }

        public void modifyPermission(IFileManagerExtended.FileIdentifierList remoteIdentifiers, String permissionDirective) throws IOException {
            throw new UnsupportedOperationException();
        }

        public void modifyPermission(IFileManagerExtended.FileIdentifierList remoteIdentifiers, String permissionDirective, IProgressMonitor monitor) throws IOException {
            throw new UnsupportedOperationException();
        }

        public void putFile(IFileManagerExtended.Cookie cookie, IFileManagerExtended.FileIdentifierList localIdentifiers, IFileManagerExtended.FileIdentifierList remoteIdentifiers) throws IOException {
            throw new UnsupportedOperationException();
        }

        public void putFile(IFileManagerExtended.Cookie cookie, IFileManagerExtended.FileIdentifierList localIdentifiers, IFileManagerExtended.FileIdentifierList remoteIdentifiers, IFileManagerExtended.Option[] options) throws IOException {
            throw new UnsupportedOperationException();
        }

        public void putFile(IFileManagerExtended.Cookie cookie, IFileManagerExtended.FileIdentifierList localIdentifiers, IFileManagerExtended.FileIdentifierList remoteIdentifiers, IFileManagerExtended.Option[] options, IProgressMonitor monitor) throws IOException {
            throw new UnsupportedOperationException();
        }

        public void putFile(IFileManagerExtended.Cookie cookie, IFileManagerExtended.FileIdentifierList localIdentifiers, IFileManagerExtended.FileIdentifierList remoteIdentifiers, IProgressMonitor monitor) throws IOException {
            throw new UnsupportedOperationException();
        }

        public void putFile(IFileManagerExtended.FileIdentifierList localIdentifiers, IFileManagerExtended.FileIdentifierList remoteIdentifiers) throws IOException {
            Iterator localIdentifier = localIdentifiers.iterator();
            Iterator remoteIdentifier = remoteIdentifiers.iterator();
            while (localIdentifier.hasNext()) {
                String localFileName = (String)localIdentifier.next();
                String remoteFileName = (String)remoteIdentifier.next();
                this.putFile(localFileName, remoteFileName);
            }
        }

        public void putFile(IFileManagerExtended.FileIdentifierList localIdentifiers, IFileManagerExtended.FileIdentifierList remoteIdentifiers, IFileManagerExtended.Option[] options) throws IOException {
            throw new UnsupportedOperationException();
        }

        public void putFile(IFileManagerExtended.FileIdentifierList localIdentifiers, IFileManagerExtended.FileIdentifierList remoteIdentifiers, IFileManagerExtended.Option[] options, IProgressMonitor monitor) throws IOException {
            throw new UnsupportedOperationException();
        }

        public void putFile(IFileManagerExtended.FileIdentifierList localIdentifiers, IFileManagerExtended.FileIdentifierList remoteIdentifiers, IProgressMonitor monitor) throws IOException {
            throw new UnsupportedOperationException();
        }

        public void getFile(String localName, String remoteName) throws IOException {
            this.fileManager.getFile(localName, remoteName);
        }

        public void putFile(String localName, String remoteName) throws IOException {
            this.fileManager.putFile(localName, remoteName);
        }

        public void deleteFile(String remoteFileName) throws IOException {
            this.fileManager.deleteFile(remoteFileName);
        }
    }
}

