/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.execution.core.impl;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.hyades.execution.core.ExecutionComponentStateChangeEvent;
import org.eclipse.hyades.execution.core.IControlMessage;
import org.eclipse.hyades.execution.core.IExecutionComponent;
import org.eclipse.hyades.execution.core.IExecutionComponentStateChangeListener;
import org.eclipse.hyades.execution.core.INode;
import org.eclipse.hyades.execution.core.MessageDeliveryException;
import org.eclipse.hyades.execution.core.MessageProcessingException;

public abstract class ExecutionComponentImpl
implements IExecutionComponent {
    private static final String VERSION = "1.0";
    protected String name;
    protected String id;
    protected String type;
    protected String version;
    protected int state;
    protected INode node;
    protected Vector stateChangeListeners = new Vector();
    protected ArrayList children = new ArrayList();
    protected IExecutionComponent parent;

    public void init() {
        this.version = VERSION;
        this.state = 1;
    }

    public String getName() {
        return this.name;
    }

    public String getId() {
        return this.id;
    }

    public String getType() {
        return this.type;
    }

    public String getVersion() {
        return this.version;
    }

    public IExecutionComponent getParent() {
        return this.parent;
    }

    public void setParent(IExecutionComponent parent) {
        this.parent = parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IExecutionComponent[] getChildren() {
        ArrayList arrayList = this.children;
        synchronized (arrayList) {
            IExecutionComponent[] array = new IExecutionComponent[this.children.size()];
            Iterator iter = this.children.iterator();
            int i = 0;
            while (iter.hasNext()) {
                array[i] = (IExecutionComponent)iter.next();
                ++i;
            }
            return array;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IExecutionComponent getChildById(String id) {
        ArrayList arrayList = this.children;
        synchronized (arrayList) {
            Iterator iter = this.children.iterator();
            while (iter.hasNext()) {
                IExecutionComponent current = (IExecutionComponent)iter.next();
                if (!current.getId().equals(id)) continue;
                return current;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IExecutionComponent getChildByName(String name) {
        ArrayList arrayList = this.children;
        synchronized (arrayList) {
            Iterator iter = this.children.iterator();
            while (iter.hasNext()) {
                IExecutionComponent current = (IExecutionComponent)iter.next();
                if (!current.getName().equals(name)) continue;
                return current;
            }
        }
        return null;
    }

    public void addChild(IExecutionComponent child) {
        this.children.add(child);
        child.setParent(this);
    }

    public INode getNode() {
        return this.node;
    }

    public int getState() {
        return this.state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addExecutionComponentStateChangeListener(IExecutionComponentStateChangeListener listener) {
        Vector vector = this.stateChangeListeners;
        synchronized (vector) {
            this.stateChangeListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeExecutionComponentStateChangeListener(IExecutionComponentStateChangeListener listener) {
        Vector vector = this.stateChangeListeners;
        synchronized (vector) {
            this.stateChangeListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireStateChangeEvent(ExecutionComponentStateChangeEvent event) {
        Vector vector = this.stateChangeListeners;
        synchronized (vector) {
            this.state = event.getState();
            Enumeration e = this.stateChangeListeners.elements();
            while (e.hasMoreElements()) {
                IExecutionComponentStateChangeListener listener = (IExecutionComponentStateChangeListener)e.nextElement();
                listener.stateChanged(event);
            }
            if (this.state == 4) {
                this.stateChangeListeners.clear();
            }
        }
    }

    public void handleMessage(IControlMessage message) throws MessageProcessingException {
        throw new MessageProcessingException("No handler for this message");
    }

    public void sendMessage(IControlMessage message) throws MessageDeliveryException {
        throw new MessageDeliveryException("Impl class does not send messages.  This must be handled by the stubs/skeletons");
    }

    public void removeChild(IExecutionComponent child) {
        this.children.remove(child);
    }
}

