/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.execution.core.timer;

import java.io.PrintStream;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Stack;
import org.eclipse.hyades.execution.core.timer.IPerformanceTimer;

public class PerformanceTimer
implements IPerformanceTimer {
    private static final HashMap timers = new HashMap(5);
    private static final String UNNAMED = "Unnamed";
    private final String identity;
    private long size;
    private long previousSize;
    private Stack starts;
    private Stack names;
    private Stack sizes;
    private Stack counts;
    private LinkedList stops;
    private final PrintStream stream;

    public static synchronized IPerformanceTimer getInstance(String name) {
        return PerformanceTimer.getInstance(name, System.out);
    }

    public static synchronized IPerformanceTimer getInstance(String name, PrintStream stream) {
        PerformanceTimer timer = (PerformanceTimer)timers.get(name);
        if (timer == null) {
            timer = new PerformanceTimer(name, stream);
            timers.put(name, timer);
        }
        return timer;
    }

    private PerformanceTimer(String identity, PrintStream stream) {
        this.identity = identity;
        this.stream = stream;
        this.reset();
    }

    private long consumeCount() {
        return (Long)this.counts.pop();
    }

    private long consumeElapsed() {
        long stop = (Long)this.stops.removeFirst();
        long start = (Long)this.starts.pop();
        return stop - start;
    }

    private String consumeName() {
        return (String)this.names.pop();
    }

    private long deriveElasped(Long start, Long stop) {
        return stop - start;
    }

    public void elapsed() {
        String name = this.consumeName();
        long elapsed = this.consumeElapsed();
        long count = this.consumeCount();
        this.stream.print("<Performance Timer " + this.identity + "> " + name + " execution is measured at " + elapsed + "ms ");
        if (count > 0L) {
            long average = elapsed / count;
            this.stream.print("(" + average + "ms on average)");
        }
        this.stream.println();
    }

    private Long getTimestamp() {
        return new Long(System.currentTimeMillis());
    }

    public void reset() {
        this.names = new Stack();
        this.starts = new Stack();
        this.stops = new LinkedList();
        this.sizes = new Stack();
        this.counts = new Stack();
        this.size = 0L;
        this.previousSize = 0L;
    }

    public void start() {
        this.start(UNNAMED);
    }

    public void start(String name) {
        this.starts.push(this.getTimestamp());
        this.names.push((this.names.size() > 0 ? (String)this.names.peek() + "::" : "") + name);
        this.sizes.push(new Long(this.size));
        this.size = 0L;
    }

    public void stop() {
        this.stops.addLast(this.getTimestamp());
        this.previousSize = this.size;
        this.size = (Long)this.sizes.pop() + 1L;
        this.counts.push(new Long(this.previousSize));
    }
}

