/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.parsers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.hyades.logging.adapter.AdapterException;
import org.eclipse.hyades.logging.adapter.IParser;
import org.eclipse.hyades.logging.adapter.parsers.DirectedGraphImpl;
import org.eclipse.hyades.logging.adapter.parsers.IStatement;
import org.eclipse.hyades.logging.adapter.parsers.Parser;
import org.eclipse.hyades.logging.adapter.parsers.PreparationException;
import org.eclipse.hyades.logging.adapter.parsers.StatementException;
import org.eclipse.hyades.logging.adapter.parsers.SubstituteStatement;
import org.eclipse.hyades.logging.adapter.util.Messages;
import org.eclipse.hyades.logging.events.cbe.CommonBaseEvent;
import org.eclipse.hyades.logging.events.cbe.ExtendedDataElement;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class AttributeStatement
implements IStatement {
    private IParser parser;
    List substitutions;
    private String name;
    private String defaultValue;
    private List defaultValueList = new ArrayList(1);
    private boolean usePreviousMatchSubstitutionAsDefault = false;
    private boolean isRequiredByParent = false;
    private List resultList = new ArrayList(1);

    public AttributeStatement() {
    }

    public AttributeStatement(IParser parser) {
        this.parser = parser;
    }

    public void prepare(Element node, String path) throws PreparationException {
        this.name = path == null ? node.getAttribute(Messages.getString("HyadesGANameAttributeName")) : path + "." + node.getAttribute(Messages.getString("HyadesGANameAttributeName"));
        String index = node.getAttribute(Messages.getString("HyadesGAIndexAttributeName"));
        if (index != null && !index.equals("")) {
            this.name = this.name + "[" + index + "]";
        }
        this.defaultValue = node.getAttribute(Messages.getString("HyadesGAdefaultValueAttributeName"));
        if (this.defaultValue == null || this.defaultValue.equals("")) {
            this.defaultValue = null;
        } else {
            this.defaultValueList.add(new DirectedGraphImpl(this.name, (Object)this.defaultValue));
        }
        String previous = node.getAttribute(Messages.getString("HyadesGAUsePreviousMatchSubstitutionAsDefault"));
        this.usePreviousMatchSubstitutionAsDefault = previous != null && !previous.equals("") && !previous.equals("false");
        String isRequired = node.getAttribute(Messages.getString("HyadesGAisRequiredByParentAttributeName"));
        this.isRequiredByParent = isRequired != null && isRequired.equals("true");
        NodeList children = node.getChildNodes();
        int count = children.getLength();
        if (count > 0) {
            this.substitutions = new ArrayList();
            int i = 0;
            while (i < count) {
                block16: {
                    Element child = null;
                    try {
                        child = (Element)children.item(i);
                    }
                    catch (ClassCastException e) {
                        break block16;
                    }
                    if (child.getNodeName().endsWith(Messages.getString("HyadesGASubstitutionRuleTagName"))) {
                        SubstituteStatement statement = new SubstituteStatement(this.parser);
                        try {
                            statement.prepare(child, this.name);
                            this.substitutions.add(statement);
                        }
                        catch (PreparationException e) {
                            if (this.parser != null && this.parser instanceof Parser) {
                                CommonBaseEvent event = ((Parser)this.parser).getEventFactory().createCommonBaseEvent();
                                if (e.getDetails() != null) {
                                    event.setMsg(e.getMessage() + "  " + e.getDetails());
                                } else {
                                    event.setMsg(e.getMessage());
                                }
                                event.setSeverity((short)50);
                                ExtendedDataElement ede = ((Parser)this.parser).getEventFactory().createExtendedDataElement();
                                ede.setName("EXCEPTION DETAILS");
                                ede.setType("string");
                                if (e.getDetails() != null) {
                                    ede.setValues(new String[]{e.getDetails()});
                                } else {
                                    ede.setValues(new String[]{e.getLocalizedMessage()});
                                }
                                event.addExtendedDataElement(ede);
                                ede = ((Parser)this.parser).getEventFactory().createExtendedDataElement();
                                ede.setName("PATH");
                                ede.setType("string");
                                ede.setValues(new String[]{e.getDigraph()});
                                event.addExtendedDataElement(ede);
                                this.parser.log(event);
                            }
                            throw e;
                        }
                    }
                }
                ++i;
            }
            if (this.substitutions.isEmpty()) {
                this.substitutions = null;
            }
        }
    }

    public List run(String line, HashMap inputs) throws AdapterException, StatementException {
        if (this.substitutions != null) {
            ListIterator iter = this.substitutions.listIterator();
            SubstituteStatement statement = null;
            while (iter.hasNext()) {
                statement = (SubstituteStatement)iter.next();
                try {
                    List result = statement.run(line, inputs);
                    this.resultList.clear();
                    this.resultList.addAll(result);
                    return this.resultList;
                }
                catch (StatementException e) {
                    // empty catch block
                }
            }
            if (this.usePreviousMatchSubstitutionAsDefault && !this.resultList.isEmpty()) {
                return this.resultList;
            }
            if (!this.defaultValueList.isEmpty()) {
                return this.defaultValueList;
            }
        } else if (!this.defaultValueList.isEmpty()) {
            return this.defaultValueList;
        }
        throw StatementException.instance();
    }

    public boolean isRequiredByParent() {
        return this.isRequiredByParent;
    }

    public boolean isChildChoice() {
        return false;
    }
}

