/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.perfmon.jmxagent.parser;

import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.hyades.perfmon.jmxagent.parser.ParserException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Parser {
    Document document = null;
    Boolean verboseMbeans = null;
    Boolean strictMatching = null;
    Boolean displayEmptyFolders = null;
    String filename;

    public Parser(String string) throws ParserException {
        this.document = Parser.parseDocument(string);
        this.filename = string;
    }

    public void reParse(String string) throws ParserException {
        this.document = Parser.parseDocument(string);
        this.filename = string;
        this.verboseMbeans = null;
        this.strictMatching = null;
        this.displayEmptyFolders = null;
    }

    public void reParse() throws ParserException {
        this.document = Parser.parseDocument(this.filename);
        this.verboseMbeans = null;
        this.strictMatching = null;
        this.displayEmptyFolders = null;
    }

    public String getStatsName() {
        String string = "Stats";
        try {
            NodeList nodeList = this.document.getElementsByTagName("stats");
            Element element = (Element)nodeList.item(0);
            string = element.getAttribute("name");
        }
        catch (Exception exception) {}
        return string;
    }

    public boolean isVerboseMBeans() {
        block2: {
            if (this.verboseMbeans != null) break block2;
            try {
                NodeList nodeList = this.document.getElementsByTagName("filtertree");
                Element element = (Element)nodeList.item(0);
                String string = element.getAttribute("verbosembeans");
                this.verboseMbeans = new Boolean(string);
            }
            catch (Exception exception) {
                this.verboseMbeans = new Boolean("false");
            }
        }
        return this.verboseMbeans;
    }

    public boolean isStrictMatching() {
        block2: {
            if (this.strictMatching != null) break block2;
            try {
                NodeList nodeList = this.document.getElementsByTagName("filtertree");
                Element element = (Element)nodeList.item(0);
                String string = element.getAttribute("strictmatching");
                this.strictMatching = new Boolean(string);
            }
            catch (Exception exception) {
                this.strictMatching = new Boolean("false");
            }
        }
        return this.strictMatching;
    }

    public String getAgentName() {
        NodeList nodeList = this.document.getElementsByTagName("jmxagent");
        if (nodeList.getLength() > 0) {
            Element element = (Element)nodeList.item(0);
            return element.getAttribute("name");
        }
        return "NONE";
    }

    public ArrayList getRequiredJars() {
        NodeList nodeList = this.document.getElementsByTagName("jarsrequired");
        ArrayList<String> arrayList = new ArrayList<String>();
        if (nodeList.getLength() > 0) {
            NodeList nodeList2 = nodeList.item(0).getChildNodes();
            int n = 0;
            while (n < nodeList2.getLength()) {
                Element element;
                if (nodeList2.item(n).getNodeType() == 1 && (element = (Element)nodeList2.item(n)).getNodeName().equals("jar")) {
                    arrayList.add(element.getAttribute("name"));
                }
                ++n;
            }
        }
        return arrayList;
    }

    public ArrayList getChildFilter(String string, Element element) throws ParserException {
        System.out.println("The query is " + string);
        ArrayList<Element> arrayList = new ArrayList<Element>();
        if (element == null) {
            NodeList nodeList = this.document.getElementsByTagName("filtertree");
            Element element2 = (Element)nodeList.item(0);
            Node node = element2.getFirstChild();
            while (node != null) {
                if (node.getNodeType() == 1) {
                    arrayList.add((Element)node);
                }
                node = node.getNextSibling();
            }
            return arrayList;
        }
        NodeList nodeList = this.document.getElementsByTagName("filter");
        int n = 0;
        while (n < nodeList.getLength()) {
            if (nodeList.item(n).getNodeType() == 1) {
                Element element3 = (Element)nodeList.item(n);
                if (nodeList.item(n) == element) {
                    Node node = element3.getFirstChild();
                    while (node != null) {
                        if (node.getNodeType() == 1) {
                            arrayList.add((Element)node);
                        }
                        node = node.getNextSibling();
                    }
                    return arrayList;
                }
            }
            ++n;
        }
        return arrayList;
    }

    private static DocumentBuilder getDocumentBuilder() throws ParserException {
        DocumentBuilder documentBuilder;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setValidating(false);
        try {
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            System.out.println("Exception while creating new Document Builder : " + parserConfigurationException.getMessage());
            parserConfigurationException.printStackTrace();
            throw new ParserException(parserConfigurationException.getMessage());
        }
        return documentBuilder;
    }

    private static Document parseDocument(String string) throws ParserException {
        Document document;
        DocumentBuilder documentBuilder = Parser.getDocumentBuilder();
        try {
            document = documentBuilder.parse(string);
        }
        catch (Exception exception) {
            System.out.println("Exception while parsing XML file : " + exception.getMessage());
            exception.printStackTrace();
            throw new ParserException(exception.getMessage());
        }
        return document;
    }
}

