/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.execution.remote;

import org.eclipse.hyades.execution.core.ExecutionComponentStateException;
import org.eclipse.hyades.execution.core.IExecutableObject;
import org.eclipse.hyades.execution.core.IExecutionComponent;
import org.eclipse.hyades.execution.core.IExecutor;
import org.eclipse.hyades.execution.invocation.RemoteInvocationException;
import org.eclipse.hyades.execution.remote.ExecutorSkeleton;
import org.eclipse.hyades.internal.execution.local.common.CustomCommand;
import org.eclipse.hyades.internal.execution.remote.CustomCommandHandler;
import org.eclipse.hyades.internal.execution.remote.RemoteComponentSkeleton;

public class JavaTaskExecutorSkeleton
extends ExecutorSkeleton {
    private RemoteComponentSkeleton agent;
    private boolean isOKToStart;

    public JavaTaskExecutorSkeleton() {
    }

    public JavaTaskExecutorSkeleton(IExecutionComponent delegate, Integer id) {
        super(delegate, id);
    }

    public void setExecutableObject(IExecutableObject theExecutableObject) throws ExecutionComponentStateException {
        ((IExecutor)this.delegate).setExecutableObject(theExecutableObject);
    }

    public RemoteComponentSkeleton getAgent() {
        return this.agent;
    }

    public void init() {
        super.init();
        this.agent = new RemoteComponentSkeleton("Executor$" + this.getUniqueId(), "tester");
        this.agent.addCommandListener(new CustomCommandHandler(){

            public void handleCommand(CustomCommand command) {
                if (command.getData().equals("START")) {
                    JavaTaskExecutorSkeleton.this.setOKToStart(true);
                }
            }
        });
        try {
            this.agent.initialize();
        }
        catch (Throwable e) {
            throw new RemoteInvocationException(e);
        }
    }

    public synchronized boolean isOKToStart() {
        return this.isOKToStart;
    }

    private synchronized void setOKToStart(boolean isOK) {
        this.isOKToStart = isOK;
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForOKToStart() {
        while (!this.isOKToStart()) {
            JavaTaskExecutorSkeleton javaTaskExecutorSkeleton = this;
            synchronized (javaTaskExecutorSkeleton) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            if (this.isOKToStart()) break;
        }
    }
}

