/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.internal.execution.local.control;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.hyades.internal.execution.local.common.AuthenticationFailedCommand;
import org.eclipse.hyades.internal.execution.local.common.CommandElement;
import org.eclipse.hyades.internal.execution.local.common.Constants;
import org.eclipse.hyades.internal.execution.local.common.ControlMessage;
import org.eclipse.hyades.internal.execution.local.common.Message;
import org.eclipse.hyades.internal.execution.local.common.ServerSecurityInfoCommand;
import org.eclipse.hyades.internal.execution.local.control.CommandHandler;
import org.eclipse.hyades.internal.execution.local.control.Connection;
import org.eclipse.hyades.internal.execution.local.control.ConnectionListener;
import org.eclipse.hyades.internal.execution.local.control.ContextMapper;
import org.eclipse.hyades.internal.execution.local.control.Node;
import org.eclipse.hyades.internal.execution.local.control.NodeImpl;
import org.eclipse.hyades.internal.execution.security.AuthenticationListener;
import org.eclipse.hyades.internal.execution.security.LoginFailedException;
import org.eclipse.hyades.internal.execution.security.SecureConnectionRequiredException;
import org.eclipse.hyades.internal.execution.security.UntrustedAgentControllerException;

public class ConnectionImpl
implements Connection {
    protected Socket _socket;
    protected Node _node;
    protected int _port;
    private static long _context = 1L;
    private ContextMapper _contextMapper = null;
    private CommandHandler _cmdHandler = null;
    private boolean _isComplete = false;
    private final Vector _listeners = new Vector();
    private final Vector _authenticationlisteners = new Vector();
    private final Object _connectionLock = new Object();
    private final Object _loginLock = new Object();
    private static final Object contextLock = new Object();
    private boolean _isInitialized = false;
    private SecureConnectionRequiredException _secureConnectionRequiredException;
    private LoginFailedException _loginFailed;
    private boolean _loginPending = false;

    public void connect(Node node, int port) throws IOException, SecureConnectionRequiredException, LoginFailedException, UntrustedAgentControllerException {
        this._port = port;
        int offset = 0;
        InetAddress[] addrs = node.getAllInetAddresses();
        while (true) {
            try {
                this._socket = new Socket(addrs[offset], port);
            }
            catch (IOException e) {
                if (++offset != addrs.length) continue;
                throw e;
                if (offset < addrs.length) continue;
            }
            break;
        }
        this._node = node;
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void init() throws IOException, SecureConnectionRequiredException, LoginFailedException {
        try {
            this._socket.setSoTimeout(1000);
            this._socket.setTcpNoDelay(true);
        }
        catch (SocketException e) {
            // empty catch block
        }
        this._contextMapper = new ContextMapper();
        final ConnectionImpl connection = this;
        this._cmdHandler = new CommandHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void incommingCommand(Node node, CommandElement command) {
                long contextId = command.getContext();
                switch ((int)command.getTag()) {
                    case 4: {
                        ConnectionImpl.this._secureConnectionRequiredException = new SecureConnectionRequiredException((ServerSecurityInfoCommand)command);
                        ConnectionImpl.this.disconnect();
                        break;
                    }
                    case 2: {
                        Vector vector = ConnectionImpl.this._authenticationlisteners;
                        synchronized (vector) {
                            AuthenticationFailedCommand failedCommand = (AuthenticationFailedCommand)command;
                            if (node.getUser() != null && failedCommand.getTicket() == 0L) {
                                try {
                                    ConnectionImpl.this._loginPending = true;
                                    node.getUser().login(connection);
                                    break;
                                }
                                catch (Exception e) {
                                    // empty catch block
                                }
                            }
                            Enumeration enumeration = ConnectionImpl.this._authenticationlisteners.elements();
                            while (enumeration.hasMoreElements()) {
                                if (failedCommand.getTicket() == 0L) {
                                    ((AuthenticationListener)enumeration.nextElement()).authenticationRequired(connection);
                                    continue;
                                }
                                ((AuthenticationListener)enumeration.nextElement()).authenticationFailed(connection);
                            }
                            Object object = ConnectionImpl.this._loginLock;
                            synchronized (object) {
                                Object object2 = ConnectionImpl.this._connectionLock;
                                synchronized (object2) {
                                    ConnectionImpl.this._loginFailed = new LoginFailedException(ConnectionImpl.this.getPort());
                                    ConnectionImpl.this._loginPending = false;
                                    ConnectionImpl.this.disconnect();
                                    ConnectionImpl.this._connectionLock.notifyAll();
                                    ConnectionImpl.this._loginLock.notifyAll();
                                }
                            }
                        }
                    }
                    case 3: {
                        Vector vector = ConnectionImpl.this._authenticationlisteners;
                        synchronized (vector) {
                            Enumeration enumeration = ConnectionImpl.this._authenticationlisteners.elements();
                            while (enumeration.hasMoreElements()) {
                                ((AuthenticationListener)enumeration.nextElement()).authenticationSuccessful(connection);
                            }
                        }
                        Object object = ConnectionImpl.this._loginLock;
                        synchronized (object) {
                            Object object3 = ConnectionImpl.this._connectionLock;
                            synchronized (object3) {
                                ConnectionImpl.this._loginPending = false;
                                ConnectionImpl.this._connectionLock.notifyAll();
                                ConnectionImpl.this._loginLock.notifyAll();
                            }
                        }
                    }
                    default: {
                        CommandHandler ch = ConnectionImpl.this._contextMapper.getHandler(contextId);
                        if (ch == null) break;
                        ch.incommingCommand(ConnectionImpl.this._node, command);
                    }
                }
            }
        };
        Object object = this._connectionLock;
        synchronized (object) {
            SocketReaderThread reader = new SocketReaderThread();
            if (this._node.getUser() == null) {
                reader.setName(this._node.getName() + "_connection");
            } else {
                reader.setName(this._node.getName() + "_" + this._node.getUser().getName() + "_connection");
            }
            reader.setDaemon(true);
            reader.start();
            try {
                this._connectionLock.wait();
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            this._isInitialized = true;
            if (this._secureConnectionRequiredException != null) {
                SecureConnectionRequiredException temp = this._secureConnectionRequiredException;
                this._secureConnectionRequiredException = null;
                this._loginPending = false;
                throw temp;
            }
            Object object2 = this._loginLock;
            synchronized (object2) {
                if (this._loginPending) {
                    try {
                        this._loginLock.wait();
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
            }
            if (this._loginFailed != null) {
                LoginFailedException temp = this._loginFailed;
                this._loginFailed = null;
                this._loginPending = false;
                throw temp;
            }
            if (this._isComplete) {
                throw new IOException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessage(ControlMessage msg, CommandHandler handler) throws IOException {
        int i;
        int count = msg.getSize();
        byte[] buffer = new byte[count];
        int commandCount = msg.getCommandCount();
        Object object = contextLock;
        synchronized (object) {
            i = 0;
            while (i < commandCount) {
                msg.getCommand(i).setContext(_context++);
                ++i;
            }
        }
        i = 0;
        while (i < commandCount) {
            this._contextMapper.addContext(msg.getCommand(i).getContext(), handler);
            ++i;
        }
        msg.writeToBuffer(buffer, 0);
        OutputStream stream = this._socket.getOutputStream();
        stream.write(buffer);
        stream.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        Object object = this._connectionLock;
        synchronized (object) {
            if (!this._isComplete) {
                this._isComplete = true;
                this._connectionLock.notifyAll();
                try {
                    this._socket.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
                if (this._node instanceof NodeImpl) {
                    ((NodeImpl)this._node).setSecurityParameters(null);
                }
                Vector vector = this._listeners;
                synchronized (vector) {
                    Enumeration e = this._listeners.elements();
                    while (e.hasMoreElements()) {
                        ConnectionListener listener = (ConnectionListener)e.nextElement();
                        listener.connectionClosed(this);
                    }
                }
            }
        }
    }

    public Node getNode() {
        return this._node;
    }

    public boolean isActive() {
        if (this._isInitialized) {
            return !this._isComplete;
        }
        return false;
    }

    public int getPort() {
        return this._port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnectionListener(ConnectionListener listener) {
        Vector vector = this._listeners;
        synchronized (vector) {
            if (!this._listeners.contains(listener)) {
                this._listeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnectionListener(ConnectionListener listener) {
        Vector vector = this._listeners;
        synchronized (vector) {
            if (this._listeners.contains(listener)) {
                this._listeners.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAuthenticationListener(AuthenticationListener listener) {
        Vector vector = this._authenticationlisteners;
        synchronized (vector) {
            if (!this._authenticationlisteners.contains(listener)) {
                this._authenticationlisteners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAuthenticationListener(AuthenticationListener listener) {
        Vector vector = this._authenticationlisteners;
        synchronized (vector) {
            if (this._authenticationlisteners.contains(listener)) {
                this._authenticationlisteners.remove(listener);
            }
        }
    }

    protected int processControlMessage(byte[] buffer, int offset, int length) {
        if (this._cmdHandler != null) {
            ControlMessage msg = new ControlMessage();
            int current = -1;
            try {
                current = msg.readFromBuffer(buffer, offset);
                if (current > offset + length) {
                    return -1;
                }
            }
            catch (IndexOutOfBoundsException e) {
                return -1;
            }
            catch (Exception e) {
                return -1;
            }
            if ((long)current == msg.getLength() + (long)offset) {
                int count = msg.getCommandCount();
                int i = 0;
                while (i < count) {
                    this._cmdHandler.incommingCommand(this._node, msg.getCommand(i));
                    ++i;
                }
            }
            return current;
        }
        return -1;
    }

    static /* synthetic */ boolean access$700(ConnectionImpl x0) {
        return x0._isComplete;
    }

    static /* synthetic */ boolean access$800(ConnectionImpl x0) {
        return x0._isInitialized;
    }

    class SocketReaderThread
    extends Thread
    implements Constants {
        SocketReaderThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        public void run() {
            buffer = new byte[8096];
            masterOffset = 0;
            msgOffset = 0;
            timeoutCount = 0;
            while (!ConnectionImpl.access$700(ConnectionImpl.this)) {
                incompleteMsg = false;
                try {
                    inStream = ConnectionImpl.this._socket.getInputStream();
                    bytesRead = inStream.read(buffer, masterOffset, buffer.length - masterOffset);
                    if (bytesRead == -1) break;
                    incommingMessage = new Message();
                    while (msgOffset < bytesRead + masterOffset) {
                        block21: {
                            newOffset = 0;
                            try {
                                newOffset = incommingMessage.readFromBuffer(buffer, msgOffset);
                                if (newOffset > masterOffset + bytesRead) {
                                    if (msgOffset > 0) {
                                        masterOffset = masterOffset + bytesRead - msgOffset;
                                        i = 0;
                                        while (i < masterOffset) {
                                            buffer[i] = buffer[msgOffset + i];
                                            ++i;
                                        }
                                        msgOffset = 0;
                                    }
                                    incompleteMsg = true;
                                    break;
                                }
                            }
                            catch (IndexOutOfBoundsException e) {
                                if (msgOffset <= 0) break block21;
                                masterOffset = masterOffset + bytesRead - msgOffset;
                                i = 0;
                                ** while (i < masterOffset)
                            }
lbl-1000:
                            // 1 sources

                            {
                                buffer[i] = buffer[msgOffset + i];
                                ++i;
                                continue;
                            }
lbl36:
                            // 1 sources

                            msgOffset = 0;
                        }
                        incompleteMsg = true;
                        break;
                        catch (Exception e) {
                            System.out.println(e.toString());
                            break;
                        }
                        if (incommingMessage.getType() == 0L) continue;
                        newOffset = ConnectionImpl.this.processControlMessage(buffer, msgOffset, bytesRead + masterOffset - msgOffset);
                        if (newOffset == -1) {
                            incompleteMsg = true;
                            if (msgOffset > 0) {
                                masterOffset = masterOffset + bytesRead - msgOffset;
                                i = 0;
                                while (i < masterOffset) {
                                    buffer[i] = buffer[msgOffset + i];
                                    ++i;
                                }
                                msgOffset = 0;
                                break;
                            }
                            if (bytesRead == 0 && masterOffset == buffer.length) {
                                tmpbuffer = new byte[buffer.length * 2];
                                System.arraycopy(buffer, 0, tmpbuffer, 0, buffer.length);
                                buffer = tmpbuffer;
                            }
                            masterOffset += bytesRead;
                            break;
                        }
                        msgOffset = newOffset;
                    }
                    if (incompleteMsg) continue;
                    masterOffset = 0;
                    msgOffset = 0;
                }
                catch (InterruptedIOException e) {
                    if (timeoutCount > 6 && !ConnectionImpl.access$800(ConnectionImpl.this)) {
                        bytesRead = ConnectionImpl.access$400(ConnectionImpl.this);
                        synchronized (bytesRead) {
                            ConnectionImpl.access$400(ConnectionImpl.this).notifyAll();
                        }
                    }
                    ++timeoutCount;
                }
                catch (SocketException e) {
                    break;
                }
                catch (IOException e) {
                    break;
                }
            }
            ConnectionImpl.this.disconnect();
        }
    }
}

