/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.resources.database.internal.impl;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.emf.common.util.DelegatingEList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.hyades.loaders.util.IPagingList;
import org.eclipse.hyades.models.hierarchy.extensions.Query;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleOperand;
import org.eclipse.hyades.models.hierarchy.util.PerfUtil;
import org.eclipse.hyades.resources.database.internal.DBCollectedExceptions;
import org.eclipse.hyades.resources.database.internal.DBMap;
import org.eclipse.hyades.resources.database.internal.extensions.DBCommandFactory;
import org.eclipse.hyades.resources.database.internal.extensions.DatabaseType;
import org.eclipse.hyades.resources.database.internal.extensions.JDBCHelper;
import org.eclipse.hyades.resources.database.internal.impl.DBCommand;
import org.eclipse.hyades.resources.database.internal.impl.PagingListFactory;
import org.eclipse.hyades.resources.database.internal.impl.WeakObjectCache;

public class IndirectedList
extends DelegatingEList
implements IPagingList {
    protected DBCommandFactory factory = DBCommandFactory.INSTANCE;
    protected DBMap dbMap;
    protected DatabaseType type;
    protected WeakObjectCache cache;
    protected JDBCHelper helper;
    protected Query query;
    protected String sqlStatement;
    protected ResourceSet resourceSet;
    protected Collection notLoadedClasses;
    protected ResultSet rs;
    protected int columnPos;
    protected List currentPage;
    protected int currentIndex = -1;
    protected int currentLength = -1;
    protected int size = -1;

    protected List delegateList() {
        return this;
    }

    public IndirectedList(JDBCHelper helper, DBMap dbMap, WeakObjectCache cache, Query query, String sqlStatement, ResourceSet resourceSet, Collection notLoadedClasses, ResultSet rs, int columnPos) {
        this.helper = helper;
        this.dbMap = dbMap;
        this.cache = cache;
        this.type = helper.getDatabaseType();
        this.query = query;
        this.sqlStatement = sqlStatement;
        this.resourceSet = resourceSet;
        this.notLoadedClasses = notLoadedClasses;
        this.rs = rs;
        this.columnPos = columnPos;
    }

    private EClass getOutputElementType(SimpleOperand oe) {
        if (oe.getFeature() != null) {
            return oe.getFeature().getEContainingClass();
        }
        if (oe.getType() != null) {
            return oe.getType();
        }
        return null;
    }

    private void loadPage(int index, int length) {
        PerfUtil p = new PerfUtil("IndirectedList.loadPage() index=" + index + ", length=" + length + ", time1", true);
        try {
            this.rs.setFetchSize(500);
            if (!this.rs.absolute(index + 1)) {
                throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.delegateSize());
            }
            if (((SimpleOperand)this.query.getOutputElements().get(this.columnPos)).getFeature() != null && ((SimpleOperand)this.query.getOutputElements().get(this.columnPos)).getFeature().getEType() instanceof EDataType) {
                this.loadEDataType(index, length, (EDataType)((SimpleOperand)this.query.getOutputElements().get(this.columnPos)).getFeature().getEType());
            } else {
                this.loadEObjects(index, length);
            }
            this.currentIndex = index;
            this.currentLength = this.currentPage.size();
            p.stopAndPrintStatus("currentLength=" + this.currentLength);
        }
        catch (Exception e) {
            p.stopAndPrintStatus(e.getLocalizedMessage() + ", " + this.sqlStatement);
            throw new DBCollectedExceptions(e);
        }
    }

    private void loadEDataType(int index, int length, EDataType t) throws Exception {
        int i = 0;
        this.currentPage = new ArrayList();
        do {
            this.currentPage.add(EcoreFactory.eINSTANCE.createFromString(t, this.rs.getString(this.columnPos + 1)));
        } while (this.rs.next() && ++i < length);
    }

    private void loadEObjects(int index, int length) throws Exception {
        ArrayList<Integer> ids = new ArrayList<Integer>();
        int i = 0;
        PerfUtil p = new PerfUtil("IndirectedList.loadEObjects() index=" + index + ", length=" + ids.size() + ", time1", true);
        do {
            ++i;
            try {
                ids.add(new Integer(this.rs.getInt(this.columnPos + 1)));
            }
            catch (Exception e) {
                p.stopAndPrintStatus(e.getLocalizedMessage() + ",i=" + i);
                throw new DBCollectedExceptions(e);
            }
        } while (this.rs.next() && i < length);
        p.stopAndPrintStatus(",i=" + i);
        p.setMessageAndStart("IndirectedList.loadEObjects() index=" + index + ", length=" + ids.size() + ", time2");
        ArrayList<Object> classesAndIds = new ArrayList<Object>();
        EClass columnClass = this.getOutputElementType((SimpleOperand)this.query.getOutputElements().get(this.columnPos));
        classesAndIds.add(columnClass);
        classesAndIds.add(ids);
        DBCommand get = DBCommandFactory.INSTANCE.createGetCommand(this.helper, this.dbMap, this.helper.getDatabaseType(), classesAndIds, true, this.cache, this.notLoadedClasses, null);
        this.currentPage = (List)get.execute();
        p.stopAndPrintStatus("i=" + i + ",size=" + this.currentPage.size() + ", columnClass=" + columnClass + ", ids=" + ids);
    }

    protected void delegateAdd(int index, Object object) {
        throw new UnsupportedOperationException();
    }

    protected void delegateAdd(Object object) {
        throw new UnsupportedOperationException();
    }

    protected List delegateBasicList() {
        throw new UnsupportedOperationException();
    }

    public void clear() {
    }

    protected boolean delegateContains(Object object) {
        return this.delegateIndexOf(object) != -1;
    }

    protected boolean delegateContainsAll(Collection collection) {
        throw new UnsupportedOperationException();
    }

    protected boolean delegateEquals(Object object) {
        throw new UnsupportedOperationException();
    }

    protected Object delegateGet(int index) {
        if (index > this.delegateSize() - 1) {
            throw new IndexOutOfBoundsException("1> Index: " + index + ", Size: " + this.delegateSize() + ", CurrentIndex: " + this.currentIndex + ", CurrentLength: " + this.currentLength);
        }
        if (this.currentIndex == -1 || index < this.currentIndex || index > this.currentIndex + this.currentLength - 1) {
            this.loadPage(index, PagingListFactory.INSTANCE.getPagingSize());
        }
        if (index < this.currentIndex || index > this.currentIndex + this.currentLength - 1) {
            throw new IndexOutOfBoundsException("2> Index: " + index + ", Size: " + this.delegateSize() + ", CurrentIndex: " + this.currentIndex + ", CurrentLength: " + this.currentLength);
        }
        return this.currentPage.get(index - this.currentIndex);
    }

    protected int delegateHashCode() {
        return this.rs != null ? this.rs.hashCode() : this.hashCode();
    }

    protected int delegateIndexOf(Object object) {
        if (object == null) {
            return -1;
        }
        return this.getIndex(object, 0, false);
    }

    private int getIndex(Object object, int fromIndex, boolean last) {
        PerfUtil p = new PerfUtil("IndirectedList.getIndex() fromIndex=" + fromIndex + ", last=" + last + ", size=" + this.delegateSize(), true);
        if (this.delegateSize() == 0 || fromIndex >= this.delegateSize()) {
            p.stopAndPrintStatus("return=-1");
            return -1;
        }
        EDataType t = null;
        Object id = null;
        if (((SimpleOperand)this.query.getOutputElements().get(this.columnPos)).getFeature() != null && ((SimpleOperand)this.query.getOutputElements().get(this.columnPos)).getFeature().getEType() instanceof EDataType) {
            t = (EDataType)((SimpleOperand)this.query.getOutputElements().get(this.columnPos)).getFeature().getEType();
            id = object;
        } else {
            EObject eo = (EObject)object;
            id = this.cache.getId(eo);
        }
        if (id == null) {
            return -1;
        }
        Object val = null;
        try {
            if (last) {
                int i = fromIndex == -1 ? this.delegateSize() - 1 : fromIndex;
                this.rs.absolute(fromIndex == -1 ? -1 : fromIndex + 1);
                do {
                    if (!id.equals(val = t != null ? EcoreFactory.eINSTANCE.createFromString(t, this.rs.getString(this.columnPos + 1)) : new Integer(this.rs.getInt(this.columnPos + 1)))) continue;
                    p.stopAndPrintStatus("return=" + i);
                    return i;
                } while (this.rs.previous() && --i > -1);
            } else {
                this.rs.absolute(fromIndex + 1);
                int i = fromIndex;
                do {
                    if (!id.equals(val = t != null ? EcoreFactory.eINSTANCE.createFromString(t, this.rs.getString(this.columnPos + 1)) : new Integer(this.rs.getInt(this.columnPos + 1)))) continue;
                    p.stopAndPrintStatus("return=" + i);
                    return i;
                } while (this.rs.next() && ++i < this.delegateSize());
            }
        }
        catch (Exception e) {
            p.stopAndPrintStatus(e.getLocalizedMessage());
            throw new DBCollectedExceptions(e);
        }
        p.stopAndPrintStatus("return=-1");
        return -1;
    }

    protected boolean delegateIsEmpty() {
        return this.size() == 0;
    }

    protected Iterator delegateIterator() {
        return this.basicIterator();
    }

    protected int delegateLastIndexOf(Object object) {
        if (object == null) {
            return -1;
        }
        return this.getIndex(object, -1, true);
    }

    protected ListIterator delegateListIterator() {
        throw new UnsupportedOperationException();
    }

    protected Object delegateRemove(int index) {
        throw new UnsupportedOperationException();
    }

    protected Object delegateSet(int index, Object object) {
        throw new UnsupportedOperationException();
    }

    protected int delegateSize() {
        if (this.size == -1) {
            try {
                this.size = !this.rs.absolute(-1) ? 0 : this.rs.getRow();
            }
            catch (Exception e) {
                this.size = 0;
                throw new DBCollectedExceptions(e);
            }
        }
        return this.size;
    }

    protected Object[] delegateToArray() {
        if (this.size() == 0) {
            return new Object[0];
        }
        this.loadPage(0, this.size());
        return this.currentPage.toArray();
    }

    protected Object[] delegateToArray(Object[] array) {
        throw new UnsupportedOperationException();
    }

    protected String delegateToString() {
        return this.toString();
    }

    public int indexOf(Object object, int fromIndex) {
        if (object == null) {
            return -1;
        }
        return this.getIndex(object, fromIndex, false);
    }

    public int lastIndexOf(Object object, int fromIndex) {
        if (object == null) {
            return -1;
        }
        return this.getIndex(object, fromIndex, true);
    }
}

