/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.resources.database.internal.impl;

import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Collection;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.hyades.models.hierarchy.extensions.ExtensionsFactory;
import org.eclipse.hyades.models.hierarchy.extensions.Query;
import org.eclipse.hyades.models.hierarchy.extensions.QueryResult;
import org.eclipse.hyades.models.hierarchy.extensions.ResultEntry;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery;
import org.eclipse.hyades.models.hierarchy.util.PerfUtil;
import org.eclipse.hyades.resources.database.internal.DBMap;
import org.eclipse.hyades.resources.database.internal.extensions.JDBCHelper;
import org.eclipse.hyades.resources.database.internal.impl.DBCommand;
import org.eclipse.hyades.resources.database.internal.impl.IndirectedList;
import org.eclipse.hyades.resources.database.internal.impl.SQLStatement;
import org.eclipse.hyades.resources.database.internal.impl.StatementFactory;
import org.eclipse.hyades.resources.database.internal.impl.WeakObjectCache;

public class SimpleSearchCommand
extends DBCommand {
    private SimpleSearchQuery query;
    private ResourceSet resourceSet;
    private WeakObjectCache cache;
    private Collection notLoadedClasses;

    public Object execute() throws Exception {
        SQLStatement ssqs = StatementFactory.INSTANCE.createSimpleSearchQueryStatement(this.helper, this.dbMap, this.query);
        String s = ssqs.getStatement();
        QueryResult queryResult = ExtensionsFactory.eINSTANCE.createQueryResult();
        queryResult.setQuery((Query)this.query);
        Statement st = this.helper.createStatement(1004, 1007);
        PerfUtil p = new PerfUtil("SimpleSearchCommand.execute() 1 statement=" + s, true);
        try {
            this.helper.executeQuery(st, s);
        }
        catch (Exception e) {
            p.stopAndPrintStatus(e.getLocalizedMessage());
            throw e;
        }
        p.stopAndPrintStatus();
        ResultSet rs = st.getResultSet();
        int i = 0;
        while (i < this.query.getOutputElements().size()) {
            Object objects;
            if (this.query.isCount()) {
                objects = new BasicEList();
                rs.absolute(1);
                Integer count = new Integer(rs.getInt(i + 1));
                objects.add((Object)count);
            } else {
                objects = new IndirectedList(this.helper, this.dbMap, this.cache, (Query)this.query, s, this.resourceSet, this.notLoadedClasses, rs, i);
            }
            ResultEntry resultEntry = ExtensionsFactory.eINSTANCE.createResultEntry();
            resultEntry.setValue(objects);
            queryResult.getResultEntries().add((Object)resultEntry);
            ++i;
        }
        return queryResult;
    }

    public SimpleSearchCommand(JDBCHelper helper, DBMap map, SimpleSearchQuery query, ResourceSet resourceSet, WeakObjectCache cache, Collection notLoadedClasses) {
        super(helper, map);
        this.query = query;
        this.resourceSet = resourceSet;
        this.cache = cache;
        this.notLoadedClasses = notLoadedClasses;
    }
}

