/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.sd.logc.internal.loader;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.hyades.models.cbe.CBECommonBaseEvent;
import org.eclipse.hyades.models.cbe.CBEPackage;
import org.eclipse.hyades.models.cbe.util.LogQueryBuilder;
import org.eclipse.hyades.models.hierarchy.HierarchyPackage;
import org.eclipse.hyades.models.hierarchy.TRCAgent;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.extensions.BinaryExpression;
import org.eclipse.hyades.models.hierarchy.extensions.ExtensionsFactory;
import org.eclipse.hyades.models.hierarchy.extensions.LogicalExpression;
import org.eclipse.hyades.models.hierarchy.extensions.Operand;
import org.eclipse.hyades.models.hierarchy.extensions.Query;
import org.eclipse.hyades.models.hierarchy.extensions.QueryResult;
import org.eclipse.hyades.models.hierarchy.extensions.RelationalOperators;
import org.eclipse.hyades.models.hierarchy.extensions.ResultEntry;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleOperand;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery;
import org.eclipse.hyades.models.hierarchy.util.HierarchyResourceSetImpl;
import org.eclipse.hyades.models.hierarchy.util.ILogFilterCriteria;
import org.eclipse.hyades.sd.logc.SDLogcPlugin;
import org.eclipse.hyades.sd.logc.SDLogcPluginImages;
import org.eclipse.hyades.sd.logc.internal.loader.LogInteractions;
import org.eclipse.hyades.trace.ui.filters.internal.dialogs.FilterUIUtil;
import org.eclipse.hyades.uml2sd.ui.core.LifelineCategories;

public class LogThreadInteractions
extends LogInteractions {
    private List threadIDs = new UniqueEList();

    protected void loadEventsXMI() {
        if (!this.isDisplayingOnlyCorrelations()) {
            this.loadThreadIdsFromAgentList(true);
        } else {
            this.loadThreadIdsFromAgentList(false);
            this.loadEventsFromCorrelationsXMI();
        }
    }

    private void loadThreadIdsFromAgentList(boolean addEvents) {
        Iterator iter = this.agentsList.iterator();
        while (iter.hasNext()) {
            TRCAgentProxy trcAgentProxy = (TRCAgentProxy)iter.next();
            if (trcAgentProxy == null || trcAgentProxy.eIsProxy()) continue;
            this.loadThreadIdsFromAgent(trcAgentProxy);
            if (!addEvents) continue;
            this.addEvents(trcAgentProxy);
        }
        if (this.eventsList != null && this.eventsList.size() > 0) {
            Collections.sort(this.eventsList, this.getComparator());
        }
    }

    private void loadThreadIdsFromAgent(TRCAgentProxy agentProxy) {
        EList events = agentProxy.getAgent().getDefaultEvents();
        CBECommonBaseEvent artifact = null;
        String threadID = null;
        Iterator iter = events.iterator();
        while (iter.hasNext()) {
            artifact = (CBECommonBaseEvent)iter.next();
            threadID = artifact.getSourceComponentId().getThreadId();
            if (threadID == null) {
                threadID = "-1";
            }
            this.threadIDs.add(agentProxy.getName() + " - " + "TID:" + threadID);
        }
    }

    protected void generateLifelines() {
        String id = null;
        Iterator iter = this.getLifelineArtifactsList().iterator();
        while (iter.hasNext()) {
            id = (String)iter.next();
            LogInteractions.TraceLifeline lifeLine = new LogInteractions.TraceLifeline();
            lifeLine.setName(id);
            lifeLine.setCategory(0);
            this.frame.addLifeLine(lifeLine);
            this.lifelinesMap.put(id, lifeLine);
        }
    }

    protected Object getLifelinesMapKey(CBECommonBaseEvent element) {
        String threadID = element.getSourceComponentId().getThreadId();
        if (threadID == null) {
            threadID = "-1";
        }
        return element.getAgent().getAgentProxy().getName() + " - " + "TID:" + threadID;
    }

    public String getTitleString() {
        StringBuffer title = new StringBuffer();
        title.append(SDLogcPlugin.getString("STR_VIEW_TITLE"));
        title.append(": ");
        title.append(SDLogcPlugin.getString("STR_MENU_LOT"));
        title.append(" ");
        if (this.correlationContainerProxy != null) {
            title.append("<");
            title.append(this.correlationContainerProxy.getCorrelationEngine().getName());
            title.append("> ");
        } else {
            title.append("   ");
        }
        title.append("(");
        title.append(this.getFrameName());
        title.append(")");
        return title.toString();
    }

    protected List getLifelineArtifactsList() {
        return this.threadIDs;
    }

    protected void clearDiagramCaches() {
        this.threadIDs.clear();
        super.clearDiagramCaches();
    }

    protected String getFrameTitle() {
        return SDLogcPlugin.getString("STR_MENU_LOT");
    }

    protected void loadEventsSQL() {
        this.loadThreadIDsSQL();
        super.loadEventsSQL();
    }

    private static List getANDArguments(SimpleSearchQuery query) {
        return ((LogicalExpression)query.getWhereExpression()).getArguments();
    }

    private void loadThreadIDsSQL() {
        SimpleSearchQuery threadsQuery;
        ArrayList<TRCAgent> aList = new ArrayList<TRCAgent>();
        int i = 0;
        while (i < this.agentsList.size()) {
            aList.add(((TRCAgentProxy)this.agentsList.get(i)).getAgent());
            ++i;
        }
        if (FilterUIUtil.ENABLE_NEW_FILTERING && FilterUIUtil.ENABLE_NEW_FILTERING_FOR_SQL) {
            threadsQuery = this.getQueryForSQL(this.agentsList, false);
            threadsQuery.getOutputElements().clear();
            SimpleOperand operand = ExtensionsFactory.eINSTANCE.createSimpleOperand();
            operand.setType(HierarchyPackage.eINSTANCE.getTRCAgent());
            threadsQuery.getOutputElements().add((Object)operand);
            operand = ExtensionsFactory.eINSTANCE.createSimpleOperand();
            operand.setFeature((EStructuralFeature)CBEPackage.eINSTANCE.getCBEComponentIdentification_ThreadId());
            threadsQuery.getOutputElements().add((Object)operand);
        } else {
            threadsQuery = (SimpleSearchQuery)LogQueryBuilder.createQuery((List)this.agentsList, (ILogFilterCriteria)this.getFilterCriteria(), (EAttribute)CBEPackage.eINSTANCE.getCBEComponentIdentification_ThreadId());
        }
        threadsQuery.getOrderByExpresions().clear();
        BinaryExpression binaryExpression = ExtensionsFactory.eINSTANCE.createBinaryExpression();
        SimpleOperand leftOperand = ExtensionsFactory.eINSTANCE.createSimpleOperand();
        leftOperand.setType(HierarchyPackage.eINSTANCE.getTRCAgent());
        binaryExpression.setLeftOperand((Operand)leftOperand);
        binaryExpression.setOperator(RelationalOperators.EQ_LITERAL);
        LogQueryBuilder.setRightOperandValue((BinaryExpression)binaryExpression, (Object)HierarchyPackage.eINSTANCE.getAbstractDefaultEvent_Agent());
        LogThreadInteractions.getANDArguments(threadsQuery).add(binaryExpression);
        binaryExpression = ExtensionsFactory.eINSTANCE.createBinaryExpression();
        leftOperand = ExtensionsFactory.eINSTANCE.createSimpleOperand();
        leftOperand.setType(HierarchyPackage.eINSTANCE.getAbstractDefaultEvent());
        binaryExpression.setLeftOperand((Operand)leftOperand);
        binaryExpression.setOperator(RelationalOperators.EQ_LITERAL);
        LogQueryBuilder.setRightOperandValue((BinaryExpression)binaryExpression, (Object)CBEPackage.eINSTANCE.getCBECommonBaseEvent());
        LogThreadInteractions.getANDArguments(threadsQuery).add(binaryExpression);
        binaryExpression = ExtensionsFactory.eINSTANCE.createBinaryExpression();
        leftOperand = ExtensionsFactory.eINSTANCE.createSimpleOperand();
        leftOperand.setType(CBEPackage.eINSTANCE.getCBEComponentIdentification());
        binaryExpression.setLeftOperand((Operand)leftOperand);
        binaryExpression.setOperator(RelationalOperators.EQ_LITERAL);
        LogQueryBuilder.setRightOperandValue((BinaryExpression)binaryExpression, (Object)CBEPackage.eINSTANCE.getCBECommonBaseEvent_SourceComponentId());
        LogThreadInteractions.getANDArguments(threadsQuery).add(binaryExpression);
        threadsQuery.setDistinct(true);
        QueryResult queryResult = LogQueryBuilder.executeQuery((Query)threadsQuery, (ResourceSet)HierarchyResourceSetImpl.getInstance());
        if (queryResult != null) {
            ResultEntry resultEntry = (ResultEntry)queryResult.getResultEntries().get(0);
            List agents = (List)resultEntry.getValue();
            resultEntry = (ResultEntry)queryResult.getResultEntries().get(1);
            List threads = (List)resultEntry.getValue();
            if (agents != null && agents.size() > 0) {
                int s = agents.size();
                String threadId = null;
                TRCAgent agent = null;
                int i2 = 0;
                while (i2 < s) {
                    agent = (TRCAgent)agents.get(i2);
                    threadId = (String)threads.get(i2);
                    if (agent != null) {
                        if (threadId == null) {
                            threadId = "-1";
                        }
                        this.threadIDs.add(agent.getAgentProxy().getName() + " - " + "TID:" + threadId);
                    }
                    ++i2;
                }
            }
        }
    }

    static {
        LogInteractions.traceCategories = new LifelineCategories[1];
        LogInteractions.traceCategories[0] = new LifelineCategories();
        LogInteractions.traceCategories[0].setName("");
        LogInteractions.image = SDLogcPluginImages.getImage("thread_obj.gif");
        LogInteractions.traceCategories[0].setImage(LogInteractions.image);
    }
}

