/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.sd.logc.internal.preferences;

import java.text.MessageFormat;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.hyades.sd.logc.SDLogcPlugin;
import org.eclipse.hyades.sd.logc.internal.preferences.ILogInteractionsPreferenceListener;
import org.eclipse.hyades.uml2sd.ui.load.IUml2SDLoader;
import org.eclipse.hyades.uml2sd.ui.load.LoadersManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class LogInteractionsPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage,
ModifyListener {
    private Text txtPageSize;

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 10;
        layout.marginHeight = 5;
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        Label note = new Label(composite, 64);
        note.setText(SDLogcPlugin.getString("PAGE_SIZE_NOTE"));
        GridData data = new GridData();
        data.horizontalSpan = 2;
        data.widthHint = 375;
        note.setLayoutData((Object)data);
        Label dummy = new Label(composite, 0);
        data = new GridData();
        data.horizontalSpan = 2;
        data.grabExcessHorizontalSpace = true;
        dummy.setLayoutData((Object)data);
        Label label = new Label(composite, 0);
        label.setText(SDLogcPlugin.getString("STR_PAGE_SIZE"));
        this.txtPageSize = new Text(composite, 2048);
        this.txtPageSize.setTextLimit(5);
        data = new GridData();
        data.widthHint = this.convertWidthInCharsToPixels(7);
        this.txtPageSize.setLayoutData((Object)data);
        this.txtPageSize.setText(this.getPreferenceStore().getString("page_size"));
        this.txtPageSize.addModifyListener((ModifyListener)this);
        return composite;
    }

    public IPreferenceStore getPreferenceStore() {
        return SDLogcPlugin.getDefault().getPreferenceStore();
    }

    public void init(IWorkbench workbench) {
    }

    private void initializeDefaults() {
        this.txtPageSize.setText(this.getPreferenceStore().getDefaultString("page_size"));
    }

    protected void performDefaults() {
        this.initializeDefaults();
    }

    public boolean performOk() {
        this.storeValues();
        IUml2SDLoader loader = LoadersManager.getLoadersManager().getCurrentLoader("org.eclipse.hyades.sd.logc.LogInteractionsView");
        if (loader instanceof ILogInteractionsPreferenceListener) {
            ((ILogInteractionsPreferenceListener)loader).applyPreferences();
        }
        return true;
    }

    private void storeValues() {
        this.getPreferenceStore().setValue("page_size", this.txtPageSize.getText());
    }

    public void modifyText(ModifyEvent e) {
        IStatus status = this.validateInput();
        this.setValid(status.getSeverity() == 0);
        if (status.getSeverity() == 4) {
            this.setErrorMessage(status.getMessage());
        } else {
            this.setErrorMessage(null);
        }
    }

    private IStatus validateInput() {
        String nrOfPages = this.txtPageSize.getText();
        PreferenceStatus status = new PreferenceStatus();
        if (nrOfPages.length() == 0) {
            status.setMessage(SDLogcPlugin.getString("EMPTY_FIELD_MSG"));
            status.setSeverity(4);
        } else {
            try {
                int value = Integer.parseInt(nrOfPages);
                if (value <= 0) {
                    status.setMessage(MessageFormat.format(SDLogcPlugin.getString("INVALID_PAGE_SIZE"), nrOfPages));
                    status.setSeverity(4);
                }
            }
            catch (NumberFormatException e) {
                status.setMessage(MessageFormat.format(SDLogcPlugin.getString("INVALID_PAGE_SIZE"), nrOfPages));
                status.setSeverity(4);
            }
        }
        return status;
    }

    class PreferenceStatus
    extends Status {
        public PreferenceStatus() {
            super(0, "hyades.sd.logc", 0, "", null);
        }

        protected void setMessage(String message) {
            super.setMessage(message);
        }

        protected void setSeverity(int severity) {
            super.setSeverity(severity);
        }
    }
}

