/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.log.ui.internal.views;

import org.eclipse.hyades.log.ui.internal.LogUIPlugin;
import org.eclipse.hyades.models.hierarchy.extensions.ExtensionsFactory;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery;
import org.eclipse.hyades.models.hierarchy.extensions.TimeBasedCorrelationQuery;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class LogFiltersOptionsUI {
    private Button showCorrelationButton;

    public Composite createControl(Composite parent) {
        Composite correlationOptions = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        correlationOptions.setLayout((Layout)layout);
        correlationOptions.setLayoutData((Object)GridUtil.createHorizontalFill());
        this.showCorrelationButton = new Button(correlationOptions, 32);
        this.showCorrelationButton.setText(LogUIPlugin.getResourceString("STR_FILTER_SHOW_CORRELATION_ONLY"));
        return correlationOptions;
    }

    public Button getShowCorrelationButton() {
        return this.showCorrelationButton;
    }

    public void setShowCorrelationButton(Button button) {
        this.showCorrelationButton = button;
    }

    public void initializeFrom(SimpleSearchQuery simpleSearchQuery) {
        if (simpleSearchQuery instanceof TimeBasedCorrelationQuery) {
            this.showCorrelationButton.setSelection(true);
        } else {
            this.showCorrelationButton.setSelection(false);
        }
    }

    public SimpleSearchQuery performApply() {
        if (this.showCorrelationButton.getSelection()) {
            return ExtensionsFactory.eINSTANCE.createTimeBasedCorrelationQuery();
        }
        return ExtensionsFactory.eINSTANCE.createSimpleSearchQuery();
    }
}

