/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.log.ui.internal.views;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.analysis.engine.ILogAnalyzer;
import org.eclipse.hyades.log.ui.internal.LogUIPlugin;
import org.eclipse.hyades.log.ui.internal.util.ContextIds;
import org.eclipse.hyades.log.ui.internal.util.ProgressMonitorAdapter;
import org.eclipse.hyades.log.ui.internal.views.ExtensionPointHandler;
import org.eclipse.hyades.log.ui.internal.views.LogAnalyzerWrapper;
import org.eclipse.hyades.log.ui.internal.views.LogContentProvider;
import org.eclipse.hyades.log.ui.internal.views.LogViewer;
import org.eclipse.hyades.log.ui.internal.views.LogViewerUI;
import org.eclipse.hyades.models.cbe.CBECommonBaseEvent;
import org.eclipse.hyades.models.hierarchy.CorrelationContainerProxy;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.help.WorkbenchHelp;

public class LogPaneTreeViewer
extends TreeViewer {
    private LogViewerUI _logViewUI = null;
    private ExtensionPointHandler eph = ExtensionPointHandler.getExtensionPointHandler();
    private Collection _analyzedObjects;
    private ISelection sel;
    protected Action _updateAction;
    protected Action _analyzeAllAction;
    protected Action _analyzeAction;
    protected boolean _enableAnalyze = true;
    public static final int NO_ANALYZE = -1;
    public static final int ANALYZE_SEL = 0;
    public static final int ANALYZE_ALL = 1;
    private static Hashtable _analyzeActionForRuntimeIDs = new Hashtable();
    private static Hashtable _analyzeObjectsForRuntimeIds = new Hashtable();

    private static String getIdForObject(EObject eObj) {
        String id = null;
        if (eObj instanceof TRCAgentProxy) {
            TRCAgentProxy ap = (TRCAgentProxy)eObj;
            id = ap.getProcessProxy().getNode().eResource().getURI().toString() + "." + ap.getName() + "." + ap.hashCode();
        } else if (eObj instanceof CorrelationContainerProxy) {
            CorrelationContainerProxy ap = (CorrelationContainerProxy)eObj;
            id = ap.getName() + "." + ap.hashCode();
        } else {
            id = "" + eObj.hashCode();
        }
        return id;
    }

    private static Collection getAnalyzeObjectsForAgent(EObject eObj) {
        String id = LogPaneTreeViewer.getIdForObject(eObj);
        if (id != null) {
            return (Collection)_analyzeObjectsForRuntimeIds.get(id);
        }
        return null;
    }

    private static void putAnalyzeObjectsForAgent(EObject eObj, Collection objects) {
        String id = LogPaneTreeViewer.getIdForObject(eObj);
        if (id != null && objects != null) {
            _analyzeObjectsForRuntimeIds.put(id, objects);
        }
    }

    private static IAction getAnalyzeActionForAgent(EObject eObj) {
        String id = LogPaneTreeViewer.getIdForObject(eObj);
        if (id != null) {
            return (IAction)_analyzeActionForRuntimeIDs.get(id);
        }
        return null;
    }

    private static void putAnalyzeActionForAgent(EObject eObj, IAction action) {
        String id = LogPaneTreeViewer.getIdForObject(eObj);
        if (id != null) {
            _analyzeActionForRuntimeIDs.put(id, action);
        }
        if (eObj instanceof CorrelationContainerProxy) {
            CorrelationContainerProxy cor = (CorrelationContainerProxy)eObj;
            EList list = cor.getCorrelatedAgents();
            int i = 0;
            while (i < list.size()) {
                LogPaneTreeViewer.putAnalyzeActionForAgent((EObject)list.get(i), action);
                ++i;
            }
        }
    }

    public void enableAnalyze(boolean enable) {
        this._enableAnalyze = enable;
    }

    public LogPaneTreeViewer(LogViewerUI logViewUI, Composite parent, String role) {
        super(parent);
        this._logViewUI = logViewUI;
        this._updateAction = new UpdateAction(LogUIPlugin.getResourceString("REFRESH_VIEWS"));
    }

    public void setContentProvider(IContentProvider contentProvider) {
        super.setContentProvider(contentProvider);
        AnalyzeAction action = (AnalyzeAction)LogPaneTreeViewer.getAnalyzeActionForAgent(this._logViewUI.getViewerPage().getMOFObject());
        this._analyzedObjects = LogPaneTreeViewer.getAnalyzeObjectsForAgent(this._logViewUI.getViewerPage().getMOFObject());
        if (action != null) {
            if (this.get_analyzeAllAction() == null) {
                this._analyzeAllAction = new AnalyzeAction(action.getText(), action.getLogAnalyzer(), true);
            }
            if (this.get_analyzeAction() == null) {
                this._analyzeAction = new AnalyzeAction(action.getText(), action.getLogAnalyzer(), false);
            }
            if (action.analyzeAll) {
                ((LogContentProvider)this.getContentProvider()).setAnalyzeAction((IAction)this.get_analyzeAllAction());
            } else {
                ((LogContentProvider)this.getContentProvider()).setAnalyzeAction((IAction)this.get_analyzeAction());
            }
        }
    }

    public void setMenuListener(IMenuListener menuListener) {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(menuListener);
        Menu menu = menuMgr.createContextMenu(this.getControl());
        this.getControl().setMenu(menu);
    }

    public void addSelectionListener(SelectionListener listener) {
        ((Tree)this.getControl()).addSelectionListener(listener);
    }

    public void fillContextMenu(IMenuManager menu) {
        ISelection sel = this.getSelection();
        if (sel instanceof IStructuredSelection && !sel.isEmpty()) {
            this.updateMenu(menu, ((IStructuredSelection)sel).getFirstElement());
        }
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this._updateAction);
        menu.add((IContributionItem)new Separator());
        menu.add((IContributionItem)new Separator("additions"));
    }

    public void updateMenu(IMenuManager menu, Object logObject) {
        ISelection sel = this.getSelection();
        if (sel instanceof IStructuredSelection) {
            MenuManager manager = new MenuManager(LogUIPlugin.getResourceString("STR_ANALYZE_ACT"));
            menu.add((IContributionItem)manager);
            this.fillMenu((IContributionManager)manager, logObject);
            menu.add((IContributionItem)new Separator());
            manager = new MenuManager(LogUIPlugin.getResourceString("STR_ANALYZE_ALL_ACT"));
            menu.add((IContributionItem)manager);
            this.fillMenu((IContributionManager)manager);
        }
    }

    public void dispose() {
        List logAnalyzers = this.eph.getLogAnalyzers();
        Iterator iter = logAnalyzers.iterator();
        while (iter.hasNext()) {
            ILogAnalyzer element = ((ExtensionPointHandler.ConfigurationElement)iter.next()).getAnalyzer();
            element.unloadDatabase();
        }
    }

    public void resetAnalyzedObjects() {
        this._analyzedObjects = null;
    }

    public Collection getAnalyzedObjects() {
        if (this._analyzedObjects == null) {
            this._analyzedObjects = new HashSet();
        }
        return this._analyzedObjects;
    }

    private List getObjectsToAnalyze(int option) {
        if (option == 0) {
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    LogPaneTreeViewer.this.sel = LogPaneTreeViewer.this.getSelection();
                }
            });
            ArrayList<CBECommonBaseEvent> objects = new ArrayList<CBECommonBaseEvent>();
            if (this.sel instanceof IStructuredSelection) {
                Iterator iterator = ((IStructuredSelection)this.sel).iterator();
                Object object = null;
                while (iterator.hasNext()) {
                    object = iterator.next();
                    if (object == null || !(object instanceof CBECommonBaseEvent)) continue;
                    this.getAnalyzedObjects().add(((CBECommonBaseEvent)object).getGlobalInstanceId());
                }
            }
            List input = ((LogContentProvider)this.getContentProvider()).getPageList(this.getInput());
            boolean inputXMI = ((LogContentProvider)this.getContentProvider()).isInputXMI(this.getInput());
            int i = 0;
            while (i < input.size()) {
                Object object = input.get(i);
                if (object instanceof CBECommonBaseEvent) {
                    CBECommonBaseEvent element = (CBECommonBaseEvent)object;
                    if (this.getAnalyzedObjects().contains(element.getGlobalInstanceId())) {
                        objects.add(element);
                    } else if (inputXMI && element.isAnalyzed()) {
                        objects.add(element);
                    }
                }
                ++i;
            }
            return objects;
        }
        if (option == 1) {
            this.getAnalyzedObjects().clear();
            return ((LogContentProvider)this.getContentProvider()).getPageList(this.getInput());
        }
        return Collections.EMPTY_LIST;
    }

    private boolean isObjectInList(String globalInstanceID, List input) {
        int s = input.size();
        int i = 0;
        while (i < s) {
            if (((CBECommonBaseEvent)input.get(i)).getGlobalInstanceId().equals(globalInstanceID)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void fillMenu(IContributionManager innerMgr) {
        innerMgr.removeAll();
        List logAnalyzers = this.eph.getLogAnalyzers();
        if (logAnalyzers != null) {
            Iterator iter = logAnalyzers.iterator();
            while (iter.hasNext()) {
                ExtensionPointHandler.ConfigurationElement config = (ExtensionPointHandler.ConfigurationElement)iter.next();
                ILogAnalyzer analyzer = config.getAnalyzer();
                this._analyzeAllAction = new AnalyzeAction(config.getName(), new LogAnalyzerWrapper(analyzer), true);
                innerMgr.add((IAction)this._analyzeAllAction);
            }
        }
    }

    private void fillMenu(IContributionManager innerMgr, Object logObject) {
        innerMgr.removeAll();
        List logAnalyzers = this.eph.getLogAnalyzer(logObject);
        if (logAnalyzers != null) {
            Iterator iter = logAnalyzers.iterator();
            while (iter.hasNext()) {
                ExtensionPointHandler.ConfigurationElement config = (ExtensionPointHandler.ConfigurationElement)iter.next();
                ILogAnalyzer analyzer = config.getAnalyzer();
                this._analyzeAction = new AnalyzeAction(config.getName(), new LogAnalyzerWrapper(analyzer), false);
                innerMgr.add((IAction)this._analyzeAction);
            }
        }
    }

    public Action get_analyzeAction() {
        return this._analyzeAction;
    }

    public Action get_analyzeAllAction() {
        return this._analyzeAllAction;
    }

    static /* synthetic */ void access$300(EObject x0, IAction x1) {
        LogPaneTreeViewer.putAnalyzeActionForAgent(x0, x1);
    }

    static /* synthetic */ List access$400(LogPaneTreeViewer x0, int x1) {
        return x0.getObjectsToAnalyze(x1);
    }

    class AnalyzeAction
    extends BasicLoadAction {
        boolean analyzeAll = false;
        protected List sel;
        protected LogAnalyzerWrapper aLogAnalyzer;
        protected List result;

        public AnalyzeAction(String label, LogAnalyzerWrapper logAnalyzer) {
            super(label, logAnalyzer);
        }

        public AnalyzeAction(String label, LogAnalyzerWrapper logAnalyzer, boolean analyzeAll) {
            super(label, logAnalyzer);
            this.analyzeAll = analyzeAll;
        }

        public void run() {
            if (LogPaneTreeViewer.this._enableAnalyze) {
                IRunnableWithProgress analyze = new IRunnableWithProgress(this){
                    private final /* synthetic */ AnalyzeAction this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run(IProgressMonitor m) {
                        ProgressMonitorAdapter monitor = new ProgressMonitorAdapter(m);
                        ((LogContentProvider)AnalyzeAction.access$200(this.this$1).getContentProvider()).setAnalyzeAction((IAction)this.this$1);
                        LogPaneTreeViewer.access$300(LogPaneTreeViewer.access$000(AnalyzeAction.access$200(this.this$1)).getViewerPage().getMOFObject(), (IAction)this.this$1);
                        List listToAnalyze = LogPaneTreeViewer.access$400(AnalyzeAction.access$200(this.this$1), this.this$1.analyzeAll ? 1 : 0);
                        monitor.beginTask(LogUIPlugin.getResourceString("STR_ANALYZE_PROGRESS"), listToAnalyze.size());
                        monitor.subTask(LogUIPlugin.getResourceString("STR_ANALYZE_LOAD_DB"));
                        this.this$1.getLogAnalyzer().loadDatabase();
                        if (this.this$1.getLogAnalyzer().errorMsg() == null) {
                            if (this.this$1.result == null) {
                                this.this$1.result = new ArrayList<E>();
                            }
                            this.this$1.getLogAnalyzer().analyze(listToAnalyze, this.this$1.result, monitor);
                        }
                        monitor.done();
                    }
                };
                try {
                    LogUIPlugin.getActiveWorkbenchWindow().run(true, true, analyze);
                }
                catch (Exception e) {
                    LogUIPlugin.log(e);
                }
                if (this.getLogAnalyzer().errorMsg() != null) {
                    MessageDialog.openError((Shell)LogPaneTreeViewer.this.getControl().getShell(), (String)LogUIPlugin.getResourceString("STR_LOG_MSG"), (String)this.getLogAnalyzer().errorMsg());
                    LogPaneTreeViewer.this._analyzedObjects = LogPaneTreeViewer.getAnalyzeObjectsForAgent(LogPaneTreeViewer.this._logViewUI.getViewerPage().getMOFObject());
                    return;
                }
                ((LogContentProvider)LogPaneTreeViewer.this.getContentProvider()).setAnalyzed(true);
                LogPaneTreeViewer.this.refresh();
                ((LogContentProvider)LogPaneTreeViewer.this.getContentProvider()).setAnalyzed(false);
                LogPaneTreeViewer.putAnalyzeObjectsForAgent(LogPaneTreeViewer.this._logViewUI.getViewerPage().getMOFObject(), LogPaneTreeViewer.this._analyzedObjects);
                if (((Tree)LogPaneTreeViewer.this.getControl()).getSelection().length > 0) {
                    Event event = new Event();
                    event.item = ((Tree)LogPaneTreeViewer.this.getControl()).getSelection()[0];
                    LogPaneTreeViewer.this.getControl().notifyListeners(13, event);
                }
            }
        }

        static /* synthetic */ LogPaneTreeViewer access$200(AnalyzeAction x0) {
            return x0.LogPaneTreeViewer.this;
        }
    }

    abstract class BasicLoadAction
    extends Action {
        private LogAnalyzerWrapper logAnalyzer = null;

        public BasicLoadAction(String label, LogAnalyzerWrapper logAnalyzer) {
            super(label);
            this.logAnalyzer = logAnalyzer;
        }

        public LogAnalyzerWrapper getLogAnalyzer() {
            return this.logAnalyzer;
        }

        public boolean isEnabled() {
            return true;
        }
    }

    class UpdateAction
    extends Action {
        public UpdateAction(String name) {
            super(name);
            WorkbenchHelp.setHelp((IAction)this, (String)ContextIds.ACTLOG_VIEW_POPUP_REFRESH);
        }

        public void run() {
            ((LogViewer)LogPaneTreeViewer.this._logViewUI.getViewerPage().getTraceViewer()).refresh();
        }
    }
}

